/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.config.SystemPropertiesAccess;
import com.sun.appserv.management.config.SystemPropertyConfig;
import com.sun.jsftemplating.layout.LayoutViewHandler;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.model.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.TargetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EESupportHandlers {
    public static void getClustersList(HandlerContext handlerCtx) {
        Set clusterSet = AMXRoot.getInstance().getClustersConfig().getClusterConfigMap().keySet();
        ArrayList sortedClusterList = new ArrayList(new TreeSet(clusterSet));
        handlerCtx.setOutputValue("clusterList", sortedClusterList);
        handlerCtx.setOutputValue("hasCluster", (Object)(sortedClusterList.size() > 0 ? 1 : 0));
    }

    public static void getStandaloneServerList(HandlerContext handlerCtx) {
        Set serverSet = AMXRoot.getInstance().getServersConfig().getStandaloneServerConfigMap().keySet();
        ArrayList sortedServerList = new ArrayList(new TreeSet(serverSet));
        handlerCtx.setOutputValue("serverList", sortedServerList);
    }

    public static void getAllServerList(HandlerContext handlerCtx) {
        AMXRoot amxRoot = AMXRoot.getInstance();
        Set standaloneSet = amxRoot.getServersConfig().getStandaloneServerConfigMap().keySet();
        Set clusteredSet = amxRoot.getServersConfig().getClusteredServerConfigMap().keySet();
        ArrayList serverList = new ArrayList(standaloneSet);
        serverList.addAll(clusteredSet);
        handlerCtx.setOutputValue("serverList", serverList);
    }

    public static void getAllVSList(HandlerContext handlerCtx) {
        String targetName = (String)handlerCtx.getInputValue("targetName");
        Boolean PE = (Boolean)handlerCtx.getInputValue("PE");
        Set vsList = TargetUtil.getVirtualServers((String)targetName);
        ArrayList<String> serverList = new ArrayList<String>(vsList);
        if (PE != null && PE.booleanValue()) {
            String noneSelected = GuiUtil.getMessage((String)"deploy.option.NoneSelected");
            serverList.add(0, noneSelected);
        }
        boolean remove = serverList.remove("__asadmin");
        handlerCtx.setOutputValue("serverList", serverList);
    }

    public static void getAllTargetList(HandlerContext handlerCtx) {
        AMXRoot amxRoot = AMXRoot.getInstance();
        Set standaloneSet = amxRoot.getServersConfig().getStandaloneServerConfigMap().keySet();
        Set clusterSet = amxRoot.getClustersConfig().getClusterConfigMap().keySet();
        TreeSet allTargets = new TreeSet();
        allTargets.addAll(standaloneSet);
        allTargets.addAll(clusterSet);
        ArrayList targetList = new ArrayList(allTargets);
        handlerCtx.setOutputValue("allTargetList", targetList);
    }

    public static void getServersOfCluster(HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        ArrayList servers = new ArrayList();
        if (GuiUtil.isEmpty((String)clusterName)) {
            System.out.println("getServerOfCluster:  clusterName is empty, no server is returned.");
            handlerCtx.setOutputValue("serverList", servers);
            return;
        }
        ClusterConfig cluster = (ClusterConfig)AMXRoot.getInstance().getClustersConfig().getClusterConfigMap().get(clusterName);
        if (cluster == null) {
            System.out.println("getServerofCluster:  cluster does not exist --  " + clusterName);
            handlerCtx.setOutputValue("serverList", servers);
            return;
        }
        Set serverSet = cluster.getClusteredServerConfigMap().keySet();
        ArrayList sortedServerList = new ArrayList(new TreeSet(serverSet));
        handlerCtx.setOutputValue("serverList", sortedServerList);
    }

    public static void getConfigurationsList(HandlerContext handlerCtx) {
        Set configSet = AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().keySet();
        ArrayList sortedConfigList = new ArrayList(new TreeSet(configSet));
        handlerCtx.setOutputValue("configList", sortedConfigList);
    }

    public static void buildAllClusters(HandlerContext handlerCtx) {
        List clusterList = (List)handlerCtx.getInputValue("clusterList");
        UIComponent parent = (UIComponent)handlerCtx.getInputValue("parent");
        LayoutElement elt = (LayoutElement)handlerCtx.getInputValue("layoutElement");
        if (clusterList == null || clusterList.size() <= 1) {
            return;
        }
        Map reqMap = handlerCtx.getFacesContext().getExternalContext().getRequestMap();
        for (int index = 1; index < clusterList.size(); ++index) {
            reqMap.put("clusterId", "cluster" + index);
            reqMap.put("ignored", "false");
            reqMap.put("clusterName", clusterList.get(index));
            LayoutViewHandler.buildUIComponentTree((FacesContext)handlerCtx.getFacesContext(), (UIComponent)parent, (LayoutElement)elt);
        }
    }

    public static void buildAllConfiguration(HandlerContext handlerCtx) {
        List configList = (List)handlerCtx.getInputValue("configList");
        UIComponent parent = (UIComponent)handlerCtx.getInputValue("parent");
        LayoutElement elt = (LayoutElement)handlerCtx.getInputValue("layoutElement");
        if (configList == null || configList.size() <= 1) {
            return;
        }
        Map reqMap = handlerCtx.getFacesContext().getExternalContext().getRequestMap();
        for (int index = 1; index < configList.size(); ++index) {
            reqMap.put("configId", "configuration" + index);
            reqMap.put("configName", configList.get(index));
            LayoutViewHandler.buildUIComponentTree((FacesContext)handlerCtx.getFacesContext(), (UIComponent)parent, (LayoutElement)elt);
        }
    }

    public static void createVSReferences(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        String targetName = (String)handlerCtx.getInputValue("targetName");
        String[] selTargets = (String[])handlerCtx.getInputValue("vsTargets");
        String noneSelected = GuiUtil.getMessage((String)"deploy.option.NoneSelected");
        String targets = null;
        if (selTargets.length > 0 && !noneSelected.equals(selTargets[0])) {
            targets = GuiUtil.arrayToString((String[])selTargets, (String)",");
        }
        TargetUtil.setVirtualServers((String)name, (String)targetName, targets);
    }

    public static void createResourceReferences(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        String[] selTargets = (String[])handlerCtx.getInputValue("targets");
        try {
            List<String> targets = Arrays.asList(selTargets);
            List associatedTargets = TargetUtil.getDeployedTargets((String)name, (boolean)false);
            for (String targetName : targets) {
                if (associatedTargets.contains(targetName)) continue;
                TargetUtil.createResourceRef((String)name, (String)targetName);
            }
            for (String targetName : associatedTargets) {
                if (targets.contains(targetName)) continue;
                TargetUtil.removeResourceRef((String)name, (String)targetName);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getTargetsOptionsList(HandlerContext handlerCtx) {
        String defaultTarget;
        AMXRoot amxRoot = AMXRoot.getInstance();
        Set standaloneSet = amxRoot.getServersConfig().getStandaloneServerConfigMap().keySet();
        Set clusteredSet = amxRoot.getClustersConfig().getClusterConfigMap().keySet();
        ArrayList serverList = new ArrayList(standaloneSet);
        serverList.addAll(clusteredSet);
        Option[] availableOptions = null;
        if (serverList != null) {
            availableOptions = new Option[serverList.size()];
            List strList = GuiUtil.convertListOfStrings(serverList);
        }
        if ((defaultTarget = (String)handlerCtx.getInputValue("defaultTarget")) == null) {
            defaultTarget = "server";
        }
        String[] selected = new String[]{defaultTarget};
        if (defaultTarget.trim().equals("")) {
            selected = new String[]{};
        }
        handlerCtx.setOutputValue("SelectedTargets", (Object)selected);
        handlerCtx.setOutputValue("AvailableTargets", (Object)availableOptions);
    }

    public static void getTargetOptions(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        String name = (String)handlerCtx.getInputValue("name");
        List targets = (List)handlerCtx.getInputValue("allTargets");
        List associatedTargets = new ArrayList();
        if (!type.equals("loadBalancer")) {
            boolean isApp = type.equals("application");
            associatedTargets = TargetUtil.getDeployedTargets((String)name, (boolean)isApp);
        }
        Option[] availableOptions = null;
        String[] selectedOptions = null;
        if (targets != null) {
            availableOptions = new Option[targets.size()];
            List strList = GuiUtil.convertListOfStrings((List)targets);
            selectedOptions = associatedTargets.toArray(new String[associatedTargets.size()]);
        }
        handlerCtx.setOutputValue("availableTargets", (Object)availableOptions);
        handlerCtx.setOutputValue("selectedTargets", selectedOptions);
    }

    public static void getVSOptions(HandlerContext handlerCtx) {
        String targetName = (String)handlerCtx.getInputValue("targetName");
        Boolean pe = (Boolean)handlerCtx.getInputValue("PE");
        String name = (String)handlerCtx.getInputValue("name");
        List vsList = (List)handlerCtx.getInputValue("vsList");
        String associatedVS = TargetUtil.getAssociatedVS((String)name, (String)targetName);
        String[] selectedOptions = null;
        if (vsList != null) {
            selectedOptions = GuiUtil.stringToArray((String)associatedVS, (String)",");
            if (pe != null && pe.booleanValue() && selectedOptions != null && selectedOptions.length <= 0) {
                selectedOptions = new String[]{(String)vsList.get(0)};
            }
        }
        handlerCtx.setOutputValue("availableVS", (Object)vsList);
        handlerCtx.setOutputValue("selectedVS", (Object)selectedOptions);
    }

    public static void getConfigurationTargets(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ArrayList result = new ArrayList();
        AMXRoot amxRoot = AMXRoot.getInstance();
        try {
            if (configName != null) {
                Vector targets = EESupportHandlers.getReferencedInstances(configName);
                for (int i = 0; i < targets.size(); ++i) {
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    ServerConfig servConfig = (ServerConfig)targets.get(i);
                    String name = servConfig.getName();
                    oneRow.put("targetname", name);
                    oneRow.put("image", amxRoot.getStatusForDisplay((AMX)amxRoot.getJ2EEDomain().getJ2EEServerMap().get(name), false));
                    if (servConfig instanceof StandaloneServerConfig) {
                        oneRow.put("isCluster", false);
                    } else {
                        oneRow.put("isCluster", true);
                    }
                    result.add(oneRow);
                }
            }
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    private static Vector getReferencedInstances(String configName) {
        String config;
        Vector<StandaloneServerConfig> targets = new Vector<StandaloneServerConfig>();
        AMXRoot amxRoot = AMXRoot.getInstance();
        Map standaloneMap = amxRoot.getServersConfig().getStandaloneServerConfigMap();
        Map clusteredMap = amxRoot.getServersConfig().getClusteredServerConfigMap();
        for (StandaloneServerConfig server : standaloneMap.values()) {
            config = server.getConfigRef();
            if (!config.equalsIgnoreCase(configName)) continue;
            targets.add(server);
        }
        for (StandaloneServerConfig server : clusteredMap.values()) {
            config = server.getConfigRef();
            if (!config.equalsIgnoreCase(configName)) continue;
            targets.add(server);
        }
        return targets;
    }

    private static Map<String, String> getSystemProperties(SystemPropertiesAccess config) {
        Map systemPropertyConfigMap = config.getSystemPropertyConfigMap();
        HashMap<String, String> props = null;
        if (systemPropertyConfigMap.size() != 0) {
            props = new HashMap<String, String>();
            for (SystemPropertyConfig prop : systemPropertyConfigMap.values()) {
                props.put(prop.getName(), prop.getValue());
            }
        }
        return props;
    }

    public static void getSystemProperties(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
        handlerCtx.setOutputValue("DynamicReconfig", (Object)config.getDynamicReconfigurationEnabled());
        ArrayList data = new ArrayList();
        Map<String, String> props = EESupportHandlers.getSystemProperties((SystemPropertiesAccess)config);
        if (props != null) {
            for (String key : props.keySet()) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                String value = props.get(key);
                String valString = value == null ? "" : value.toString();
                oneRow.put("name", key);
                oneRow.put("value", valString);
                oneRow.put("selected", false);
                data.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("Properties", props);
        handlerCtx.setOutputValue("TableList", data);
    }

    public static void saveSystemProperties(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
        config.setDynamicReconfigurationEnabled("" + handlerCtx.getInputValue("DynamicReconfig"));
        Map addProps = (Map)handlerCtx.getInputValue("AddProps");
        ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
        if (removeProps != null) {
            String[] remove = removeProps.toArray(new String[removeProps.size()]);
            for (int i = 0; i < remove.length; ++i) {
                config.removeSystemPropertyConfig(remove[i]);
            }
        }
        if (addProps != null) {
            for (String key : addProps.keySet()) {
                String value = (String)addProps.get(key);
                if (GuiUtil.isEmpty((String)value)) continue;
                if (config.getSystemPropertyConfigMap().containsKey(key)) {
                    ((SystemPropertyConfig)config.getSystemPropertyConfigMap().get(key)).setValue(value);
                    continue;
                }
                config.createSystemPropertyConfig(key, value);
            }
        }
    }

    public static void getInstancevalues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXRoot.getInstance().getConfig(configName);
        String propName = (String)handlerCtx.getInputValue("PropertyName");
        Vector instances = EESupportHandlers.getReferencedInstances(configName);
        ArrayList data = new ArrayList();
        for (int i = 0; i < instances.size(); ++i) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            ServerConfig servConfig = (ServerConfig)instances.get(i);
            String name = servConfig.getName();
            String propValue = "";
            if (servConfig.getSystemPropertyConfigMap().containsKey(propName)) {
                propValue = ((SystemPropertyConfig)servConfig.getSystemPropertyConfigMap().get(propName)).getValue();
            }
            if (servConfig instanceof ClusteredServerConfig) {
                String clusterName = EESupportHandlers.getClusterForServer(name);
                oneRow.put("clusterName", clusterName);
                oneRow.put("isCluster", true);
            } else {
                oneRow.put("clusterName", "");
                oneRow.put("isCluster", false);
            }
            oneRow.put("name", name);
            oneRow.put("value", propValue);
            data.add(oneRow);
        }
        handlerCtx.setOutputValue("InstancesList", data);
    }

    public static void saveInstanceValues(HandlerContext handlerCtx) {
        String propName = (String)handlerCtx.getInputValue("PropertyName");
        AMXRoot amxRoot = AMXRoot.getInstance();
        try {
            List obj;
            List newRows = obj = (List)handlerCtx.getInputValue("PropsList");
            for (Map oneRow : newRows) {
                String instanceName = (String)oneRow.get("name");
                boolean isCluster = (Boolean)oneRow.get("isCluster");
                String propValue = (String)oneRow.get("value");
                if (isCluster) {
                    ClusteredServerConfig clusterConfig = (ClusteredServerConfig)amxRoot.getServersConfig().getClusteredServerConfigMap().get(instanceName);
                    if (clusterConfig.getSystemPropertyConfigMap().containsKey(propName)) {
                        ((SystemPropertyConfig)clusterConfig.getSystemPropertyConfigMap().get(propName)).setValue(propValue);
                        continue;
                    }
                    clusterConfig.createSystemPropertyConfig(propName, propValue);
                    continue;
                }
                StandaloneServerConfig serverConfig = (StandaloneServerConfig)amxRoot.getServersConfig().getStandaloneServerConfigMap().get(instanceName);
                if (serverConfig.getSystemPropertyConfigMap().containsKey(propName)) {
                    ((SystemPropertyConfig)serverConfig.getSystemPropertyConfigMap().get(propName)).setValue(propValue);
                    continue;
                }
                serverConfig.createSystemPropertyConfig(propName, propValue);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void createConfiguration(HandlerContext handlerCtx) {
        String configurationName = (String)handlerCtx.getInputValue("Name");
        String copyFromConfigName = (String)handlerCtx.getInputValue("Config");
        AMXRoot amxRoot = AMXRoot.getInstance();
        try {
            HashMap<String, String> configMap = new HashMap<String, String>();
            if ("default-config".equals(copyFromConfigName)) {
                amxRoot.getConfigsConfig().createConfigConfig(configurationName, configMap);
            } else {
                configMap.put("SrcConfigKey", copyFromConfigName);
                amxRoot.getConfigsConfig().createConfigConfig(configurationName, configMap);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void deleteConfigurations(HandlerContext handlerCtx) {
        List obj;
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                AMXRoot.getInstance().getConfigsConfig().removeConfigConfig(name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static String getClusterForServer(String clusteredInstance) {
        Map clusterConfMap = AMXRoot.getInstance().getClustersConfig().getClusterConfigMap();
        String clusterName = "";
        for (ClusterConfig clusterConf : clusterConfMap.values()) {
            clusterName = clusterConf.getName();
            if (!clusterConf.getClusteredServerConfigMap().containsKey(clusteredInstance)) continue;
            return clusterName;
        }
        return clusterName;
    }
}

