/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.DASConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.JavaConfig;
import com.sun.appserv.management.config.LogServiceConfig;
import com.sun.appserv.management.config.ModuleLogLevelsConfig;
import com.sun.appserv.management.config.ProfilerConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.GuiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerHandlers {
    private static HashMap viewOperationMap = new HashMap();
    private static final String PERSISTENCE_MODULE_PROPERTY = "oracle.toplink.essentials";
    private static final String JAXWS_MODULE_PROPERTY = "javax.enterprise.resource.webservices.jaxws";
    private static final String JBI_MODULE_PROPERTY = "com.sun.jbi";
    private static List skipLogModulePropsList;
    private static final String PATH_SEPARATOR = "${path.separator}";

    public static void getServerDomainAttributes(HandlerContext handlerCtx) {
        DomainConfig domainConfig = AMXRoot.getInstance().getDomainConfig();
        String appRoot = domainConfig.getApplicationRoot();
        String logRoot = domainConfig.getLogRoot();
        String locale = domainConfig.getLocale();
        handlerCtx.setOutputValue("AppRoot", (Object)appRoot);
        handlerCtx.setOutputValue("LogRoot", (Object)logRoot);
        handlerCtx.setOutputValue("Locale", (Object)locale);
    }

    public static void saveServerDomainAttributes(HandlerContext handlerCtx) {
        DomainConfig domainConfig = AMXRoot.getInstance().getDomainConfig();
        domainConfig.setApplicationRoot((String)handlerCtx.getInputValue("AppRoot"));
        domainConfig.setLogRoot((String)handlerCtx.getInputValue("LogRoot"));
        domainConfig.setLocale((String)handlerCtx.getInputValue("Locale"));
    }

    public static void getServerAppsConfigAttributes(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        DASConfig dConfig = config.getAdminServiceConfig().getDASConfig();
        String reload = dConfig.getDynamicReloadEnabled();
        String reloadInterval = dConfig.getDynamicReloadPollIntervalInSeconds();
        String autoDeploy = dConfig.getAutodeployEnabled();
        String adminTimeout = "";
        try {
            adminTimeout = dConfig.getAdminSessionTimeoutInMinutes();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String autoDeployInterval = dConfig.getAutodeployPollingIntervalInSeconds();
        String autoDeployTimeout = dConfig.getAutodeployRetryTimeout();
        String autoDeployDirectory = dConfig.getAutodeployDir();
        String precompile = dConfig.getAutodeployJSPPrecompilationEnabled();
        String verifier = dConfig.getAutodeployVerifierEnabled();
        handlerCtx.setOutputValue("Reload", (Object)reload);
        handlerCtx.setOutputValue("ReloadInterval", (Object)reloadInterval);
        handlerCtx.setOutputValue("AutoDeploy", (Object)autoDeploy);
        handlerCtx.setOutputValue("AdminTimeout", (Object)adminTimeout);
        handlerCtx.setOutputValue("AutoDeployInterval", (Object)autoDeployInterval);
        handlerCtx.setOutputValue("AutoDeployTimeout", (Object)autoDeployTimeout);
        handlerCtx.setOutputValue("AutoDeployDirectory", (Object)autoDeployDirectory);
        handlerCtx.setOutputValue("Precompile", (Object)precompile);
        handlerCtx.setOutputValue("Verifier", (Object)verifier);
        handlerCtx.setOutputValue("Properties", (Object)dConfig.getPropertyConfigMap());
    }

    public static void getServerDefaultAppsConfigAttributes(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map defaultMap = config.getAdminServiceConfig().getDefaultValues("X-DASConfig", true);
        String reload = (String)defaultMap.get("DynamicReloadEnabled");
        String reloadInterval = (String)defaultMap.get("DynamicReloadPollIntervalInSeconds");
        String autoDeploy = (String)defaultMap.get("AutodeployEnabled");
        String adminTimeout = (String)defaultMap.get("AdminSessionTimeoutInMinutes");
        String autoDeployInterval = (String)defaultMap.get("AutodeployPollingIntervalInSeconds");
        String autoDeployTimeout = (String)defaultMap.get("AutodeployRetryTimeout");
        String autoDeployDirectory = (String)defaultMap.get("AutodeployDir");
        String precompile = (String)defaultMap.get("AutodeployJspPrecompilationEnabled");
        String verifier = (String)defaultMap.get("AutodeployVerifierEnabled");
        if ("true".equals(reload)) {
            handlerCtx.setOutputValue("Reload", (Object)true);
        } else {
            handlerCtx.setOutputValue("Reload", (Object)false);
        }
        handlerCtx.setOutputValue("ReloadInterval", (Object)reloadInterval);
        if ("true".equals(autoDeploy)) {
            handlerCtx.setOutputValue("AutoDeploy", (Object)true);
        } else {
            handlerCtx.setOutputValue("AutoDeploy", (Object)false);
        }
        handlerCtx.setOutputValue("AdminTimeout", (Object)adminTimeout);
        handlerCtx.setOutputValue("AutoDeployInterval", (Object)autoDeployInterval);
        handlerCtx.setOutputValue("AutoDeployTimeout", (Object)autoDeployTimeout);
        handlerCtx.setOutputValue("AutoDeployDirectory", (Object)autoDeployDirectory);
        if ("true".equals(precompile)) {
            handlerCtx.setOutputValue("Precompile", (Object)true);
        } else {
            handlerCtx.setOutputValue("Precompile", (Object)false);
        }
        if ("true".equals(verifier)) {
            handlerCtx.setOutputValue("Verifier", (Object)true);
        } else {
            handlerCtx.setOutputValue("Verifier", (Object)false);
        }
    }

    public static void saveServerAppsConfigAttributes(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        DASConfig dConfig = config.getAdminServiceConfig().getDASConfig();
        dConfig.setDynamicReloadEnabled((String)handlerCtx.getInputValue("Reload"));
        dConfig.setDynamicReloadPollIntervalInSeconds((String)handlerCtx.getInputValue("ReloadInterval"));
        dConfig.setAutodeployEnabled((String)handlerCtx.getInputValue("AutoDeploy"));
        dConfig.setAdminSessionTimeoutInMinutes((String)handlerCtx.getInputValue("AdminTimeout"));
        dConfig.setAutodeployPollingIntervalInSeconds((String)handlerCtx.getInputValue("AutoDeployInterval"));
        dConfig.setAutodeployRetryTimeout((String)handlerCtx.getInputValue("AutoDeployTimeout"));
        dConfig.setAutodeployDir((String)handlerCtx.getInputValue("AutoDeployDirectory"));
        dConfig.setAutodeployJSPPrecompilationEnabled((String)handlerCtx.getInputValue("Precompile"));
        dConfig.setAutodeployVerifierEnabled((String)handlerCtx.getInputValue("Verifier"));
        AMXUtil.updateProperties((PropertiesAccess)dConfig, (Map)((Map)handlerCtx.getInputValue("newProps")));
    }

    public static void getServerJvmAttributes(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        JavaConfig javaConfig = config.getJavaConfig();
        String javaHome = javaConfig.getJavaHome();
        String javacOptions = javaConfig.getJavacOptions();
        String debugEnabled = javaConfig.getDebugEnabled();
        String debugOptions = javaConfig.getDebugOptions();
        String rmicOptions = javaConfig.getRMICOptions();
        String bytecodePreprocessors = javaConfig.getBytecodePreprocessors();
        handlerCtx.setOutputValue("JavaHome", (Object)javaHome);
        handlerCtx.setOutputValue("JavacOptions", (Object)javacOptions);
        handlerCtx.setOutputValue("DebugEnabled", (Object)debugEnabled);
        handlerCtx.setOutputValue("DebugOptions", (Object)debugOptions);
        handlerCtx.setOutputValue("RmicOptions", (Object)rmicOptions);
        handlerCtx.setOutputValue("BytecodePreprocessor", (Object)bytecodePreprocessors);
    }

    public static void getDefaultServerModuleLogLevels(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ModuleLogLevelsConfig mConfig = config.getLogServiceConfig().getModuleLogLevelsConfig();
        String admin = mConfig.getDefaultValue("Admin");
        String ejb = mConfig.getDefaultValue("EJBContainer");
        String classLoader = mConfig.getDefaultValue("Classloader");
        String configuration = mConfig.getDefaultValue("Configuration");
        String connector = mConfig.getDefaultValue("Connector");
        String corba = mConfig.getDefaultValue("CORBA");
        String deployment = mConfig.getDefaultValue("Deployment");
        String javamail = mConfig.getDefaultValue("Javamail");
        String jaxr = mConfig.getDefaultValue("JAXR");
        String jaxrpc = mConfig.getDefaultValue("JAXRPC");
        String jms = mConfig.getDefaultValue("JMS");
        String jta = mConfig.getDefaultValue("JTA");
        String jts = mConfig.getDefaultValue("JTS");
        String mdb = mConfig.getDefaultValue("MDBContainer");
        String naming = mConfig.getDefaultValue("Naming");
        String root = mConfig.getDefaultValue("Root");
        String saaj = mConfig.getDefaultValue("SAAJ");
        String security = mConfig.getDefaultValue("Security");
        String selfManagement = mConfig.getDefaultValue("SelfManagement");
        String server = mConfig.getDefaultValue("Server");
        String util = mConfig.getDefaultValue("Util");
        String verifier = mConfig.getDefaultValue("Verifier");
        String web = mConfig.getDefaultValue("WebContainer");
        handlerCtx.setOutputValue("Admin", (Object)admin);
        handlerCtx.setOutputValue("Classloader", (Object)classLoader);
        handlerCtx.setOutputValue("Configuration", (Object)configuration);
        handlerCtx.setOutputValue("Connector", (Object)connector);
        handlerCtx.setOutputValue("Corba", (Object)corba);
        handlerCtx.setOutputValue("Deployment", (Object)deployment);
        handlerCtx.setOutputValue("Javamail", (Object)javamail);
        handlerCtx.setOutputValue("Jaxr", (Object)jaxr);
        handlerCtx.setOutputValue("Jaxrpc", (Object)jaxrpc);
        handlerCtx.setOutputValue("Jms", (Object)jms);
        handlerCtx.setOutputValue("Jta", (Object)jta);
        handlerCtx.setOutputValue("Jts", (Object)jts);
        handlerCtx.setOutputValue("MDB", (Object)mdb);
        handlerCtx.setOutputValue("Naming", (Object)naming);
        handlerCtx.setOutputValue("EJB", (Object)ejb);
        handlerCtx.setOutputValue("Root", (Object)root);
        handlerCtx.setOutputValue("Saaj", (Object)saaj);
        handlerCtx.setOutputValue("Security", (Object)security);
        handlerCtx.setOutputValue("SelfManagement", (Object)selfManagement);
        handlerCtx.setOutputValue("Server", (Object)server);
        handlerCtx.setOutputValue("Util", (Object)util);
        handlerCtx.setOutputValue("Verifier", (Object)verifier);
        handlerCtx.setOutputValue("WEB", (Object)web);
        handlerCtx.setOutputValue("PersistenceLogLevel", (Object)admin);
        handlerCtx.setOutputValue("Jbi", (Object)"INFO");
        handlerCtx.setOutputValue("Jaxws", (Object)"INFO");
        if (AMXRoot.getInstance().isEE()) {
            handlerCtx.setOutputValue("NodeAgent", (Object)mConfig.getDefaultValue("NodeAgent"));
            handlerCtx.setOutputValue("Synchronization", (Object)mConfig.getDefaultValue("Synchronization"));
            handlerCtx.setOutputValue("Gms", (Object)mConfig.getDefaultValue("GroupManagementService"));
        }
    }

    public static void getServerModuleLogLevels(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ModuleLogLevelsConfig mConfig = config.getLogServiceConfig().getModuleLogLevelsConfig();
        String admin = mConfig.getAdmin();
        String ejb = mConfig.getEJBContainer();
        String classLoader = mConfig.getClassloader();
        String configuration = mConfig.getConfiguration();
        String connector = mConfig.getConnector();
        String corba = mConfig.getCORBA();
        String deployment = mConfig.getDeployment();
        String javamail = mConfig.getJavamail();
        String jaxr = mConfig.getJAXR();
        String jaxrpc = mConfig.getJAXRPC();
        String jms = mConfig.getJMS();
        String jta = mConfig.getJTA();
        String jts = mConfig.getJTS();
        String mdb = mConfig.getMDBContainer();
        String naming = mConfig.getNaming();
        String root = mConfig.getRoot();
        String saaj = mConfig.getSAAJ();
        String security = mConfig.getSecurity();
        String selfManagement = mConfig.getSelfManagement();
        String server = mConfig.getServer();
        String util = mConfig.getUtil();
        String verifier = mConfig.getVerifier();
        String web = mConfig.getWebContainer();
        String jaxws = AMXUtil.getPropertyValue((PropertiesAccess)mConfig, (String)JAXWS_MODULE_PROPERTY, (String)"INFO");
        String jbi = AMXUtil.getPropertyValue((PropertiesAccess)mConfig, (String)JBI_MODULE_PROPERTY, (String)"INFO");
        handlerCtx.setOutputValue("Admin", (Object)admin);
        handlerCtx.setOutputValue("Classloader", (Object)classLoader);
        handlerCtx.setOutputValue("Configuration", (Object)configuration);
        handlerCtx.setOutputValue("Connector", (Object)connector);
        handlerCtx.setOutputValue("Corba", (Object)corba);
        handlerCtx.setOutputValue("Deployment", (Object)deployment);
        handlerCtx.setOutputValue("Javamail", (Object)javamail);
        handlerCtx.setOutputValue("Jaxr", (Object)jaxr);
        handlerCtx.setOutputValue("Jaxrpc", (Object)jaxrpc);
        handlerCtx.setOutputValue("Jms", (Object)jms);
        handlerCtx.setOutputValue("Jta", (Object)jta);
        handlerCtx.setOutputValue("Jts", (Object)jts);
        handlerCtx.setOutputValue("MDB", (Object)mdb);
        handlerCtx.setOutputValue("Naming", (Object)naming);
        handlerCtx.setOutputValue("EJB", (Object)ejb);
        handlerCtx.setOutputValue("Root", (Object)root);
        handlerCtx.setOutputValue("Saaj", (Object)saaj);
        handlerCtx.setOutputValue("Security", (Object)security);
        handlerCtx.setOutputValue("SelfManagement", (Object)selfManagement);
        handlerCtx.setOutputValue("Server", (Object)server);
        handlerCtx.setOutputValue("Util", (Object)util);
        handlerCtx.setOutputValue("Verifier", (Object)verifier);
        handlerCtx.setOutputValue("WEB", (Object)web);
        handlerCtx.setOutputValue("Jbi", (Object)jbi);
        handlerCtx.setOutputValue("Jaxws", (Object)jaxws);
        if (AMXRoot.getInstance().isEE()) {
            handlerCtx.setOutputValue("NodeAgent", (Object)mConfig.getNodeAgent());
            handlerCtx.setOutputValue("Synchronization", (Object)mConfig.getSynchronization());
            handlerCtx.setOutputValue("Gms", (Object)mConfig.getGroupManagementService());
        }
    }

    public static void getPredefinedLogLevels(HandlerContext handlerCtx) {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(GuiUtil.getMessage((String)"logging.Finest"));
        labels.add(GuiUtil.getMessage((String)"logging.Finer"));
        labels.add(GuiUtil.getMessage((String)"logging.Fine"));
        labels.add(GuiUtil.getMessage((String)"logging.Config"));
        labels.add(GuiUtil.getMessage((String)"logging.Info"));
        labels.add(GuiUtil.getMessage((String)"logging.Warning"));
        labels.add(GuiUtil.getMessage((String)"logging.Severe"));
        labels.add(GuiUtil.getMessage((String)"logging.Off"));
        ArrayList<String> values = new ArrayList<String>();
        values.add("FINEST");
        values.add("FINER");
        values.add("FINE");
        values.add("CONFIG");
        values.add("INFO");
        values.add("WARNING");
        values.add("SEVERE");
        values.add("OFF");
        handlerCtx.setOutputValue("levelsLabel", labels);
        handlerCtx.setOutputValue("levelsValue", values);
    }

    public static void saveServerModuleLogLevels(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ModuleLogLevelsConfig mConfig = config.getLogServiceConfig().getModuleLogLevelsConfig();
        Map newProps = (Map)handlerCtx.getInputValue("newProps");
        mConfig.setAdmin((String)handlerCtx.getInputValue("Admin"));
        mConfig.setEJBContainer((String)handlerCtx.getInputValue("EJB"));
        mConfig.setClassloader((String)handlerCtx.getInputValue("Classloader"));
        mConfig.setConfiguration((String)handlerCtx.getInputValue("Configuration"));
        mConfig.setConnector((String)handlerCtx.getInputValue("Connector"));
        mConfig.setCORBA((String)handlerCtx.getInputValue("Corba"));
        mConfig.setDeployment((String)handlerCtx.getInputValue("Deployment"));
        mConfig.setJavamail((String)handlerCtx.getInputValue("Javamail"));
        mConfig.setJAXR((String)handlerCtx.getInputValue("Jaxr"));
        mConfig.setJAXRPC((String)handlerCtx.getInputValue("Jaxrpc"));
        mConfig.setJMS((String)handlerCtx.getInputValue("Jms"));
        mConfig.setJTA((String)handlerCtx.getInputValue("Jta"));
        mConfig.setJTS((String)handlerCtx.getInputValue("Jts"));
        mConfig.setMDBContainer((String)handlerCtx.getInputValue("MDB"));
        mConfig.setNaming((String)handlerCtx.getInputValue("Naming"));
        mConfig.setRoot((String)handlerCtx.getInputValue("Root"));
        mConfig.setSAAJ((String)handlerCtx.getInputValue("Saaj"));
        mConfig.setSecurity((String)handlerCtx.getInputValue("Security"));
        mConfig.setSelfManagement((String)handlerCtx.getInputValue("SelfManagement"));
        mConfig.setServer((String)handlerCtx.getInputValue("Server"));
        mConfig.setUtil((String)handlerCtx.getInputValue("Util"));
        mConfig.setVerifier((String)handlerCtx.getInputValue("Verifier"));
        mConfig.setWebContainer((String)handlerCtx.getInputValue("WEB"));
        if (AMXRoot.getInstance().isEE()) {
            mConfig.setNodeAgent((String)handlerCtx.getInputValue("NodeAgent"));
            mConfig.setSynchronization((String)handlerCtx.getInputValue("Synchronization"));
            mConfig.setGroupManagementService((String)handlerCtx.getInputValue("Gms"));
        }
        AMXUtil.setPropertyValue((PropertiesAccess)mConfig, (String)JBI_MODULE_PROPERTY, (String)((String)handlerCtx.getInputValue("Jbi")));
        AMXUtil.setPropertyValue((PropertiesAccess)mConfig, (String)JAXWS_MODULE_PROPERTY, (String)((String)handlerCtx.getInputValue("Jaxws")));
    }

    public static void getServerDefaultJvmAttributes(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map defaultMap = config.getDefaultValues("X-JavaConfig", true);
        String javaHome = (String)defaultMap.get("JavaHome");
        String javacOptions = (String)defaultMap.get("JavacOptions");
        String rmicOptions = (String)defaultMap.get("RmicOptions");
        String debugOptions = (String)defaultMap.get("DebugOptions");
        String bytecodePreprocessors = (String)defaultMap.get("BytecodePreprocessors");
        String debugEnabled = (String)defaultMap.get("DebugEnabled");
        handlerCtx.setOutputValue("JavaHome", (Object)javaHome);
        handlerCtx.setOutputValue("Options", (Object)javacOptions);
        if ("true".equals(debugEnabled)) {
            handlerCtx.setOutputValue("DebugEnabled", (Object)true);
        } else {
            handlerCtx.setOutputValue("DebugEnabled", (Object)false);
        }
        handlerCtx.setOutputValue("DebugOptions", (Object)debugOptions);
        handlerCtx.setOutputValue("RmicOptions", (Object)rmicOptions);
        handlerCtx.setOutputValue("BytecodePreprocessor", (Object)bytecodePreprocessors);
    }

    public static void saveServerJvmAttributes(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        JavaConfig javaConfig = config.getJavaConfig();
        javaConfig.setJavaHome((String)handlerCtx.getInputValue("JavaHome"));
        javaConfig.setJavacOptions((String)handlerCtx.getInputValue("JavacOptions"));
        javaConfig.setDebugEnabled("" + handlerCtx.getInputValue("DebugEnabled"));
        javaConfig.setDebugOptions((String)handlerCtx.getInputValue("DebugOptions"));
        javaConfig.setRMICOptions((String)handlerCtx.getInputValue("RmicOptions"));
        javaConfig.setBytecodePreprocessors((String)handlerCtx.getInputValue("BytecodePreprocessor"));
    }

    public static void getServerJvmPathSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        JavaConfig javaConfig = config.getJavaConfig();
        String systemClasspath = javaConfig.getSystemClasspath();
        String serverClasspath = javaConfig.getServerClasspath();
        String ignoreEnvClasspath = javaConfig.getEnvClasspathIgnored();
        String classpathPrefix = javaConfig.getClasspathPrefix();
        String classpathSuffix = javaConfig.getClasspathSuffix();
        String nativeLibPathPrefix = javaConfig.getNativeLibraryPathPrefix();
        String nativeLibPathSuffix = javaConfig.getNativeLibraryPathSuffix();
        handlerCtx.setOutputValue("SystemClasspath", (Object)ServerHandlers.formatStringsforViewing(systemClasspath));
        handlerCtx.setOutputValue("ServerClasspath", (Object)ServerHandlers.formatStringsforViewing(serverClasspath));
        handlerCtx.setOutputValue("IgnoreEnvClasspath", (Object)ignoreEnvClasspath);
        handlerCtx.setOutputValue("ClasspathPrefix", (Object)ServerHandlers.formatStringsforViewing(classpathPrefix));
        handlerCtx.setOutputValue("ClasspathSuffix", (Object)ServerHandlers.formatStringsforViewing(classpathSuffix));
        handlerCtx.setOutputValue("NativeLibPathPrefix", (Object)ServerHandlers.formatStringsforViewing(nativeLibPathPrefix));
        handlerCtx.setOutputValue("NativeLibPathSuffix", (Object)ServerHandlers.formatStringsforViewing(nativeLibPathSuffix));
    }

    public static void saveServerJvmPathSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        JavaConfig javaConfig = config.getJavaConfig();
        String sysCP = (String)handlerCtx.getInputValue("SystemClasspath");
        String serverCP = (String)handlerCtx.getInputValue("ServerClasspath");
        String cpPrefix = (String)handlerCtx.getInputValue("ClasspathPrefix");
        String cpSuffix = (String)handlerCtx.getInputValue("ClasspathSuffix");
        String nativePrefix = (String)handlerCtx.getInputValue("NativeLibPathPrefix");
        String nativeSuffix = (String)handlerCtx.getInputValue("NativeLibPathSuffix");
        javaConfig.setSystemClasspath(ServerHandlers.formatStringsforSaving(sysCP));
        javaConfig.setServerClasspath(ServerHandlers.formatStringsforSaving(serverCP));
        javaConfig.setEnvClasspathIgnored("" + handlerCtx.getInputValue("IgnoreEnvClasspath"));
        javaConfig.setClasspathPrefix(ServerHandlers.formatStringsforSaving(cpPrefix));
        javaConfig.setClasspathSuffix(ServerHandlers.formatStringsforSaving(cpSuffix));
        javaConfig.setNativeLibraryPathPrefix(ServerHandlers.formatStringsforSaving(nativePrefix));
        javaConfig.setNativeLibraryPathSuffix(ServerHandlers.formatStringsforSaving(nativeSuffix));
    }

    private static String formatStringsforSaving(String values) {
        String token = "";
        if (values != null && values.toString().trim().length() != 0) {
            for (String nextToken : GuiUtil.parseStringList((String)values, (String)"\t\n\r\f")) {
                token = token + nextToken + PATH_SEPARATOR;
            }
            int end = token.length() - PATH_SEPARATOR.length();
            if (token.lastIndexOf(PATH_SEPARATOR) == end) {
                token = token.substring(0, end);
            }
        }
        return token;
    }

    private static String formatStringsforViewing(String values) {
        if (values == null || GuiUtil.isEmpty((String)values.trim())) {
            return "";
        }
        String s1 = values.trim().replaceAll("\\.jar:", "\\.jar\\$\\{path.separator\\}");
        String s2 = s1.replaceAll("\\.jar;", "\\.jar\\$\\{path.separator\\}");
        String[] strArray = s2.split("\\$\\{path.separator\\}");
        String result = "";
        for (String s : strArray) {
            result = result + s + "\n";
        }
        return result.trim();
    }

    public static void getLogGeneralSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        LogServiceConfig lc = config.getLogServiceConfig();
        String logFile = lc.getFile();
        String alarms = lc.getAlarms();
        String systemLog = lc.getUseSystemLogging();
        String logHandler = lc.getLogHandler();
        String logFilter = lc.getLogFilter();
        String rotationLimit = lc.getLogRotationLimitInBytes();
        String rotationTimeLimit = lc.getLogRotationTimeLimitInMinutes();
        String retainErrorStats = lc.getRetainErrorStatisticsForHours();
        handlerCtx.setOutputValue("LogFile", (Object)logFile);
        handlerCtx.setOutputValue("Alarms", (Object)alarms);
        handlerCtx.setOutputValue("SystemLog", (Object)systemLog);
        handlerCtx.setOutputValue("LogHandler", (Object)logHandler);
        handlerCtx.setOutputValue("LogFilter", (Object)logFilter);
        handlerCtx.setOutputValue("RotationLimit", (Object)rotationLimit);
        handlerCtx.setOutputValue("RotationTimeLimit", (Object)rotationTimeLimit);
        handlerCtx.setOutputValue("RetainErrorStats", (Object)retainErrorStats);
    }

    public static void saveServerLogGeneralSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            LogServiceConfig lc = config.getLogServiceConfig();
            ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
            Map addProps = (Map)handlerCtx.getInputValue("AddProps");
            String[] remove = removeProps.toArray(new String[removeProps.size()]);
            for (int i = 0; i < remove.length; ++i) {
                lc.removePropertyConfig(remove[i]);
            }
            if (addProps != null) {
                for (Object key : addProps.keySet()) {
                    String addvalue = (String)addProps.get(key);
                    AMXUtil.setPropertyValue((PropertiesAccess)lc, (String)((String)key), (String)addvalue);
                }
            }
            lc.setFile((String)handlerCtx.getInputValue("LogFile"));
            lc.setAlarms((String)handlerCtx.getInputValue("Alarms"));
            lc.setUseSystemLogging((String)handlerCtx.getInputValue("SystemLog"));
            lc.setLogHandler((String)handlerCtx.getInputValue("LogHandler"));
            lc.setLogFilter((String)handlerCtx.getInputValue("LogFilter"));
            lc.setLogRotationLimitInBytes((String)handlerCtx.getInputValue("RotationLimit"));
            lc.setLogRotationTimeLimitInMinutes((String)handlerCtx.getInputValue("RotationTimeLimit"));
            lc.setRetainErrorStatisticsForHours((String)handlerCtx.getInputValue("RetainErrorStats"));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void saveJvmOptions(HandlerContext handlerCtx) {
        ArrayList names = (ArrayList)handlerCtx.getInputValue("NameList");
        if (names == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)"saveJvmOptions(): NameList passed in is NULL");
            return;
        }
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            JavaConfig javaConfig = config.getJavaConfig();
            String[] options = names.toArray(new String[names.size()]);
            javaConfig.setJVMOptions(options);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void saveProfilerJvmOptions(HandlerContext handlerCtx) {
        ArrayList names = (ArrayList)handlerCtx.getInputValue("NameList");
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            ProfilerConfig profilerConfig = config.getJavaConfig().getProfilerConfig();
            if (names != null && names.size() > 0) {
                String[] options = names.toArray(new String[names.size()]);
                profilerConfig.setJVMOptions(options);
            } else {
                profilerConfig.setJVMOptions(new String[0]);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getServerProfilerAttributes(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            JavaConfig javaConfig = config.getJavaConfig();
            if (javaConfig.getProfilerConfig() != null) {
                ProfilerConfig profilerConfig = javaConfig.getProfilerConfig();
                String name = profilerConfig.getName();
                String enabled = profilerConfig.getEnabled();
                String classPath = profilerConfig.getClasspath();
                String nativeLibrary = profilerConfig.getNativeLibraryPath();
                handlerCtx.setOutputValue("Classpath", (Object)classPath);
                handlerCtx.setOutputValue("NativeLibrary", (Object)nativeLibrary);
                handlerCtx.setOutputValue("ProfilerName", (Object)name);
                handlerCtx.setOutputValue("ProfilerEnabled", (Object)enabled);
                handlerCtx.setOutputValue("edit", (Object)true);
            } else {
                handlerCtx.setOutputValue("ProfilerEnabled", (Object)true);
                handlerCtx.setOutputValue("edit", (Object)false);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void saveServerProfilerSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        String name = (String)handlerCtx.getInputValue("ProfilerName");
        if (name == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)"Profile Name: Name passed in is NULL");
            return;
        }
        JavaConfig javaConfig = config.getJavaConfig();
        ProfilerConfig profiler = javaConfig.getProfilerConfig();
        String classpath = (String)handlerCtx.getInputValue("Classpath");
        String nativelibrary = (String)handlerCtx.getInputValue("NativeLibrary");
        Boolean profilerenabled = (Boolean)handlerCtx.getInputValue("ProfilerEnabled");
        try {
            if (profiler == null) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (classpath != null) {
                    map.put("classpath", classpath);
                }
                if (nativelibrary != null) {
                    map.put("native-library-path", nativelibrary);
                }
                map.put("enabled", profilerenabled == null ? "false" : profilerenabled.toString());
                javaConfig.createProfilerConfig(name, map);
            } else {
                if (classpath != null) {
                    profiler.setClasspath(classpath);
                }
                if (nativelibrary != null) {
                    profiler.setNativeLibraryPath(nativelibrary);
                }
                profiler.setEnabled(profilerenabled == null ? "false" : "" + profilerenabled);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getLoggerList(HandlerContext handlerCtx) {
        String module = (String)handlerCtx.getInputValue("Module");
        String logList = ServerHandlers.getLoggerList(module);
        if (module.equals("jbi")) {
            handlerCtx.setOutputValue("LogList", (Object)"( com.sun.jbi)");
        } else if (module.equals("jaxws")) {
            handlerCtx.setOutputValue("LogList", (Object)"( javax.enterprise.resource.webservices.jaxws)");
        } else {
            handlerCtx.setOutputValue("LogList", (Object)("( " + logList + ")"));
        }
    }

    public static void getPersistenceLoggerList(HandlerContext handlerCtx) {
        String jdo = ServerHandlers.getLoggerList("jdo");
        String cmp = ServerHandlers.getLoggerList("cmp");
        handlerCtx.setOutputValue("LogList", (Object)("( oracle.toplink.essentials; " + jdo + cmp + ")"));
    }

    private static String getLoggerList(String module) {
        String[] params = new String[]{module};
        String[] types = new String[]{"java.lang.String"};
        String logList = "";
        return " ";
    }

    public static void getPersistenceLogLevel(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ModuleLogLevelsConfig mConfig = config.getLogServiceConfig().getModuleLogLevelsConfig();
        handlerCtx.setOutputValue("PersistenceLogLevel", (Object)AMXUtil.getPropertyValue((PropertiesAccess)mConfig, (String)PERSISTENCE_MODULE_PROPERTY, (String)mConfig.getJDO()));
    }

    public static void setPersistenceLogLevel(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        String value = (String)handlerCtx.getInputValue("Value");
        ModuleLogLevelsConfig mConfig = config.getLogServiceConfig().getModuleLogLevelsConfig();
        AMXUtil.setPropertyValue((PropertiesAccess)mConfig, (String)PERSISTENCE_MODULE_PROPERTY, (String)value);
        mConfig.setJDO(value);
        mConfig.setCMP(value);
    }

    public static void generateDiagnosticReport(HandlerContext handlerCtx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logstartdate", (Date)handlerCtx.getInputValue("StartDate"));
        map.put("logenddate", (Date)handlerCtx.getInputValue("EndDate"));
        map.put("bugids", (String)handlerCtx.getInputValue("BugIds"));
        map.put("input", (String)handlerCtx.getInputValue("Description"));
        map.put("target", (String)handlerCtx.getInputValue("Target"));
        String reportLocation = "";
    }

    public static void getConfidentialProps(HandlerContext handlerCtx) {
    }

    public static void getJvmOptions(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
        ArrayList<List<Map<String, Object>>> list = new ArrayList<List<Map<String, Object>>>();
        JavaConfig javaConfig = null;
        try {
            if (config == null) {
                System.out.println("getJvmOptions: getConfig() returns NULL,  configName = " + configName);
            } else {
                javaConfig = config.getJavaConfig();
                if (javaConfig == null) {
                    System.out.println("getJvmOptions: getJavaConfig() returns NULL,  configName = " + configName);
                } else {
                    Object[] jvmOptions = javaConfig.getJVMOptions();
                    list.add(ServerHandlers.convertToListOfMap(jvmOptions, "option"));
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Catch exception when trying to get the jvm option list.");
            ex.printStackTrace();
        }
        handlerCtx.setOutputValue("JvmOptions", list);
    }

    public static void getJvmOptionsForProfiler(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
        ArrayList<List<Map<String, Object>>> list = new ArrayList<List<Map<String, Object>>>();
        try {
            if (config == null) {
                System.out.println("!!!!! getJvmOptionsForProfiler:  getConfig() returns NULL. configName=" + configName);
            } else {
                JavaConfig javaConfig = config.getJavaConfig();
                if (javaConfig == null) {
                    System.out.println("!!!!! getJvmOptionsForProfiler: getJavaConfig() returns NULL; configName=" + configName);
                } else {
                    ProfilerConfig profilerConfig = javaConfig.getProfilerConfig();
                    Object[] jvmOptions = profilerConfig == null ? new String[]{} : profilerConfig.getJVMOptions();
                    list.add(ServerHandlers.convertToListOfMap(jvmOptions, "option"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        handlerCtx.setOutputValue("JvmOptions", list);
    }

    public static void getModuleLogLevelProperties(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ModuleLogLevelsConfig mConfig = config.getLogServiceConfig().getModuleLogLevelsConfig();
        Map newMap = AMXUtil.getNonSkipPropertiesMap((PropertiesAccess)mConfig, (List)skipLogModulePropsList);
        handlerCtx.setOutputValue("Properties", (Object)newMap);
        handlerCtx.setOutputValue("Properties", (Object)" ");
    }

    public static void getLoggingProperties(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        LogServiceConfig lc = config.getLogServiceConfig();
        handlerCtx.setOutputValue("Properties", (Object)config.getLogServiceConfig().getPropertyConfigMap());
    }

    public static void getViews(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        String selectedView = (String)handlerCtx.getInputValue("View");
        if (selectedView == null || selectedView.equals("")) {
            selectedView = "Summary";
        }
        handlerCtx.setOutputValue("Report", (Object)" ");
    }

    public static void getJVMReportList(HandlerContext handlerCtx) {
        ArrayList<String> label = new ArrayList<String>();
        label.add(GuiUtil.getMessage((String)"jvmReport.Summary"));
        label.add(GuiUtil.getMessage((String)"jvmReport.Memory"));
        label.add(GuiUtil.getMessage((String)"jvmReport.ClLoading"));
        label.add(GuiUtil.getMessage((String)"jvmReport.ThDump"));
        ArrayList<String> value = new ArrayList<String>();
        value.add("Summary");
        value.add("Memory");
        value.add("Class Loading");
        value.add("Thread Dump");
        handlerCtx.setOutputValue("ReportListValue", value);
        handlerCtx.setOutputValue("ReportListLabel", label);
    }

    public static void getServers(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        boolean supportCluster = (Boolean)handlerCtx.getInputValue("SupportCluster");
        String destServer = "";
        Vector targets = new Vector();
        boolean notRunning = true;
    }

    public static void recoverTransactions(HandlerContext handlerCtx) {
        try {
            String objName = "com.sun.appserv:type=transactions-recovery,category=config";
            String operName = "recoverTransactions";
            boolean bl = (Boolean)handlerCtx.getInputValue("SupportCluster");
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    private static List<Map<String, Object>> convertToListOfMap(Object[] values, String key) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (values != null) {
            HashMap<String, Object> map = null;
            for (Object val : values) {
                map = new HashMap<String, Object>();
                map.put(key, val);
                map.put("selected", false);
                list.add(map);
            }
        }
        return list;
    }

    static {
        viewOperationMap.put("Summary", "getSummary");
        viewOperationMap.put("Memory", "getMemoryInformation");
        viewOperationMap.put("Class Loading", "getClassInformation");
        viewOperationMap.put("Thread Dump", "getThreadDump");
        skipLogModulePropsList = new ArrayList();
        skipLogModulePropsList.add(PERSISTENCE_MODULE_PROPERTY);
        skipLogModulePropsList.add(JAXWS_MODULE_PROPERTY);
        skipLogModulePropsList.add(JBI_MODULE_PROPERTY);
    }
}

