/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag
implements Serializable {
    private static final long serialVersionUID = 7437635853139196986L;
    private String tagViewId = null;
    private String tagName = null;
    private String displayName = null;
    private List<String> users = null;

    Tag() {
    }

    public Tag(String tagName, String tagViewId, String displayName, String user) {
        this.tagName = tagName;
        this.tagViewId = tagViewId;
        this.displayName = displayName;
        if (user != null) {
            this.users = new ArrayList<String>();
            this.users.add(user);
        }
    }

    public void addUser(String name) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.add(name);
    }

    public List<String> getUsers() {
        return this.users;
    }

    public boolean containsUser(String name) {
        return this.users == null ? false : this.users.contains(name);
    }

    public List<String> removeUser(String name) {
        if (this.users != null) {
            this.users.remove(name);
            if (this.users.size() == 0) {
                this.users = null;
            }
        }
        return this.users;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Tag) {
            Tag testTag = (Tag)obj;
            result = this.getTagName().equals(testTag.getTagName()) && this.getTagViewId().equals(testTag.getTagViewId());
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.tagViewId != null ? this.tagViewId.hashCode() : 0);
        hash = 89 * hash + (this.tagName != null ? this.tagName.hashCode() : 0);
        hash = 89 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "[" + this.getTagName() + ", " + this.getTagViewId() + ", " + this.getDisplayName() + ", Users: {" + this.users + "}]";
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getTagViewId() {
        return this.tagViewId;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

