/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import com.sun.webui.jsf.component.Hyperlink;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.glassfish.admingui.common.util.GuiUtil;

public class UtilHandlers {
    public static void calendarAdd(HandlerContext handlerCtx) {
        int field = (Integer)handlerCtx.getInputValue("Field");
        int amount = (Integer)handlerCtx.getInputValue("Amount");
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(field, amount);
        handlerCtx.setOutputValue("Date", (Object)cal.getTime());
    }

    public static void getFile(HandlerContext handlerCtx) {
        String pathname = (String)handlerCtx.getInputValue("Pathname");
        handlerCtx.setOutputValue("File", (Object)(pathname != null ? new File(pathname) : null));
    }

    public static void fileGetName(HandlerContext handlerCtx) {
        File file = (File)handlerCtx.getInputValue("File");
        String name = file != null ? file.getName() : "";
        handlerCtx.setOutputValue("Name", (Object)(name != null ? name : ""));
    }

    public static void mapGet(HandlerContext handlerCtx) {
        Map map = (Map)handlerCtx.getInputValue("Map");
        Object key = handlerCtx.getInputValue("Key");
        handlerCtx.setOutputValue("Value", map.get(key));
    }

    public static void compare(HandlerContext handlerCtx) {
        boolean ret = false;
        Object obj1 = handlerCtx.getInputValue("obj1");
        Object obj2 = handlerCtx.getInputValue("obj2");
        if (obj1 != null) {
            ret = obj1.equals(obj2);
        } else if (obj2 == null) {
            ret = true;
        }
        handlerCtx.setOutputValue("objEqual", (Object)ret);
    }

    public static void prepareSuccessful(HandlerContext handlerCtx) {
        GuiUtil.prepareSuccessful((HandlerContext)handlerCtx);
    }

    public static void prepareAlertMsg(HandlerContext handlerCtx) {
        String summary = (String)handlerCtx.getInputValue("summary");
        String type = (String)handlerCtx.getInputValue("type");
        String detail = (String)handlerCtx.getInputValue("detail");
        GuiUtil.prepareAlert((HandlerContext)handlerCtx, (String)type, (String)summary, (String)detail);
    }

    public static void decodeString(HandlerContext handlerCtx) {
        String str = (String)handlerCtx.getInputValue("str");
        String scheme = (String)handlerCtx.getInputValue("scheme");
        if (GuiUtil.isEmpty((String)str)) {
            handlerCtx.setOutputValue("output", (Object)"");
            return;
        }
        if (GuiUtil.isEmpty((String)scheme)) {
            scheme = "UTF-8";
        }
        try {
            String output = URLDecoder.decode(str, scheme);
            handlerCtx.setOutputValue("output", (Object)output);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("output", (Object)str);
        }
    }

    public static void createHyperlinkArray(HandlerContext handlerCtx) {
        FacesContext ctx = handlerCtx.getFacesContext();
        ExternalContext extCtx = ctx.getExternalContext();
        Map reqParams = extCtx.getRequestParameterValuesMap();
        String[] linkText = (String[])reqParams.get("text");
        String[] linkUrl = (String[])reqParams.get("urls");
        if (linkText == null) {
            return;
        }
        int len = linkText.length;
        Hyperlink[] arr = new Hyperlink[len];
        String url = null;
        String ctxPath = extCtx.getRequestContextPath();
        int ctxPathSize = ctxPath.length();
        for (int idx = 0; idx < len; ++idx) {
            arr[idx] = new Hyperlink();
            arr[idx].setId("bcLnk" + idx);
            arr[idx].setRendererType("com.sun.webui.jsf.Hyperlink");
            arr[idx].setText((Object)linkText[idx]);
            url = linkUrl[idx];
            if (url.startsWith(ctxPath)) {
                url = url.substring(ctxPathSize);
            }
            arr[idx].setUrl(url);
        }
        handlerCtx.setOutputValue("links", (Object)arr);
    }

    public static void dummyHyperlinkArray(HandlerContext handlerCtx) {
        Hyperlink[] arr = new Hyperlink[]{new Hyperlink()};
        arr[0].setText((Object)">");
        handlerCtx.setOutputValue("links", (Object)arr);
    }

    public static void roundTo2DecimalPoint(HandlerContext handlerCtx) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        try {
            Double input = (Double)handlerCtx.getInputValue("input");
            String output = input == null ? "" : df.format(input);
            handlerCtx.setOutputValue("output", (Object)output);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("output", (Object)"");
        }
    }

    public static void addHandler(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("id");
        String desc = (String)handlerCtx.getInputValue("desc");
        String cls = (String)handlerCtx.getInputValue("class");
        String meth = (String)handlerCtx.getInputValue("method");
        HandlerDefinition def = new HandlerDefinition(id);
        def.setHandlerMethod(cls, meth);
        if (desc != null) {
            def.setDescription(desc);
        }
        LayoutDefinitionManager.addGlobalHandlerDefinition((HandlerDefinition)def);
    }
}

