/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class SecurityServicesUtil {
    @Inject
    private static Habitat habitat;
    private static final LocalStringManagerImpl _localStrings;
    private static final Logger _logger;
    public static final SecureRandom secureRandom;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private ServerEnvironment env;
    @Inject
    private AuditManager auditManager;
    private CallbackHandler callbackHandler;

    public void initSecureSeed() {
        File secureSeedFile = new File(this.env.getConfigDirPath(), "secure.seed");
        long seed = this.readSecureSeed(secureSeedFile);
        secureRandom.setSeed(seed);
        seed = secureRandom.nextLong();
        this.writeSecureSeed(secureSeedFile, seed);
        secureSeedFile = null;
    }

    private long readSecureSeed(File fname) {
        try {
            BufferedReader fis = new BufferedReader(new FileReader(fname));
            try {
                String line = fis.readLine();
                fis.close();
                Long lseed = new Long(line);
                return lseed;
            }
            catch (IOException e) {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        secureRandom.setSeed(System.currentTimeMillis());
        long newSeed = secureRandom.nextLong();
        return newSeed;
    }

    private void writeSecureSeed(File fname, long seed) {
        try {
            FileOutputStream fos = new FileOutputStream(fname);
            String sseed = Long.toString(seed);
            fos.write(sseed.getBytes());
            fos.close();
        }
        catch (IOException e) {
            String errmsg = _localStrings.getLocalString("j2ee.startupslow", "Cannot write the seed file for fast startup. The next startup will be slow.");
            _logger.log(Level.WARNING, errmsg);
        }
    }

    public Habitat getHabitat() {
        return habitat;
    }

    public AuditManager getAuditManager() {
        return this.auditManager;
    }

    public static SecurityServicesUtil getInstance() {
        return (SecurityServicesUtil)habitat.getComponent(SecurityServicesUtil.class);
    }

    public ProcessEnvironment getProcessEnv() {
        return this.processEnv;
    }

    public boolean isACC() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }

    public boolean isServer() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Server);
    }

    public boolean isNotServerOrACC() {
        return this.processEnv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Other);
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    static {
        _localStrings = new LocalStringManagerImpl(SecurityServicesUtil.class);
        _logger = LogDomains.getLogger(SecurityServicesUtil.class, (String)"javax.enterprise.system.core.security");
        secureRandom = new SecureRandom();
        secureRandom.setSeed(System.currentTimeMillis());
    }
}

