/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.corba.se.impl.orbutil.threadpool.ThreadPoolManagerImpl;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.logging.LogDomains;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorsUtil {
    private static Logger _logger = LogDomains.getLogger(ConnectorsUtil.class, (String)"javax.enterprise.resource.resourceadapter");

    public static boolean belongsToSystemRA(String raName) {
        boolean result = false;
        for (String systemRarName : ConnectorConstants.systemRarNames) {
            if (!systemRarName.equals(raName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getSystemModuleLocation(String moduleName) {
        String j2eeModuleDirName = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "applications" + File.separator + moduleName;
        return j2eeModuleDirName;
    }

    public static String getLocation(String moduleName) {
        return ConfigBeansUtilities.getLocation((String)moduleName);
    }

    public static String getPMJndiName(String jndiName) {
        return jndiName + "__pm";
    }

    public static String getValidSuffix(String name) {
        if (name != null) {
            for (String validSuffix : ConnectorConstants.JNDI_SUFFIX_VALUES) {
                if (!name.endsWith(validSuffix)) continue;
                return validSuffix;
            }
        }
        return null;
    }

    public static boolean isValidJndiSuffix(String suffix) {
        if (suffix != null) {
            for (String validSuffix : ConnectorConstants.JNDI_SUFFIX_VALUES) {
                if (!validSuffix.equals(suffix)) continue;
                return true;
            }
        }
        return false;
    }

    public static String deriveJndiName(String name, Hashtable env) {
        String suffix = (String)env.get("com.sun.enterprise.connectors.jndisuffix");
        if (ConnectorsUtil.isValidJndiSuffix(suffix)) {
            return name + suffix;
        }
        return name;
    }

    public static boolean isValidEventType(Object instance) {
        return instance instanceof JdbcConnectionPool || instance instanceof JdbcResource || instance instanceof ConnectorConnectionPool || instance instanceof ConnectorResource || instance instanceof MailResource || instance instanceof ExternalJndiResource || instance instanceof CustomResource || instance instanceof AdminObjectResource || instance instanceof WorkSecurityMap || instance instanceof ResourceAdapterConfig;
    }

    public static JdbcConnectionPool getAssociatedJdbcConnectionPool(JdbcResource resource, Resources allResources) {
        for (Resource configuredResource : allResources.getResources()) {
            if (!(configuredResource instanceof JdbcConnectionPool)) continue;
            JdbcConnectionPool pool = (JdbcConnectionPool)configuredResource;
            if (!resource.getPoolName().equalsIgnoreCase(pool.getName())) continue;
            return pool;
        }
        return null;
    }

    public static ConnectorConnectionPool getAssociatedConnectorConnectionPool(ConnectorResource resource, Resources allResources) {
        for (Resource configuredResource : allResources.getResources()) {
            if (!(configuredResource instanceof ConnectorConnectionPool)) continue;
            ConnectorConnectionPool pool = (ConnectorConnectionPool)configuredResource;
            if (!resource.getPoolName().equalsIgnoreCase(pool.getName())) continue;
            return pool;
        }
        return null;
    }

    public static ResourcePool getConnectionPoolConfig(String poolName, Resources allResources) {
        for (Resource configuredResource : allResources.getResources()) {
            ResourcePool pool;
            if (!(configuredResource instanceof ResourcePool) || !(pool = (ResourcePool)configuredResource).getName().equalsIgnoreCase(poolName)) continue;
            return pool;
        }
        return null;
    }

    public static Collection<Resource> getAllResources(Collection<String> poolNames, Resources allResources) {
        ArrayList<Resource> connectorResources = new ArrayList<Resource>();
        for (Resource resource : allResources.getResources()) {
            ConnectorResource connectorResource;
            if (!(resource instanceof ConnectorResource) || !poolNames.contains((connectorResource = (ConnectorResource)resource).getPoolName())) continue;
            connectorResources.add((Resource)connectorResource);
        }
        return connectorResources;
    }

    public static Collection<String> getAllPoolNames(Collection<ConnectorConnectionPool> connectionPools) {
        HashSet<String> poolNames = new HashSet<String>();
        for (ConnectorConnectionPool pool : connectionPools) {
            poolNames.add(pool.getName());
        }
        return poolNames;
    }

    public static Collection<ConnectorConnectionPool> getAllPoolsOfModule(String moduleName, Resources allResources) {
        ArrayList<ConnectorConnectionPool> connectorConnectionPools = new ArrayList<ConnectorConnectionPool>();
        for (Resource resource : allResources.getResources()) {
            ConnectorConnectionPool connectorConnectionPool;
            if (!(resource instanceof ConnectorConnectionPool) || !(connectorConnectionPool = (ConnectorConnectionPool)resource).getResourceAdapterName().equals(moduleName)) continue;
            connectorConnectionPools.add(connectorConnectionPool);
        }
        return connectorConnectionPools;
    }

    public static Collection<Resource> getAllSystemRAResourcesAndPools(Resources allResources) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        ArrayList<Resource> pools = new ArrayList<Resource>();
        for (Resource resource : allResources.getResources()) {
            String poolName;
            String raName;
            if (resource instanceof JdbcConnectionPool) {
                pools.add(resource);
                continue;
            }
            if (resource instanceof ConnectorConnectionPool) {
                String raName2 = ((ConnectorConnectionPool)resource).getResourceAdapterName();
                if (!ConnectorsUtil.belongsToSystemRA(raName2)) continue;
                pools.add(resource);
                continue;
            }
            if (resource instanceof JdbcResource) {
                resources.add(resource);
                continue;
            }
            if (!(resource instanceof ConnectorResource) || !ConnectorsUtil.belongsToSystemRA(raName = ConnectorsUtil.getResourceAdapterNameOfPool(poolName = ((ConnectorResource)resource).getPoolName(), allResources))) continue;
            resources.add(resource);
        }
        resources.addAll(pools);
        return resources;
    }

    public static String getResourceAdapterNameOfPool(String poolName, Resources allResources) {
        String raName = "";
        for (Resource resource : allResources.getResources()) {
            ConnectorConnectionPool ccp;
            String name;
            if (!(resource instanceof ConnectorConnectionPool) || !(name = (ccp = (ConnectorConnectionPool)resource).getName()).equalsIgnoreCase(poolName)) continue;
            raName = ccp.getResourceAdapterName();
        }
        return raName;
    }

    public static List<WorkSecurityMap> getWorkSecurityMaps(String raName, Resources allResources) {
        List resourcesList = allResources.getResources();
        ArrayList<WorkSecurityMap> workSecurityMaps = new ArrayList<WorkSecurityMap>();
        for (Resource resource : resourcesList) {
            WorkSecurityMap wsm;
            if (!(resource instanceof WorkSecurityMap) || !(wsm = (WorkSecurityMap)resource).getResourceAdapterName().equals(raName)) continue;
            workSecurityMaps.add(wsm);
        }
        return workSecurityMaps;
    }

    public static AdminObjectResource[] getEnabledAdminObjectResources(String raName, Resources allResources, Server server) {
        List resourcesList = allResources.getResources();
        int resourceCount = resourcesList.size();
        if (resourceCount == 0) {
            return null;
        }
        ArrayList<AdminObjectResource> adminObjectResources = new ArrayList<AdminObjectResource>();
        for (int i = 0; i < resourceCount; ++i) {
            AdminObjectResource adminObjectResource;
            String resourceAdapterName;
            Resource resource = (Resource)resourcesList.get(i);
            if (resource == null || !(resource instanceof AdminObjectResource) || (resourceAdapterName = (adminObjectResource = (AdminObjectResource)resource).getResAdapter()) == null || raName != null && !raName.equals(resourceAdapterName) || !ConnectorsUtil.isEnabled(adminObjectResource, server)) continue;
            adminObjectResources.add(adminObjectResource);
        }
        AdminObjectResource[] allAdminObjectResources = new AdminObjectResource[adminObjectResources.size()];
        return adminObjectResources.toArray(allAdminObjectResources);
    }

    public static boolean isEnabled(AdminObjectResource aot, Server server) {
        if (aot == null || !Boolean.parseBoolean(aot.getEnabled())) {
            return false;
        }
        if (!ConnectorsUtil.isResourceReferenceEnabled(aot.getJndiName(), server)) {
            return false;
        }
        String raName = aot.getResAdapter();
        return ConnectorsUtil.isRarEnabled(raName);
    }

    private static boolean isResourceReferenceEnabled(String resourceName, Server server) {
        ResourceRef ref = null;
        if (server != null) {
            ref = server.getResourceRef(resourceName);
        }
        if (ref == null) {
            _logger.fine("ResourcesUtil :: isResourceReferenceEnabled null ref");
            return true;
        }
        _logger.fine("ResourcesUtil :: isResourceReferenceEnabled ref enabled ?" + Boolean.parseBoolean(ref.getEnabled()));
        return Boolean.parseBoolean(ref.getEnabled());
    }

    private static boolean isRarEnabled(String raName) {
        return true;
    }

    public static String getResourceType(Resource resource) {
        if (resource instanceof JdbcResource) {
            return "jdbc";
        }
        if (resource instanceof JdbcConnectionPool) {
            return "jcp";
        }
        if (resource instanceof ConnectorResource) {
            return "cr";
        }
        if (resource instanceof ConnectorConnectionPool) {
            return "ccp";
        }
        if (resource instanceof MailResource) {
            return "mail";
        }
        if (resource instanceof ExternalJndiResource) {
            return "external-jndi";
        }
        if (resource instanceof CustomResource) {
            return "custom";
        }
        if (resource instanceof AdminObjectResource) {
            return "aor";
        }
        if (resource instanceof ResourceAdapterConfig) {
            return "rac";
        }
        if (resource instanceof WorkSecurityMap) {
            return "cwsm";
        }
        return null;
    }

    public static Object loadObject(String className) {
        Object obj = null;
        try {
            obj = Class.forName(className).newInstance();
        }
        catch (Exception cnf) {
            try {
                Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(className);
                obj = c.newInstance();
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "classloader.load_class_fail", className);
                _logger.log(Level.SEVERE, "classloader.load_class_fail_excp", ex.getMessage());
            }
        }
        return obj;
    }

    public static Set getMergedActivationConfigProperties(EjbMessageBeanDescriptor msgDesc) {
        Set standardProps;
        HashSet<EnvironmentProperty> mergedProps = new HashSet<EnvironmentProperty>();
        HashSet<String> runtimePropNames = new HashSet<String>();
        Set runtimeProps = msgDesc.getRuntimeActivationConfigProperties();
        if (runtimeProps != null) {
            for (EnvironmentProperty entry : runtimeProps) {
                mergedProps.add(entry);
                String propName = entry.getName();
                runtimePropNames.add(propName);
            }
        }
        if ((standardProps = msgDesc.getActivationConfigProperties()) != null) {
            for (EnvironmentProperty entry : standardProps) {
                String propName = entry.getName();
                if (runtimePropNames.contains(propName)) continue;
                mergedProps.add(entry);
            }
        }
        return mergedProps;
    }

    public static boolean isJMSRA(String moduleName) {
        return "jmsra".equals(moduleName);
    }

    public static boolean parseBoolean(String enabled) {
        return Boolean.parseBoolean(enabled.toString());
    }

    public static String getResourceName(Resource resource) {
        if (resource instanceof BindableResource) {
            return ((BindableResource)resource).getJndiName();
        }
        if (resource instanceof ResourcePool) {
            return ((ResourcePool)resource).getName();
        }
        if (resource instanceof ResourceAdapterConfig) {
            return ((ResourceAdapterConfig)resource).getName();
        }
        if (resource instanceof WorkSecurityMap) {
            WorkSecurityMap wsm = (WorkSecurityMap)resource;
            return "resource-adapter name : " + wsm.getResourceAdapterName() + " : security map name : " + wsm.getName();
        }
        return null;
    }

    public static ThreadPool getThreadPool(String threadPoolId) throws NoSuchThreadPoolException, ConnectorRuntimeException {
        ThreadPoolManager tpm = ConnectorsUtil.getThreadPoolManager();
        if (threadPoolId != null) {
            return tpm.getThreadPool(threadPoolId);
        }
        return tpm.getDefaultThreadPool();
    }

    private static ThreadPoolManager getThreadPoolManager() throws ConnectorRuntimeException {
        try {
            Constructor defaultConstructor = ThreadPoolManagerImpl.class.getConstructor(new Class[0]);
            defaultConstructor.setAccessible(true);
            return (ThreadPoolManager)defaultConstructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Constructor threadGroupParamConstructor = ThreadPoolManagerImpl.class.getConstructor(ThreadGroup.class);
            threadGroupParamConstructor.setAccessible(true);
            Object tg = null;
            return (ThreadPoolManager)threadGroupParamConstructor.newInstance(tg);
        }
        catch (Exception e) {
            throw new ConnectorRuntimeException("unable to provide thread pool manager");
        }
    }
}

