/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.annotations.ProbeParam;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.TimeStats;
import org.glassfish.flashlight.statistics.factory.CounterFactory;
import org.glassfish.flashlight.statistics.factory.TimeStatsFactory;
import org.glassfish.web.admin.monitor.telemetry.WebTelemetryBootstrap;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebRequestTelemetry
implements PostConstruct {
    private Counter errorCount = CounterFactory.createCount((long[])new long[0]);
    private TreeNode webRequestNode = null;
    private TimeStats requestProcessTime = TimeStatsFactory.createTimeStatsMilli();
    private Collection<ProbeClientMethodHandle> handles;
    private Logger logger;
    private boolean isEnabled = true;
    private HttpService httpService = null;
    private VirtualServer virtualServer = null;
    @Inject
    private static Domain domain;
    private String virtualServerName = null;
    private String moduleName = null;

    public WebRequestTelemetry(TreeNode parent, String appName, String vsName, Logger logger) {
        try {
            this.logger = logger;
            this.virtualServerName = vsName;
            this.moduleName = appName;
            this.webRequestNode = parent;
            Method m1 = this.requestProcessTime.getClass().getMethod("getMaximumTime", null);
            TreeNode maxTime = TreeNodeFactory.createMethodInvoker((String)"maxtime-count", (Object)this.requestProcessTime, (String)"request", (Method)m1);
            parent.addChild(maxTime);
            this.requestProcessTime.getCount();
            Method m2 = this.requestProcessTime.getClass().getMethod("getCount", null);
            TreeNode requestCount = TreeNodeFactory.createMethodInvoker((String)"requestcount-count", (Object)this.requestProcessTime, (String)"request", (Method)m2);
            parent.addChild(requestCount);
            Method m3 = this.requestProcessTime.getClass().getMethod("getTime", null);
            TreeNode processingTime = TreeNodeFactory.createMethodInvoker((String)"processingtime-count", (Object)this.requestProcessTime, (String)"request", (Method)m3);
            parent.addChild(processingTime);
            this.errorCount.setName("errorcount-count");
            parent.addChild((TreeNode)this.errorCount);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(WebRequestTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(WebRequestTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void postConstruct() {
    }

    @ProbeListener(value="web:request::requestStartEvent")
    public void requestStartEvent(@ProbeParam(value="request") HttpServletRequest request, @ProbeParam(value="response") HttpServletResponse response, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]requestStartEvent Unprocessed received - virtual-server = " + request.getServerName() + ":" + request.getServerPort() + ": application = " + request.getContextPath() + " : servlet = " + request.getServletPath() + " : Expecting (vsName, appName) = (" + this.virtualServerName + ", " + this.moduleName + ")");
        if (this.virtualServerName != null && this.moduleName != null) {
            String appName;
            String contextPath = request.getContextPath();
            String string = appName = contextPath == null ? null : WebTelemetryBootstrap.getAppName(contextPath);
            if (appName != null && hostName != null && hostName.equals(this.virtualServerName) && appName.equals(this.moduleName)) {
                this.requestProcessTime.entry();
                this.logger.finest("[TM]requestStartEvent resolved - virtual-server = " + request.getServerName() + ": application = " + contextPath + " :appName = " + appName + " : servlet = " + request.getServletPath() + " : port = " + request.getServerPort());
            }
        } else {
            this.requestProcessTime.entry();
            this.logger.finest("[TM]requestStartEvent resolved - virtual-server = " + request.getServerName() + ": application = " + request.getContextPath() + " : servlet = " + request.getServletPath());
        }
    }

    @ProbeListener(value="web:request::requestEndEvent")
    public void requestEndEvent(@ProbeParam(value="request") HttpServletRequest request, @ProbeParam(value="response") HttpServletResponse response, @ProbeParam(value="hostName") String hostName, @ProbeParam(value="statusCode") int statusCode) {
        this.logger.finest("[TM]requestEndEvent Unprocessed received - virtual-server = " + request.getServerName() + ": application = " + request.getContextPath() + " : servlet = " + request.getServletPath() + " :Response code = " + statusCode + " : Expecting (vsName, appName) = (" + this.virtualServerName + ", " + this.moduleName + ")");
        if (this.virtualServerName != null && this.moduleName != null) {
            String appName;
            String contextPath = request.getContextPath();
            String string = appName = contextPath == null ? null : WebTelemetryBootstrap.getAppName(contextPath);
            if (appName != null && hostName != null && hostName.equals(this.virtualServerName) && appName.equals(this.moduleName)) {
                this.requestProcessTime.exit();
                if (statusCode > 400) {
                    this.errorCount.increment();
                }
                this.logger.finest("[TM]requestEndEvent resolved - virtual-server = " + request.getServerName() + ": application = " + contextPath + " :appName = " + appName + " : servlet = " + request.getServletPath() + " : port = " + request.getServerPort() + " :Response code = " + statusCode + " :Response time = " + this.requestProcessTime.getTime());
            }
        } else {
            this.requestProcessTime.exit();
            if (statusCode > 400) {
                this.errorCount.increment();
            }
            this.logger.finest("[TM]requestEndEvent resolved - virtual-server = " + request.getServerName() + ": application = " + request.getContextPath() + " : servlet = " + request.getServletPath() + " : port = " + request.getServerPort() + " :Response code = " + statusCode + " :Response time = " + this.requestProcessTime.getTime());
        }
    }

    public long getProcessTime() {
        return this.requestProcessTime.getTotalTime() / this.requestProcessTime.getCount();
    }

    public void setProbeListenerHandles(Collection<ProbeClientMethodHandle> handles) {
        this.handles = handles;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void enableMonitoring(boolean flag) {
        if (this.isEnabled != flag) {
            for (ProbeClientMethodHandle handle : this.handles) {
                if (flag) {
                    handle.enable();
                    continue;
                }
                handle.disable();
            }
            this.webRequestNode.setEnabled(flag);
            this.isEnabled = flag;
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.virtualServerName;
    }
}

