/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.RepositoryChangeListener;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.logging.Level;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.osgiadapter.BundleEventType;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiFactoryImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HK2Main
implements BundleActivator,
SynchronousBundleListener {
    private BundleContext ctx;
    private ModulesRegistry mr;
    private String repName = "modules";
    private static final String CONTEXT_ROOT_DIR_PROP = HK2Main.class.getPackage().getName() + ".contextrootdir";
    private File contextRootDir;
    private Habitat habitat;

    public void start(BundleContext context) throws Exception {
        ModuleStartup startup;
        this.ctx = context;
        Logger.logger.logp(Level.FINE, "HK2Main", "run", "Thread.currentThread().getContextClassLoader() = {0}", Thread.currentThread().getContextClassLoader());
        Logger.logger.logp(Level.FINE, "HK2Main", "run", "this.getClass().getClassLoader() = {0}", this.getClass().getClassLoader());
        this.ctx.addBundleListener((BundleListener)this);
        this.contextRootDir = context.getProperty(CONTEXT_ROOT_DIR_PROP) != null ? new File(context.getProperty(CONTEXT_ROOT_DIR_PROP)) : new File(System.getProperty("user.home"));
        Logger.logger.logp(Level.INFO, "HK2Main", "start", "contextRootDir = {0}", this.contextRootDir);
        StartupContext startupContext = new StartupContext(this.contextRootDir, new String[0]);
        OSGiFactoryImpl.initialize(this.ctx);
        this.mr = AbstractFactory.getInstance().createModulesRegistry();
        Collection<? extends Repository> reps = this.createRepositories();
        for (Repository repository : reps) {
            this.mr.addRepository(repository);
        }
        this.habitat = this.mr.newHabitat();
        this.habitat.add((Inhabitant)new ExistingSingletonInhabitant((Object)startupContext));
        this.habitat.add((Inhabitant)new ExistingSingletonInhabitant((Object)java.util.logging.Logger.global));
        this.habitat.add((Inhabitant)new ExistingSingletonInhabitant(ModulesRegistry.class, (Object)this.mr));
        this.mr.createHabitat("default", this.habitat);
        Collection collection = this.habitat.getAllByContract(ModuleStartup.class);
        switch (collection.size()) {
            case 0: {
                throw new RuntimeException("No module with ModuleStartup implementation found");
            }
            case 1: {
                startup = (ModuleStartup)collection.iterator().next();
                break;
            }
            default: {
                throw new RuntimeException("Multiple ModuleStartup classes found");
            }
        }
        startup.setStartupContext(startupContext);
        startup.run();
    }

    private void createServiceTracker() {
        ServiceTracker st = new ServiceTracker(this.ctx, (Filter)new NonHK2ServiceFilter(), (ServiceTrackerCustomizer)new HK2ServiceTrackerCustomizer());
        st.open(true);
    }

    private Collection<? extends Repository> createRepositories() {
        ArrayList<DirectoryBasedRepository> reps = new ArrayList<DirectoryBasedRepository>();
        DirectoryBasedRepository rep = new DirectoryBasedRepository(this.repName, this.contextRootDir);
        try {
            rep.initialize();
            reps.add(rep);
        }
        catch (IOException e) {
            try {
                rep.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
        for (File file : this.contextRootDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            rep = new DirectoryBasedRepository(file.getName(), file);
            try {
                rep.initialize();
                reps.add(rep);
            }
            catch (IOException e) {
                try {
                    rep.shutdown();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                Logger.logger.log(Level.SEVERE, "Cannot initialize repository at " + file.getAbsolutePath(), e);
            }
        }
        for (Repository repository : reps) {
            repository.addListener(new RepositoryChangeListener(){

                public void jarAdded(URI location) {
                }

                public void jarRemoved(URI location) {
                }

                public void moduleAdded(ModuleDefinition definition) {
                }

                public void moduleRemoved(ModuleDefinition definition) {
                }
            });
        }
        Logger.logger.exiting("HK2Main", "createRepositories", reps);
        return reps;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.mr != null) {
            this.mr.shutdown();
        }
    }

    public void bundleChanged(BundleEvent event) {
        Logger.logger.logp(Level.FINE, "BundleListenerImpl", "bundleChanged", "source= {0}, type= {1}", new Object[]{event.getSource(), BundleEventType.valueOf(event.getType())});
    }

    private class HK2ServiceTrackerCustomizer
    implements ServiceTrackerCustomizer {
        private HK2ServiceTrackerCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            Object object = HK2Main.this.ctx.getService(reference);
            HK2Main.this.habitat.add((Inhabitant)new ExistingSingletonInhabitant(object));
            Logger.logger.logp(Level.INFO, "HK2Main$HK2ServiceTrackerCustomizer", "addingService", "object = {0}", object);
            return object;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
        }
    }

    private class NonHK2ServiceFilter
    implements Filter {
        private NonHK2ServiceFilter() {
        }

        public boolean match(ServiceReference serviceReference) {
            return !HK2Main.this.ctx.getBundle().equals(serviceReference.getBundle());
        }

        public boolean match(Dictionary dictionary) {
            throw new RuntimeException("Unexpected method called");
        }

        public boolean matchCase(Dictionary dictionary) {
            throw new RuntimeException("Unexpected method called");
        }

        public String toString() {
            return "(objectClass=*)";
        }
    }
}

