/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.LifecyclePolicy;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleChangeListener;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.ResolveError;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantsParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiModulesRegistryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.RequiredBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OSGiModuleImpl
implements Module {
    private Bundle bundle;
    private ModuleDefinition md;
    private OSGiModulesRegistryImpl registry;
    private ModuleState state;
    private LifecyclePolicy lifecyclePolicy;
    private boolean sticky;

    public OSGiModuleImpl(OSGiModulesRegistryImpl registry, Bundle bundle, ModuleDefinition md) {
        this.registry = registry;
        this.bundle = bundle;
        this.md = md;
        this.state = ModuleState.NEW;
    }

    public ModuleDefinition getModuleDefinition() {
        return this.md;
    }

    public String getName() {
        return this.md.getName();
    }

    public ModulesRegistry getRegistry() {
        return this.registry;
    }

    public ModuleState getState() {
        return this.state;
    }

    public synchronized void resolve() throws ResolveError {
        if (this.state == ModuleState.RESOLVED) {
            return;
        }
        try {
            this.bundle.start();
            this.state = ModuleState.RESOLVED;
        }
        catch (BundleException e) {
            throw new ResolveError((Throwable)e);
        }
    }

    public synchronized void start() throws ResolveError {
        if (this.state == ModuleState.READY) {
            return;
        }
        this.resolve();
        if (this.md.getLifecyclePolicyClassName() != null) {
            try {
                Class lifecyclePolicyClass = this.bundle.loadClass(this.md.getLifecyclePolicyClassName());
                this.lifecyclePolicy = (LifecyclePolicy)lifecyclePolicyClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                this.state = ModuleState.ERROR;
                throw new ResolveError("ClassNotFound : " + e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                this.state = ModuleState.ERROR;
                throw new ResolveError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.state = ModuleState.ERROR;
                throw new ResolveError((Throwable)e);
            }
        }
        if (this.lifecyclePolicy != null) {
            this.lifecyclePolicy.start((Module)this);
        }
        this.state = ModuleState.READY;
    }

    public synchronized boolean stop() {
        if (this.isSticky()) {
            return false;
        }
        this.detach();
        this.registry.getPackageAdmin().refreshPackages(new Bundle[]{this.bundle});
        this.state = ModuleState.NEW;
        return true;
    }

    public void detach() {
        if ((this.bundle.getState() & 2) != 0) {
            return;
        }
        if (this.lifecyclePolicy != null) {
            this.lifecyclePolicy.stop((Module)this);
            this.lifecyclePolicy = null;
        }
        try {
            this.bundle.stop();
            this.bundle.uninstall();
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
        this.state = ModuleState.NEW;
    }

    void uninstall() {
        try {
            this.bundle.uninstall();
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
        this.registry.remove(this);
        this.registry = null;
    }

    public void refresh() {
        URI location = this.md.getLocations()[0];
        File f = new File(location);
        if (f.lastModified() > this.bundle.getLastModified()) {
            try {
                this.bundle.update();
                this.registry.getPackageAdmin().refreshPackages(new Bundle[]{this.bundle});
            }
            catch (BundleException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ModuleMetadata getMetadata() {
        return this.md.getMetadata();
    }

    public <T> Iterable<Class<? extends T>> getProvidersClass(Class<T> serviceClass) {
        return this.getProvidersClass(serviceClass.getName());
    }

    public Iterable<Class> getProvidersClass(String name) {
        ArrayList<Class> r = new ArrayList<Class>();
        for (String provider : this.getMetadata().getEntry((String)name).providerNames) {
            try {
                r.add(this.getClassLoader().loadClass(provider));
            }
            catch (ClassNotFoundException e) {
                Logger.logger.log(Level.SEVERE, "Failed to load " + provider + " from " + this.getName(), e);
            }
        }
        return r;
    }

    public boolean hasProvider(Class serviceClass) {
        String name = serviceClass.getName();
        return this.getMetadata().getEntry(name).hasProvider();
    }

    public void addListener(ModuleChangeListener listener) {
        this.registry.addModuleChangeListener(listener, this);
    }

    public void removeListener(ModuleChangeListener listener) {
        this.registry.removeModuleChangeListener(listener);
    }

    public void dumpState(PrintStream writer) {
        writer.print(this.bundle.toString());
    }

    void parseInhabitants(String name, InhabitantsParser parser) throws IOException {
        Holder<ClassLoader> holder = new Holder<ClassLoader>(){

            public ClassLoader get() {
                return new ClassLoader(){

                    @Override
                    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
                        if (Logger.logger.isLoggable(Level.FINE)) {
                            Logger.logger.logp(Level.FINE, "OSGiModuleImpl", "loadClass", "Loading {0} from bundle: {1}", new Object[]{name, OSGiModuleImpl.this.bundle});
                        }
                        if ((OSGiModuleImpl.this.bundle.getState() & 0x20) == 0) {
                            OSGiModuleImpl.this.start();
                            Logger.logger.logp(Level.INFO, "OSGiModuleImpl", "loadClass", "Started bundle {0}", OSGiModuleImpl.this.bundle);
                        }
                        Class aClass = OSGiModuleImpl.this.bundle.loadClass(name);
                        if (Logger.logger.isLoggable(Level.FINE)) {
                            Logger.logger.logp(Level.FINE, "OSGiModuleImpl", "loadClass", name + ".class.getClassLoader() = {0}", aClass.getClassLoader());
                        }
                        return aClass;
                    }
                };
            }
        };
        for (ModuleMetadata.InhabitantsDescriptor d : this.md.getMetadata().getHabitats(name)) {
            parser.parse(d.createScanner(), (Holder)holder);
        }
    }

    public ClassLoader getClassLoader() {
        return new ClassLoader(Bundle.class.getClassLoader()){

            @Override
            protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                return OSGiModuleImpl.this.bundle.loadClass(name);
            }

            @Override
            public URL getResource(String name) {
                return OSGiModuleImpl.this.bundle.getResource(name);
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                Enumeration resources = OSGiModuleImpl.this.bundle.getResources(name);
                if (resources == null) {
                    resources = new Enumeration<URL>(){

                        @Override
                        public boolean hasMoreElements() {
                            return false;
                        }

                        @Override
                        public URL nextElement() {
                            throw new NoSuchElementException();
                        }
                    };
                }
                return resources;
            }

            public String toString() {
                return "Class Loader for Bundle [" + OSGiModuleImpl.this.bundle.toString() + " ]";
            }
        };
    }

    public void addImport(Module module) {
        throw new UnsupportedOperationException("This method can't be implemented in OSGi environment");
    }

    public Module addImport(ModuleDependency dependency) {
        throw new UnsupportedOperationException("This method can't be implemented in OSGi environment");
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public List<Module> getImports() {
        ArrayList<Module> result = new ArrayList<Module>();
        RequiredBundle[] requiredBundles = this.registry.getPackageAdmin().getRequiredBundles(this.bundle.getSymbolicName());
        if (requiredBundles != null) {
            for (RequiredBundle rb : requiredBundles) {
                Module m = this.registry.getModule(rb.getBundle());
                if (m == null) continue;
                result.add(m);
            }
        }
        return result;
    }

    public boolean isShared() {
        return true;
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

