/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleChangeListener;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.common_impl.AbstractModulesRegistryImpl;
import com.sun.hk2.component.InhabitantsParser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiModuleImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiModulesRegistryImpl
extends AbstractModulesRegistryImpl {
    BundleContext bctx;
    private PackageAdmin pa;
    private Map<ModuleChangeListener, BundleListener> moduleChangeListeners = new HashMap<ModuleChangeListener, BundleListener>();
    private Map<ModuleLifecycleListener, BundleListener> moduleLifecycleListeners = new HashMap<ModuleLifecycleListener, BundleListener>();

    OSGiModulesRegistryImpl(BundleContext bctx) {
        super(null);
        this.bctx = bctx;
        ServiceReference ref = bctx.getServiceReference(PackageAdmin.class.getName());
        this.pa = (PackageAdmin)PackageAdmin.class.cast(bctx.getService(ref));
    }

    protected Module newModule(ModuleDefinition moduleDef) {
        String location = moduleDef.getLocations()[0].toString();
        try {
            File l;
            if (Logger.logger.isLoggable(Level.FINE)) {
                Logger.logger.logp(Level.FINE, "OSGiModulesRegistryImpl", "add", "location = {0}", location);
            }
            if ((l = new File(moduleDef.getLocations()[0])).isDirectory()) {
                location = "reference:" + location;
            }
            Bundle bundle = this.bctx.installBundle(location);
            return new OSGiModuleImpl(this, bundle, moduleDef);
        }
        catch (BundleException e) {
            Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "add", "Exception {0} while adding location = {1}", new Object[]{e, location});
            return null;
        }
    }

    protected void parseInhabitants(Module module, String name, InhabitantsParser inhabitantsParser) throws IOException {
        ((OSGiModuleImpl)OSGiModuleImpl.class.cast(module)).parseInhabitants(name, inhabitantsParser);
    }

    public ModulesRegistry createChild() {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    public synchronized void detachAll() {
        for (Module m : this.modules.values()) {
            m.detach();
        }
    }

    public synchronized void shutdown() {
        for (Module m : this.modules.values()) {
            ((OSGiModuleImpl)OSGiModuleImpl.class.cast(m)).uninstall();
        }
        this.modules.clear();
        for (Repository repo : this.repositories.values()) {
            try {
                repo.shutdown();
            }
            catch (Exception e) {
                java.util.logging.Logger.getAnonymousLogger().log(Level.SEVERE, "Error while closing repository " + repo, e);
            }
        }
    }

    public void setParentClassLoader(ClassLoader parent) {
        throw new UnsupportedOperationException("This method can't be implemented in OSGi environment");
    }

    public ClassLoader getParentClassLoader() {
        return Bundle.class.getClassLoader();
    }

    public ClassLoader getModulesClassLoader(final ClassLoader parent, Collection<ModuleDefinition> mds) throws ResolveError {
        final ArrayList<ClassLoader> delegateCLs = new ArrayList<ClassLoader>();
        final ArrayList<Module> delegateModules = new ArrayList<Module>();
        for (ModuleDefinition md : mds) {
            Module m = this.makeModuleFor(md.getName(), md.getVersion());
            delegateModules.add(m);
            delegateCLs.add(m.getClassLoader());
        }
        return new URLClassLoader(new URL[0], parent){

            @Override
            public URL[] getURLs() {
                ArrayList<URL> result = new ArrayList<URL>();
                if (parent instanceof URLClassLoader) {
                    URL[] parentURLs = ((URLClassLoader)URLClassLoader.class.cast(parent)).getURLs();
                    result.addAll(Arrays.asList(parentURLs));
                }
                for (Module m : delegateModules) {
                    ModuleDefinition md = m.getModuleDefinition();
                    URI[] uris = md.getLocations();
                    URL[] urls = new URL[uris.length];
                    for (int i = 0; i < uris.length; ++i) {
                        try {
                            urls[i] = uris[i].toURL();
                            continue;
                        }
                        catch (MalformedURLException e) {
                            Logger.logger.warning("Exception " + e + " while converting " + uris[i] + " to URL");
                        }
                    }
                    result.addAll(Arrays.asList(urls));
                }
                return result.toArray(new URL[0]);
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                for (ClassLoader delegate : delegateCLs) {
                    try {
                        return delegate.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
                throw new ClassNotFoundException(name);
            }

            @Override
            public URL findResource(String name) {
                URL resource = null;
                for (ClassLoader delegate : delegateCLs) {
                    resource = delegate.getResource(name);
                    if (resource == null) continue;
                    return resource;
                }
                return resource;
            }

            @Override
            public Enumeration<URL> findResources(String name) throws IOException {
                ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
                for (ClassLoader delegate : delegateCLs) {
                    Enumeration<URL> enumerator = delegate.getResources(name);
                    enumerators.add(enumerator);
                }
                return new CompositeEnumeration(enumerators);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class CompositeEnumeration
            implements Enumeration<URL> {
                Enumeration<URL>[] enumerators;
                int index = 0;

                public CompositeEnumeration(List<Enumeration<URL>> enumerators) {
                    this.enumerators = enumerators.toArray(new Enumeration[enumerators.size()]);
                }

                @Override
                public boolean hasMoreElements() {
                    Enumeration<URL> current = this.getCurrent();
                    return current != null;
                }

                @Override
                public URL nextElement() {
                    Enumeration<URL> current = this.getCurrent();
                    if (current != null) {
                        return current.nextElement();
                    }
                    throw new NoSuchElementException("No more elements in this enumeration");
                }

                private Enumeration<URL> getCurrent() {
                    for (int start = this.index; start < this.enumerators.length; ++start) {
                        Enumeration<URL> e = this.enumerators[start];
                        if (!e.hasMoreElements()) continue;
                        this.index = start;
                        return e;
                    }
                    this.index = this.enumerators.length;
                    return null;
                }
            }
        };
    }

    public Module find(Class clazz) {
        Object hk2ModuleName;
        Bundle b = this.pa.getBundle(clazz);
        if (b != null && (hk2ModuleName = b.getHeaders().get("HK2-Bundle-Name")) != null) {
            return (Module)this.modules.get(hk2ModuleName);
        }
        return null;
    }

    public PackageAdmin getPackageAdmin() {
        return this.pa;
    }

    public void addModuleChangeListener(final ModuleChangeListener listener, final OSGiModuleImpl module) {
        SynchronousBundleListener bundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == module.getBundle() && (event.getType() & 8) == 8) {
                    listener.changed((Module)module);
                }
            }
        };
        this.bctx.addBundleListener((BundleListener)bundleListener);
        this.moduleChangeListeners.put(listener, (BundleListener)bundleListener);
    }

    public boolean removeModuleChangeListener(ModuleChangeListener listener) {
        BundleListener bundleListener = this.moduleChangeListeners.remove(listener);
        if (bundleListener != null) {
            this.bctx.removeBundleListener(bundleListener);
            return true;
        }
        return false;
    }

    public void register(final ModuleLifecycleListener listener) {
        SynchronousBundleListener bundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if ((event.getType() & 2) == 2) {
                    listener.moduleStarted(OSGiModulesRegistryImpl.this.getModule(event.getBundle()));
                }
            }
        };
        this.bctx.addBundleListener((BundleListener)bundleListener);
        this.moduleLifecycleListeners.put(listener, (BundleListener)bundleListener);
    }

    public void unregister(ModuleLifecycleListener listener) {
        BundleListener bundleListener = this.moduleLifecycleListeners.remove(listener);
        if (bundleListener != null) {
            this.bctx.removeBundleListener(bundleListener);
        }
    }

    Map<String, Module> getExistingModules() {
        return Collections.unmodifiableMap(this.modules);
    }

    Module getModule(Bundle bundle) {
        return (Module)this.modules.get(bundle.getHeaders().get("HK2-Bundle-Name"));
    }
}

