/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.plugin;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admingui.plugin.ConsoleConfig;
import org.glassfish.admingui.plugin.IntegrationPoint;
import org.glassfish.admingui.plugin.IntegrationPointComparator;
import org.glassfish.api.admingui.ConsoleProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ConsolePluginService {
    @Inject
    Logger logger;
    @Inject
    Habitat habitat;
    @Inject
    ConsoleProvider[] providers;
    private boolean initialized = false;
    private MultiMap<String, IntegrationPoint> pointsByType = new MultiMap();
    private Map<String, ClassLoader> moduleClassLoaderMap = new HashMap<String, ClassLoader>();

    protected synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.providers != null && this.providers.length > 0) {
            ConfigParser parser = new ConfigParser(this.habitat);
            URL url = null;
            String id = null;
            for (ConsoleProvider provider : this.providers) {
                url = provider.getConfiguration();
                if (url == null) {
                    url = provider.getClass().getClassLoader().getResource("META-INF/admingui/console-config.xml");
                }
                if (url == null) {
                    if (!this.logger.isLoggable(Level.INFO)) continue;
                    this.logger.info("Unable to find META-INF/admingui/console-config.xml file for provider '" + provider.getClass().getName() + "'");
                    continue;
                }
                DomDocument doc = parser.parse(url);
                ConsoleConfig config = (ConsoleConfig)doc.getRoot().get();
                id = config.getId();
                this.moduleClassLoaderMap.put(id, provider.getClass().getClassLoader());
                this.addIntegrationPoints(config.getIntegrationPoints(), id);
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Console Plugin Service has been Initialized!");
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.pointsByType.toString());
            }
        }
    }

    public void addIntegrationPoints(List<IntegrationPoint> points, String id) {
        for (IntegrationPoint point : points) {
            this.addIntegrationPoint(point, id);
        }
    }

    public void addIntegrationPoint(IntegrationPoint point, String id) {
        point.setConsoleConfigId(id);
        this.pointsByType.add((Object)point.getType(), (Object)point);
    }

    public List<IntegrationPoint> getIntegrationPoints(String type) {
        this.init();
        return this.pointsByType.get((Object)type);
    }

    public IntegrationPointComparator getIntegrationPointComparator() {
        return IntegrationPointComparator.getInstance();
    }

    public ClassLoader getModuleClassLoader(String moduleName) {
        return this.moduleClassLoaderMap.get(moduleName);
    }
}

