/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.faces.integration;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.web.JarURLPattern;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.glassfish.api.web.TldProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service(name="jsfTld")
@Scoped(value=Singleton.class)
public class GlassFishTldProvider
implements TldProvider,
PostConstruct {
    @Inject
    ModulesRegistry registry;
    private List<URL> tldList = Collections.emptyList();

    public URL[] getTldURLs() {
        return this.tldList.toArray(new URL[this.tldList.size()]);
    }

    public void postConstruct() {
        URL[] urls = null;
        Module m = this.registry.find(this.getClass());
        if (m != null) {
            URI[] uris = m.getModuleDefinition().getLocations();
            ArrayList<URL> urlList = new ArrayList<URL>(uris.length);
            for (int i = 0; i < uris.length; ++i) {
                try {
                    urlList.add(uris[i].toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    System.out.println("Ignoring " + uris[i] + " because of " + e);
                }
            }
            urls = urlList.toArray(new URL[urlList.size()]);
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                urls = ((URLClassLoader)classLoader).getURLs();
            } else {
                System.out.println("ClassLoader [" + classLoader + "] is not of type URLClassLoader");
            }
        }
        if (urls != null) {
            Pattern pattern = Pattern.compile("META-INF/.*\\.tld");
            this.tldList = JarURLPattern.getJarEntryURLs((URL[])urls, (Pattern)pattern);
        }
    }
}

