/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.common_impl;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.bootstrap.Populator;
import com.sun.enterprise.module.common_impl.AdapterIterator;
import com.sun.enterprise.module.common_impl.FlattenIterator;
import com.sun.hk2.component.InhabitantsParser;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModulesRegistryImpl
implements ModulesRegistry {
    protected final AbstractModulesRegistryImpl parent;
    protected final ConcurrentMap<String, Module> modules = new ConcurrentHashMap<String, Module>();
    protected final Map<Integer, Repository> repositories = new TreeMap<Integer, Repository>();
    private final ConcurrentMap<Class, CopyOnWriteArrayList> runningServices = new ConcurrentHashMap<Class, CopyOnWriteArrayList>();
    protected final Map<String, Module> providers = new HashMap<String, Module>();

    protected AbstractModulesRegistryImpl(AbstractModulesRegistryImpl parent) {
        this.parent = parent;
    }

    @Override
    public Habitat newHabitat() throws ComponentException {
        return new Habitat();
    }

    @Override
    public Habitat createHabitat(String name) throws ComponentException {
        Habitat h = this.newHabitat();
        return this.createHabitat(name, h);
    }

    @Override
    public Habitat createHabitat(String name, Habitat h) throws ComponentException {
        try {
            if (h == null) {
                h = this.newHabitat();
            }
            InhabitantsParser inhabitantsParser = new InhabitantsParser(h);
            for (Module module : this.getModules()) {
                this.parseInhabitants(module, name, inhabitantsParser);
            }
            ConfigParser configParser = new ConfigParser(h);
            for (Populator p : h.getAllByContract(Populator.class)) {
                p.run(configParser);
            }
            return h;
        }
        catch (IOException e) {
            throw new ComponentException("Failed to create a habitat", (Throwable)e);
        }
    }

    protected abstract void parseInhabitants(Module var1, String var2, InhabitantsParser var3) throws IOException;

    @Override
    public synchronized void addRepository(Repository repository, int weight) {
        while (this.repositories.containsKey(weight)) {
            ++weight;
        }
        this.repositories.put(weight, repository);
    }

    @Override
    public synchronized void addRepository(Repository repository) {
        this.repositories.put(100 + this.repositories.size(), repository);
    }

    @Override
    public synchronized void removeRepository(String name) {
        for (Integer weight : this.repositories.keySet()) {
            Repository repo = this.repositories.get(weight);
            if (!repo.getName().equals(name)) continue;
            this.repositories.remove(weight);
            return;
        }
    }

    @Override
    public synchronized Repository getRepository(String name) {
        for (Integer weight : this.repositories.keySet()) {
            Repository repo = this.repositories.get(weight);
            if (!repo.getName().equals(name)) continue;
            return repo;
        }
        return null;
    }

    @Override
    public Module makeModuleFor(String name, String version) throws ResolveError {
        Module module;
        Logger.getAnonymousLogger().fine("this.makeModuleFor(" + name + ", " + version + ") called.");
        if (this.parent != null && (module = this.parent.makeModuleFor(name, version)) != null) {
            return module;
        }
        module = (Module)this.modules.get(name);
        if (module == null && (module = this.loadFromRepository(name, version)) != null) {
            this.add(module);
        }
        if (module != null) {
            module.resolve();
        }
        Logger.getAnonymousLogger().fine("this.makeModuleFor(" + name + ", " + version + ") returned " + module);
        return module;
    }

    @Override
    public Module makeModuleFor(String packageName) throws ResolveError {
        Module m;
        if (this.parent != null && (m = this.parent.makeModuleFor(packageName)) != null) {
            return m;
        }
        for (Module module : this.modules.values()) {
            String[] exportedPkgs;
            for (String exportedPkg : exportedPkgs = module.getModuleDefinition().getPublicInterfaces()) {
                if (!exportedPkg.equals(packageName)) continue;
                module.resolve();
                return module;
            }
        }
        return null;
    }

    protected Module loadFromRepository(String name, String version) {
        Set<Integer> keys = this.repositories.keySet();
        TreeSet<Integer> sortedKeys = new TreeSet<Integer>();
        sortedKeys.addAll(keys);
        for (Integer key : sortedKeys) {
            Repository repo = this.repositories.get(key);
            ModuleDefinition moduleDef = repo.find(name, version);
            if (moduleDef == null) continue;
            return this.newModule(moduleDef);
        }
        return null;
    }

    protected abstract Module newModule(ModuleDefinition var1);

    private void add(Module newModule) {
        assert (newModule.getRegistry() == this);
        this.modules.put(newModule.getModuleDefinition().getName(), newModule);
        for (ModuleMetadata.Entry spi : newModule.getMetadata().getEntries()) {
            for (String name : spi.providerNames) {
                this.providers.put(name, newModule);
            }
        }
    }

    public void remove(Module module) {
        assert (module.getRegistry() == this);
        this.modules.remove(module.getModuleDefinition().getName());
    }

    @Override
    public synchronized Collection<Module> getModules() {
        Set<Integer> keys = this.repositories.keySet();
        TreeSet<Integer> sortedKeys = new TreeSet<Integer>();
        sortedKeys.addAll(keys);
        for (Integer key : sortedKeys) {
            Repository repo = this.repositories.get(key);
            for (ModuleDefinition moduleDef : repo.findAll()) {
                Module newModule;
                if (this.modules.get(moduleDef.getName()) != null || (newModule = this.newModule(moduleDef)) == null) continue;
                this.add(newModule);
            }
        }
        return this.modules.values();
    }

    @Override
    public void changed(Module service) {
        System.out.println("I have received changed event from " + service);
        this.remove(service);
        ModuleDefinition info = service.getModuleDefinition();
        Module newService = this.newModule(info);
        this.add(newService);
    }

    @Override
    public synchronized Module add(ModuleDefinition info) throws ResolveError {
        Module service = this.makeModuleFor(info.getName(), info.getVersion());
        if (service == null) {
            service = this.newModule(info);
            this.add(service);
        }
        return service;
    }

    @Override
    public void print(Logger logger) {
        logger.info("Modules Registry information : " + this.modules.size() + " modules");
        for (Module module : this.modules.values()) {
            logger.info(module.getModuleDefinition().getName());
        }
    }

    @Override
    public <T> Iterable<Class<? extends T>> getProvidersClass(final Class<T> serviceClass) {
        return new Iterable<Class<? extends T>>(){

            @Override
            public Iterator<Class<? extends T>> iterator() {
                return new FlattenIterator(new AdapterIterator<Iterator<Class<? extends T>>, Module>(AbstractModulesRegistryImpl.this.getModules().iterator()){

                    @Override
                    protected Iterator<Class<? extends T>> adapt(Module module) {
                        return module.getProvidersClass(serviceClass).iterator();
                    }
                });
            }
        };
    }

    @Override
    public Iterable<Module> getModulesProvider(final Class serviceClass) {
        return new Iterable<Module>(){

            @Override
            public Iterator<Module> iterator() {
                return new AdapterIterator<Module, Module>(AbstractModulesRegistryImpl.this.getModules().iterator()){

                    @Override
                    protected Module adapt(Module m) {
                        if (m.hasProvider(serviceClass)) {
                            return m;
                        }
                        return null;
                    }
                };
            }
        };
    }

    @Override
    public <T> void registerRunningService(Class<T> serviceClass, T provider) {
        CopyOnWriteArrayList existing;
        CopyOnWriteArrayList<T> rs = (CopyOnWriteArrayList<T>)this.runningServices.get(serviceClass);
        if (rs == null && (existing = this.runningServices.putIfAbsent(serviceClass, rs = new CopyOnWriteArrayList<T>())) != null) {
            rs = existing;
        }
        rs.add(provider);
    }

    @Override
    public <T> boolean unregisterRunningService(Class<T> serviceClass, T provider) {
        CopyOnWriteArrayList rs = (CopyOnWriteArrayList)this.runningServices.get(serviceClass);
        if (rs == null) {
            return false;
        }
        return rs.remove(provider);
    }

    @Override
    public <T> List<T> getRunningServices(Class<T> serviceClass) {
        List r = (List)this.runningServices.get(serviceClass);
        if (r != null) {
            return r;
        }
        return Collections.emptyList();
    }

    public Module getProvidingModule(String providerClassName) {
        return this.providers.get(providerClassName);
    }

    @Override
    public void dumpState(PrintStream writer) {
        writer.println("Registry Info");
        for (Repository repo : this.repositories.values()) {
            writer.println("Attached repository : " + repo.getName());
            writer.println(repo.toString());
        }
        for (Module module : this.getModules()) {
            writer.println("Registered Module " + module.getModuleDefinition().getName());
            module.dumpState(writer);
        }
    }
}

