/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigBeansUtilities {
    private ConfigBeansUtilities() {
    }

    public static <T> List<T> getModules(Class<T> type, Applications apps) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : apps.getModules()) {
            if (!module.getClass().getName().equals(type.getClass().getName())) continue;
            modules.add(module);
        }
        return modules;
    }

    public static <T> T getModule(Class<T> type, Applications apps, String moduleID) {
        if (moduleID == null) {
            return null;
        }
        for (Module module : apps.getModules()) {
            Method m;
            if (!module.getClass().getName().equals(type.getClass().getName())) continue;
            try {
                m = type.getMethod("getName", new Class[0]);
            }
            catch (SecurityException ex) {
                return null;
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
            if (m == null) continue;
            try {
                if (!moduleID.equals(m.invoke((Object)module, new Object[0]))) continue;
                return (T)module;
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
            catch (IllegalAccessException ex) {
                return null;
            }
            catch (InvocationTargetException ex) {
                return null;
            }
        }
        return null;
    }

    public static Property getPropertyByName(Object bean, String name) {
        List properties;
        Method m;
        try {
            m = bean.getClass().getMethod("getProperty", new Class[0]);
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        if (m == null) {
            return null;
        }
        try {
            properties = (List)m.invoke(bean, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        catch (InvocationTargetException ex) {
            return null;
        }
        for (Property prop : properties) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public static String getPropertyValueByName(Object bean, String name) {
        Property prop = ConfigBeansUtilities.getPropertyByName(bean, name);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public static String getDefaultFormat() {
        return "%client.name% %auth-user-name% %datetime% %request% %status% %response.length%".trim();
    }

    public static String getDefaultRotationPolicy() {
        return "time".trim();
    }

    public static String getDefaultRotationEnabled() {
        return "true".trim();
    }

    public static String getDefaultRotationIntervalInMinutes() {
        return "1440".trim();
    }

    public static String getDefaultQueueSizeInBytes() {
        return "4096".trim();
    }

    public static boolean toBoolean(String value) {
        String v = null != value ? value.trim() : value;
        return null != v && (v.equals("true") || v.equals("yes") || v.equals("on") || v.equals("1"));
    }

    public static List<Application> getSystemApplicationsReferencedFrom(Domain d, String sn) {
        if (d == null || sn == null) {
            throw new IllegalArgumentException("Null argument");
        }
        List<Application> allApps = ConfigBeansUtilities.getAllDefinedSystemApplications(d);
        if (allApps.size() == 0) {
            return allApps;
        }
        Server s = ConfigBeansUtilities.getServerNamed(sn, d);
        ArrayList<Application> referencedApps = new ArrayList<Application>();
        List<ApplicationRef> appsReferenced = s.getApplicationRef();
        for (ApplicationRef ref : appsReferenced) {
            for (Application app : allApps) {
                if (!ref.getRef().equals(app.getName())) continue;
                referencedApps.add(app);
            }
        }
        return referencedApps;
    }

    public static Application getSystemApplicationReferencedFrom(Domain d, String sn, String appName) {
        List<Application> allApps = ConfigBeansUtilities.getSystemApplicationsReferencedFrom(d, sn);
        for (Application app : allApps) {
            if (!app.getName().equals(appName)) continue;
            return app;
        }
        return null;
    }

    public static boolean isNamedSystemApplicationReferencedFrom(Domain d, String appName, String serverName) {
        List<Application> referencedApps = ConfigBeansUtilities.getSystemApplicationsReferencedFrom(d, serverName);
        for (Application app : referencedApps) {
            if (!app.getName().equals(appName)) continue;
            return true;
        }
        return false;
    }

    public static Server getServerNamed(String name, Domain d) {
        if (d == null || d.getServers() == null || name == null) {
            throw new IllegalArgumentException("Either domain is null or no <servers> element");
        }
        List<Server> servers = d.getServers().getServer();
        for (Server s : servers) {
            if (!name.equals(s.getName().trim())) continue;
            return s;
        }
        return null;
    }

    public static List<Application> getAllDefinedSystemApplications(Domain d) {
        ArrayList<Application> allSysApps = new ArrayList<Application>();
        SystemApplications sa = d.getSystemApplications();
        if (sa != null) {
            for (Module m : sa.getModules()) {
                if (!(m instanceof Application)) continue;
                allSysApps.add((Application)m);
            }
        }
        return allSysApps;
    }

    public static ApplicationRef getApplicationRefInServer(Domain d, String sn, String name) {
        Servers ss = d.getServers();
        List<Server> list = ss.getServer();
        Server theServer = null;
        for (Server s : list) {
            if (!s.getName().equals(sn)) continue;
            theServer = s;
            break;
        }
        ApplicationRef aref = null;
        if (theServer != null) {
            List<ApplicationRef> arefs = theServer.getApplicationRef();
            for (ApplicationRef ar : arefs) {
                if (!ar.getRef().equals(name)) continue;
                aref = ar;
                break;
            }
        }
        return aref;
    }
}

