/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.config;

import com.sun.appserv.management.util.misc.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.amx.loader.AMXConfigVoid;
import org.glassfish.admin.amx.util.AMXConfigInfoResolver;
import org.glassfish.api.amx.AMXConfigInfo;
import org.glassfish.api.amx.AMXCreatorInfo;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ContainedTypeInfo {
    final ConfigBean mConfigBean;
    final Map<String, Class<? extends ConfigBeanProxy>> mMappings;

    private static void cdebug(String s) {
        System.out.println(s);
    }

    public ContainedTypeInfo(ConfigBean configBean) {
        this.mConfigBean = configBean;
        this.mMappings = this.findAllContainedJ2EETypes();
    }

    private static List<Class<? extends ConfigBeanProxy>> getSubTypes(ConfigBean cb) {
        List<Class<? extends ConfigBeanProxy>> result = null;
        try {
            Class[] subTypes = ConfigSupport.getSubElementsTypes((ConfigBean)cb);
            result = new ArrayList();
            for (Class theClass : subTypes) {
                result.add(theClass);
            }
        }
        catch (Exception e) {
            result = Collections.emptyList();
            e.printStackTrace();
        }
        return result;
    }

    public Class<? extends ConfigBeanProxy> getConfigBeanProxyClassFor(String j2eeType) {
        return this.mMappings.get(j2eeType);
    }

    AMXConfigInfoResolver getAMXConfigInfoResolverFor(String j2eeType) {
        Class<? extends ConfigBeanProxy> proxyIntf = this.getConfigBeanProxyClassFor(j2eeType);
        if (proxyIntf == null) {
            throw new IllegalArgumentException("No such subtype for AMX j2eeType: " + j2eeType);
        }
        AMXConfigInfo amxConfigInfo = proxyIntf.getAnnotation(AMXConfigInfo.class);
        return new AMXConfigInfoResolver(amxConfigInfo);
    }

    List<Class<? extends ConfigBeanProxy>> getAllContainedConfigBeanProxyTypes() {
        ConfigBean cb = this.mConfigBean;
        ArrayList<Class<? extends ConfigBeanProxy>> result = new ArrayList<Class<? extends ConfigBeanProxy>>();
        List<Class<? extends ConfigBeanProxy>> candidates = ContainedTypeInfo.getSubTypes(cb);
        result.addAll(candidates);
        Class proxyClass = cb.getProxyType();
        AMXCreatorInfo creatorInfo = proxyClass.getAnnotation(AMXCreatorInfo.class);
        if (creatorInfo != null) {
            Object[] creatables = creatorInfo.creatables();
            CollectionUtil.addAll(result, (Object[])creatables);
        }
        return result;
    }

    Map<String, Class<? extends ConfigBeanProxy>> findAllContainedJ2EETypes() {
        String amxVoid = AMXConfigVoid.class.getName();
        HashMap<String, Class<? extends ConfigBeanProxy>> m = new HashMap<String, Class<? extends ConfigBeanProxy>>();
        List<Class<? extends ConfigBeanProxy>> candidates = this.getAllContainedConfigBeanProxyTypes();
        for (Class<? extends ConfigBeanProxy> intf : candidates) {
            AMXConfigInfo amxConfigInfo = intf.getAnnotation(AMXConfigInfo.class);
            if (amxConfigInfo == null || amxVoid.equals(amxConfigInfo.amxInterfaceName())) continue;
            AMXConfigInfoResolver r = new AMXConfigInfoResolver(amxConfigInfo);
            String j2eeType = r.j2eeType();
            m.put(j2eeType, intf);
        }
        return m;
    }
}

