/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.config;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.ListUtil;
import com.sun.appserv.management.util.misc.TypeCast;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import org.glassfish.admin.amx.config.AttrInfo;
import org.glassfish.admin.amx.config.NameMappingHelper;
import org.glassfish.admin.amx.mbean.DelegateBase;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.WriteableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegateToConfigBeanDelegate
extends DelegateBase {
    private final ConfigBean mConfigBean;
    private final NameMappingHelper mNameMappingHelper;

    private static void debug(String s) {
        System.out.println(s);
    }

    public DelegateToConfigBeanDelegate(ConfigBean configBean) {
        super("DelegateToConfigBeanDelegate." + configBean.toString());
        this.mConfigBean = configBean;
        this.mNameMappingHelper = new NameMappingHelper(configBean);
    }

    @Override
    public boolean supportsAttribute(String amxAttrName) {
        String xmlName = this.mNameMappingHelper.getXMLName(amxAttrName);
        return xmlName != null;
    }

    public ConfigBean getConfigBean() {
        return this.mConfigBean;
    }

    @Override
    public final Object getAttribute(String amxName) throws AttributeNotFoundException {
        AttrInfo info = this.mNameMappingHelper.getAttrInfo_AMX(amxName);
        Object[] result = null;
        String xmlName = info.xmlName();
        if (info.isCollection()) {
            List leafElementsX = this.mConfigBean.leafElements(xmlName);
            if (leafElementsX != null) {
                List leafElements = TypeCast.checkList((List)leafElementsX, String.class);
                result = CollectionUtil.toArray((Collection)leafElements, String.class);
            }
        } else {
            result = this.mConfigBean.rawAttribute(xmlName);
        }
        return result;
    }

    private Map<String, PropertyChangeEvent> makePropertyChangeEventMap(List<PropertyChangeEvent> changeEvents) {
        HashMap<String, PropertyChangeEvent> m = new HashMap<String, PropertyChangeEvent>();
        for (PropertyChangeEvent changeEvent : changeEvents) {
            if (changeEvent.getPropertyName() == null) {
                throw new IllegalArgumentException("PropertyChangeEvent property names must be specified");
            }
            m.put(changeEvent.getPropertyName(), changeEvent);
        }
        return m;
    }

    private void joinTransaction(Transaction t, WriteableView writeable) throws TransactionFailure {
        if (!writeable.join(t)) {
            t.rollback();
            throw new TransactionFailure("Cannot enlist " + writeable.getProxyType() + " in transaction", null);
        }
    }

    private static void commit(Transaction t) throws TransactionFailure {
        try {
            t.commit();
        }
        catch (RetryableException e) {
            DelegateToConfigBeanDelegate.debug("Retryable...");
            t.rollback();
            throw new TransactionFailure(e.getMessage(), (Throwable)e);
        }
        catch (TransactionFailure e) {
            DelegateToConfigBeanDelegate.debug("failure, not retryable...");
            t.rollback();
            throw e;
        }
    }

    static <T extends ConfigBeanProxy> WriteableView getWriteableView(T s, ConfigBean sourceBean) throws TransactionFailure {
        WriteableView f = new WriteableView(s);
        if (sourceBean.getLock().tryLock()) {
            return f;
        }
        throw new TransactionFailure("Config bean already locked " + sourceBean, null);
    }

    private static Type getCollectionGenericType() throws NoSuchMethodException {
        return ConfigSupport.class.getDeclaredMethod("defaultPropertyValue", null).getGenericReturnType();
    }

    private static boolean isCollectionCmd(String s) {
        return s != null && s.startsWith("###") && s.endsWith("###");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(ConfigBean cb, Map<String, Object> changes) throws TransactionFailure {
        Transaction t = new Transaction();
        Class intf = cb.getProxyType();
        ConfigBeanProxy readableView = cb.getProxy(intf);
        WriteableView writeable = DelegateToConfigBeanDelegate.getWriteableView(readableView, cb);
        try {
            this.joinTransaction(t, writeable);
            for (String xmlName : changes.keySet()) {
                Object value = changes.get(xmlName);
                ConfigModel.Property prop = this.mNameMappingHelper.getConfigModel_Property(xmlName);
                if (prop.isCollection()) {
                    try {
                        Object o = writeable.getter(prop, DelegateToConfigBeanDelegate.getCollectionGenericType());
                        List existingValuesList = TypeCast.checkList((List)TypeCast.asList((Object)o), String.class);
                        DelegateToConfigBeanDelegate.debug("Existing values: {" + CollectionUtil.toString((Collection)existingValuesList) + "}");
                        ArrayList workList = new ArrayList(existingValuesList);
                        DelegateToConfigBeanDelegate.debug("Work list start: {" + CollectionUtil.toString(workList) + "}");
                        List argValues = ListUtil.asStringList((Object)value);
                        if (argValues.size() == 0) continue;
                        String first = (String)argValues.get(0);
                        String cmd = "###add###";
                        if (DelegateToConfigBeanDelegate.isCollectionCmd(first)) {
                            argValues.remove(0);
                            cmd = first;
                        }
                        DelegateToConfigBeanDelegate.debug("Arg values start: {" + CollectionUtil.toString((Collection)argValues) + "}");
                        if (cmd.equals("###replace###")) {
                            workList.clear();
                            workList.addAll(argValues);
                            DelegateToConfigBeanDelegate.debug("Work list after COLLECTION_OP_REMOVE: {" + CollectionUtil.toString(workList) + "}");
                        } else if (cmd.equals("###remove###")) {
                            workList.removeAll(argValues);
                            DelegateToConfigBeanDelegate.debug("Work list after COLLECTION_OP_REMOVE: {" + CollectionUtil.toString(workList) + "}");
                        } else if (cmd.equals("###add###")) {
                            argValues.removeAll(workList);
                            DelegateToConfigBeanDelegate.debug("Arg values after removeAll(workList): {" + CollectionUtil.toString((Collection)argValues) + "}");
                            workList.addAll(argValues);
                            DelegateToConfigBeanDelegate.debug("Work list after COLLECTION_OP_ADD: {" + CollectionUtil.toString(workList) + "}");
                        } else {
                            throw new IllegalArgumentException(cmd);
                        }
                        boolean IMPAIRED_CONFIG_BEAN_LIST = true;
                        for (String existing : existingValuesList) {
                            if (workList.contains(existing)) continue;
                            existingValuesList.remove(existing);
                        }
                        for (String keepMe : workList) {
                            if (existingValuesList.contains(keepMe)) continue;
                            existingValuesList.add(keepMe);
                        }
                        DelegateToConfigBeanDelegate.debug("Existing values list before commit: {" + CollectionUtil.toString((Collection)existingValuesList) + "}");
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        throw new TransactionFailure("Unknown property name " + xmlName + " on " + intf.getName(), null);
                    }
                }
                if (value == null || value instanceof String) {
                    writeable.setter(prop, value, String.class);
                    continue;
                }
                throw new TransactionFailure("Illegal data type for attribute " + xmlName + ": " + value.getClass().getName());
            }
            DelegateToConfigBeanDelegate.commit(t);
        }
        finally {
            cb.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeList setAttributes(AttributeList attrsIn, Map<String, Object> oldValues) {
        oldValues.clear();
        Map amxAttrs = JMXUtil.attributeListToValueMap((AttributeList)attrsIn);
        HashMap<String, Object> notMatched = new HashMap<String, Object>();
        Map<String, Object> xmlAttrs = this.mNameMappingHelper.mapNamesAndValues(amxAttrs, notMatched);
        if (notMatched.keySet().size() != 0) {
            DelegateToConfigBeanDelegate.debug("setAttributes: failed to map these AMX attributes: {" + CollectionUtil.toString(notMatched.keySet()) + "}");
        }
        AttributeList successfulAttrs = new AttributeList();
        if (xmlAttrs.size() != 0) {
            DelegateToConfigBeanDelegate.debug("DelegateToConfigBeanDelegate.setAttributes(): " + attrsIn.size() + " attributes: {" + CollectionUtil.toString(amxAttrs.keySet()) + "} mapped to xml names {" + CollectionUtil.toString(xmlAttrs.keySet()) + "}");
            MyTransactionListener myListener = new MyTransactionListener(this.mConfigBean);
            Transactions.get().addTransactionsListener((TransactionListener)myListener);
            try {
                this.apply(this.mConfigBean, xmlAttrs);
                successfulAttrs.addAll(attrsIn);
            }
            catch (TransactionFailure tf) {
                DelegateToConfigBeanDelegate.debug(ExceptionUtil.toString((Throwable)tf));
            }
            finally {
                Transactions.get().waitForDrain();
                Transactions.get().removeTransactionsListener((TransactionListener)myListener);
            }
        }
        return successfulAttrs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MyTransactionListener
    implements TransactionListener {
        private final List<PropertyChangeEvent> mChangeEvents = new ArrayList<PropertyChangeEvent>();
        private final ConfigBean mTarget;

        MyTransactionListener(ConfigBean target) {
            this.mTarget = target;
        }

        public void transactionCommited(List<PropertyChangeEvent> changes) {
            for (PropertyChangeEvent event : changes) {
                Dom dom;
                Object source = event.getSource();
                if (!(source instanceof ConfigBeanProxy) || !((dom = Dom.unwrap((ConfigBeanProxy)((ConfigBeanProxy)source))) instanceof ConfigBean) || this.mTarget != (ConfigBean)dom) continue;
                this.mChangeEvents.add(event);
            }
        }

        List<PropertyChangeEvent> getChangeEvents() {
            return this.mChangeEvents;
        }
    }
}

