/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.config;

import com.sun.appserv.management.base.AMXAttributes;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NameMapping {
    private static final ConcurrentMap<String, NameMapping> INSTANCES = new ConcurrentHashMap<String, NameMapping>();
    private final String mJ2EEType;
    private final ConcurrentMap<String, String> mAMXToXML = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> mXMLToAMX = new ConcurrentHashMap<String, String>();

    private NameMapping(String j2eeType) {
        this.mJ2EEType = j2eeType;
    }

    private static void debug(String s) {
        System.out.println(s);
    }

    public static NameMapping getInstance(String j2eeType) {
        NameMapping inst = (NameMapping)INSTANCES.get(j2eeType);
        if (inst == null) {
            NameMapping newInst = new NameMapping(j2eeType);
            NameMapping existing = INSTANCES.putIfAbsent(j2eeType, newInst);
            inst = existing != null ? existing : newInst;
        }
        return inst;
    }

    public String getXMLName(String amxName) {
        return (String)this.mAMXToXML.get(amxName);
    }

    public String getAMXName(String xmlName) {
        return (String)this.mXMLToAMX.get(xmlName);
    }

    public void pairNames(String amxName, String xmlName) {
        this.mAMXToXML.put(amxName, xmlName);
        this.mXMLToAMX.put(xmlName, amxName);
    }

    public String matchAMXName(String amxName, Set<String> xmlCandidates) {
        if (AMXAttributes.AMX_ATTR_NAMES.contains(amxName) && !"Name".equalsIgnoreCase(amxName)) {
            return null;
        }
        String amxCanonical = amxName.toLowerCase();
        String xmlName = null;
        for (String xmlCandidate : xmlCandidates) {
            String temp = xmlCandidate.replace("-", "");
            if (!temp.equals(amxCanonical)) continue;
            xmlName = xmlCandidate;
            break;
        }
        if (xmlName != null) {
            this.pairNames(amxName, xmlName);
        }
        return xmlName;
    }
}

