/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.config;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.ListUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.admin.amx.config.AttrInfo;
import org.glassfish.admin.amx.config.NameMapping;
import org.glassfish.admin.amx.util.AMXConfigInfoResolver;
import org.glassfish.api.amx.AMXConfigInfo;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NameMappingHelper {
    private final NameMapping mNameMapping;
    private final ConfigBean mConfigBean;

    private static void debug(String s) {
        System.out.println(s);
    }

    public NameMappingHelper(ConfigBean configBean) {
        this.mNameMapping = NameMapping.getInstance(NameMappingHelper.getAMXConfigInfoResolver(configBean).j2eeType());
        this.mConfigBean = configBean;
    }

    public ConfigBean getConfigBean() {
        return this.mConfigBean;
    }

    public NameMapping getNameMapping() {
        return this.mNameMapping;
    }

    public static AMXConfigInfoResolver getAMXConfigInfoResolver(ConfigBean cb) {
        Class proxyClass = cb.getProxyType();
        AMXConfigInfo amxConfigInfo = proxyClass.getAnnotation(AMXConfigInfo.class);
        if (amxConfigInfo == null) {
            throw new IllegalArgumentException();
        }
        return new AMXConfigInfoResolver(amxConfigInfo);
    }

    public AMXConfigInfoResolver getAMXConfigInfoResolver() {
        return NameMappingHelper.getAMXConfigInfoResolver(this.mConfigBean);
    }

    protected ConfigModel.Property getConfigModel_Property(String xmlName) {
        ConfigModel.Property cmp = this.mConfigBean.model.findIgnoreCase(xmlName);
        if (cmp == null) {
            throw new IllegalArgumentException("Illegal name: " + xmlName);
        }
        return cmp;
    }

    public boolean isLeaf(String xmlName) {
        return this.getConfigModel_Property(xmlName).isLeaf();
    }

    public boolean isCollection(String xmlName) {
        return this.getConfigModel_Property(xmlName).isCollection();
    }

    public AttrInfo getAttrInfo_AMX(String amxName) {
        String xmlName = this.getXMLName(amxName);
        boolean isLeaf = this.isLeaf(xmlName);
        boolean isCollection = this.isCollection(xmlName);
        return new AttrInfo(amxName, this.getXMLName(amxName), isLeaf, isCollection);
    }

    private String smartAttrNameFind(String amxName) {
        AMXConfigInfoResolver info;
        String hint;
        String xmlName = null;
        if (amxName.equals("Name") && (hint = (info = NameMappingHelper.getAMXConfigInfoResolver(this.mConfigBean)).nameHint()) != null && hint.length() != 0) {
            xmlName = hint;
        }
        return xmlName;
    }

    public final String getXMLName(String amxName) {
        String xmlName = this.mNameMapping.getXMLName(amxName);
        if (xmlName == null) {
            xmlName = this.smartAttrNameFind(amxName);
            if (xmlName == null) {
                Set xmlNames = this.mConfigBean.getAttributeNames();
                xmlName = this.mNameMapping.matchAMXName(amxName, xmlNames);
                if (xmlName == null) {
                    Set leafNames = GSetUtil.newStringSet((String[])ConfigSupport.getElementsNames((ConfigBean)this.mConfigBean));
                    xmlName = this.mNameMapping.matchAMXName(amxName, leafNames);
                }
            } else {
                this.mNameMapping.pairNames(amxName, xmlName);
            }
        }
        return xmlName;
    }

    private Object autoStringify(Object o) {
        Object result = o;
        if (o != null && (o instanceof Boolean || o instanceof Integer || o instanceof Long)) {
            result = "" + o;
        }
        return result;
    }

    public Map<String, Object> mapNamesAndValues(Map<String, Object> amxAttrs, Map<String, Object> noMatch) {
        HashMap<String, Object> xmlAttrs = new HashMap<String, Object>();
        for (String amxAttrName : amxAttrs.keySet()) {
            Object valueIn = amxAttrs.get(amxAttrName);
            String xmlName = this.getXMLName(amxAttrName);
            if (xmlName != null) {
                Object value = this.autoStringify(valueIn);
                if (value != valueIn) {
                    NameMappingHelper.debug("Attribute " + amxAttrName + " auto converted from " + valueIn.getClass().getName() + " to " + value.getClass().getName());
                }
                if (valueIn == null || value instanceof String) {
                    xmlAttrs.put(xmlName, (String)value);
                } else if (this.isCollection(xmlName)) {
                    if (valueIn instanceof String[] || valueIn instanceof List) {
                        xmlAttrs.put(xmlName, ListUtil.asStringList((Object)valueIn));
                    } else {
                        noMatch.put(amxAttrName, valueIn);
                    }
                } else {
                    noMatch.put(amxAttrName, valueIn);
                }
                NameMappingHelper.debug("Attribute " + amxAttrName + "<=>" + xmlName + " is of class " + (value == null ? null : value.getClass().getName()));
                continue;
            }
            NameMappingHelper.debug("WARNING: setAttributes(): no xmlName match found for AMX attribute: " + amxAttrName);
            noMatch.put(amxAttrName, valueIn);
        }
        return xmlAttrs;
    }
}

