/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.dotted;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.glassfish.admin.amx.dotted.DottedName;
import org.glassfish.admin.amx.dotted.DottedNameRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DottedNameRegistry1To1Impl
implements DottedNameRegistry {
    final Map<String, ObjectName> mDottedNameStringsToObjectNames = new HashMap<String, ObjectName>(300);
    final Map<ObjectName, String> mObjectNamesToDottedNameStrings = new HashMap<ObjectName, String>(300);
    private static final int INITIAL_CAPACITY = 300;

    @Override
    public synchronized ObjectName dottedNameToObjectName(String dottedName) {
        return this.mDottedNameStringsToObjectNames.get(dottedName);
    }

    public synchronized String objectNameToDottedName(ObjectName objectName) {
        return this.mObjectNamesToDottedNameStrings.get(objectName);
    }

    private <T> Set<T> copySet(Set input) {
        HashSet newSet = new HashSet();
        newSet.addAll(input);
        return newSet;
    }

    @Override
    public synchronized Set<String> allDottedNameStrings() {
        return this.copySet(this.mDottedNameStringsToObjectNames.keySet());
    }

    public synchronized Set allObjectNames() {
        return this.copySet(this.mObjectNamesToDottedNameStrings.keySet());
    }

    @Override
    public synchronized void add(String dottedName, ObjectName objectName) {
        new DottedName(dottedName);
        if (this.objectNameToDottedName(objectName) != null) {
            this.remove(objectName);
        }
        this.mDottedNameStringsToObjectNames.put(dottedName, objectName);
        this.mObjectNamesToDottedNameStrings.put(objectName, dottedName);
    }

    synchronized void remove(String dottedName, ObjectName objectName) {
        if (dottedName != null && objectName != null) {
            this.mDottedNameStringsToObjectNames.remove(dottedName);
            this.mObjectNamesToDottedNameStrings.remove(objectName);
        }
    }

    @Override
    public void remove(String dottedName) {
        this.remove(dottedName, this.dottedNameToObjectName(dottedName));
    }

    @Override
    public void remove(ObjectName objectName) {
        this.remove(this.objectNameToDottedName(objectName), objectName);
    }
}

