/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.dotted;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.admin.amx.dotted.DottedNameLogger;
import org.glassfish.admin.amx.dotted.DottedNameServerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DottedNameServerInfoCache
implements DottedNameServerInfo {
    final DottedNameServerInfo mSrc;
    final Set<String> mConfigNames;
    final Set<String> mServerNames;
    final Map<String, String> mServerToConfig;
    final Map<String, String[]> mConfigToServers;

    public DottedNameServerInfoCache(DottedNameServerInfo src) {
        this.mSrc = src;
        this.mConfigNames = new HashSet<String>();
        this.mServerNames = new HashSet<String>();
        this.mServerToConfig = new HashMap<String, String>();
        this.mConfigToServers = new HashMap<String, String[]>();
    }

    @Override
    public Set<String> getConfigNames() throws DottedNameServerInfo.UnavailableException {
        return this.mConfigNames;
    }

    @Override
    public Set<String> getServerNames() throws DottedNameServerInfo.UnavailableException {
        return this.mServerNames;
    }

    @Override
    public synchronized String getConfigNameForServer(String serverName) throws DottedNameServerInfo.UnavailableException {
        return this.mServerToConfig.get(serverName);
    }

    @Override
    public synchronized String[] getServerNamesForConfig(String configName) throws DottedNameServerInfo.UnavailableException {
        return this.mConfigToServers.get(configName);
    }

    private void _refresh() throws DottedNameServerInfo.UnavailableException {
        this.mConfigNames.clear();
        this.mConfigNames.addAll(this.mSrc.getConfigNames());
        this.mServerNames.clear();
        this.mServerNames.addAll(this.mSrc.getServerNames());
        for (String serverName : this.mServerNames) {
            String configName = this.mSrc.getConfigNameForServer(serverName);
            if (configName == null) continue;
            this.mServerToConfig.put(serverName, configName);
        }
        for (String configName : this.mConfigNames) {
            String[] serverNames = this.mSrc.getServerNamesForConfig(configName);
            if (serverNames == null) continue;
            this.mConfigToServers.put(configName, serverNames);
        }
    }

    public synchronized void refresh() {
        try {
            this._refresh();
        }
        catch (DottedNameServerInfo.UnavailableException e) {
            DottedNameLogger.logException(e);
        }
    }
}

