/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.dotted.valueaccessor;

import com.sun.appserv.management.util.misc.ClassUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.glassfish.admin.amx.dotted.DottedNameStrings;
import org.glassfish.admin.amx.dotted.valueaccessor.ValueAccessorBase;

public class AttributeValueAccessor
extends ValueAccessorBase {
    public AttributeValueAccessor(MBeanServerConnection conn) {
        super(conn);
    }

    public static Set getAllAttributeNames(MBeanServerConnection conn, ObjectName objectName) throws IOException, ReflectionException, InstanceNotFoundException, IntrospectionException {
        HashSet<String> allNames = new HashSet<String>();
        MBeanInfo info = conn.getMBeanInfo(objectName);
        MBeanAttributeInfo[] attrsInfo = info.getAttributes();
        if (attrsInfo != null) {
            for (int i = 0; i < attrsInfo.length; ++i) {
                allNames.add(attrsInfo[i].getName());
            }
        }
        return allNames;
    }

    public Attribute getValue(ObjectName objectName, String valueName) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        Object value = this.getMBS().getAttribute(objectName, valueName);
        return new Attribute(valueName, value);
    }

    Class getAttributeClass(ObjectName objectName, String attributeName) throws IntrospectionException, IOException, ReflectionException, InstanceNotFoundException, ClassNotFoundException {
        MBeanInfo info = this.getMBS().getMBeanInfo(objectName);
        MBeanAttributeInfo[] attrsInfo = info.getAttributes();
        Class theClass = null;
        for (int i = 0; i < attrsInfo.length; ++i) {
            String testName = attrsInfo[i].getName();
            if (!testName.equals(attributeName)) continue;
            theClass = ClassUtil.getClassFromName((String)attrsInfo[i].getType());
            break;
        }
        return theClass;
    }

    public Attribute setValue(ObjectName objectName, Attribute attr) throws Exception {
        if (attr.getValue() == null) {
            String msg = DottedNameStrings.getString("IllegalToSetNull", attr.getName());
            throw new IllegalArgumentException(msg);
        }
        Attribute actualAttr = null;
        Object value = attr.getValue();
        if (value instanceof String) {
            Class attrClass = this.getAttributeClass(objectName, attr.getName());
            if (attrClass == null) {
                String msg = DottedNameStrings.getString("AttributeNotFound", attr.getName());
                throw new AttributeNotFoundException(attr.getName());
            }
            value = this.coerceToClass(attrClass, (String)value);
            actualAttr = new Attribute(attr.getName(), value);
        } else {
            actualAttr = attr;
        }
        this.getMBS().setAttribute(objectName, actualAttr);
        return actualAttr;
    }
}

