/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.j2ee;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Extra;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.ServersConfig;
import com.sun.appserv.management.j2ee.J2EEManagedObject;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;
import org.glassfish.admin.amx.mbean.Delegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class J2EEManagedObjectImplBase
extends AMXNonConfigImplBase {
    protected long mStartTime;
    private static final Map<String, String> ToConfigMap = MapUtil.newMap((String[])new String[]{"J2EEDomain", "X-DomainConfig", "X-J2EECluster", "X-ClusterConfig", "J2EEServer", "X-StandaloneServerConfig", "JVM", "X-JavaConfig", "J2EEApplication", "X-J2EEApplicationConfig", "EJBModule", "X-EJBModuleConfig", "WebModule", "X-WebModuleConfig", "AppClientModule", "X-AppClientModuleConfig", "JavaMailResource", "X-MailResourceConfig", "JDBCResource", "X-JDBCResourceConfig", "JNDIResource", "X-JNDIResourceConfig", "WebServiceEndpoint", "X-WebServiceEndpointConfig"});
    private static final Map<String, String> MON_MAP = Collections.unmodifiableMap(MapUtil.newMap((String[])new String[]{"J2EEServer", "X-ServerRootMonitor", "J2EEApplication", "X-ApplicationMonitor", "WebModule", "X-WebModuleVirtualServerMonitor", "Servlet", "X-ServletMonitor", "EJBModule", "X-EJBModuleMonitor", "StatelessSessionBean", "X-StatelessSessionBeanMonitor", "StatefulSessionBean", "X-StatefulSessionBeanMonitor", "EntityBean", "X-EntityBeanMonitor", "MessageDrivenBean", "X-MessageDrivenBeanMonitor"}));
    private static final Set<String> DEPLOYED_TYPES = GSetUtil.newUnmodifiableStringSet((String[])new String[]{"J2EEApplication", "WebModule", "EJBModule", "AppClientModule", "ResourceAdapterModule"});

    public J2EEManagedObjectImplBase(String j2eeType, String fullType, ObjectName parentObjectName, Class<? extends J2EEManagedObject> theInterface, Delegate delegate) {
        super(j2eeType, fullType, parentObjectName, theInterface, delegate);
    }

    @Override
    public void preRegisterDone() throws Exception {
        super.preRegisterDone();
        this.mStartTime = System.currentTimeMillis();
    }

    protected final void setstartTime(long startTime) {
        this.mStartTime = startTime;
    }

    public long getstartTime() {
        return this.mStartTime;
    }

    protected String getServerName() {
        return this.getObjectName().getKeyProperty("J2EEServer");
    }

    protected String getServerXType() {
        String type = null;
        String serverName = this.getServerName();
        if (serverName != null) {
            ServersConfig sc = this.getDomainRoot().getDomainConfig().getServersConfig();
            HashMap all = new HashMap();
            all.putAll(sc.getStandaloneServerConfigMap());
            all.putAll(sc.getClusteredServerConfigMap());
            ServerConfig serverConfig = (ServerConfig)all.get(serverName);
            type = serverConfig.getJ2EEType();
        }
        return type;
    }

    protected String getConfigPeerJ2EEType() {
        String configPeerJ2EEType = ToConfigMap.get(this.getSelfJ2EEType());
        return configPeerJ2EEType;
    }

    protected String getMonitoringPeerJ2EEType() {
        String monPeerJ2EEType = MON_MAP.get(this.getSelfJ2EEType());
        return monPeerJ2EEType;
    }

    protected Map<String, String> getMonitoringPeerProps(String monitorJ2EEType, String monitorName) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("j2eeType", monitorJ2EEType);
        props.put("name", monitorName);
        for (String j2eeType : MON_MAP.keySet()) {
            String j2eeMonType = MON_MAP.get(j2eeType);
            String name = this.getKeyProperty(j2eeType);
            if (name == null) continue;
            props.put(j2eeMonType, name);
        }
        return props;
    }

    protected Map<String, String> getMonitoringPeerProps() {
        Map<String, String> props = null;
        String j2eeType = this.getMonitoringPeerJ2EEType();
        if (j2eeType != null) {
            props = this.getMonitoringPeerProps(j2eeType, this.getMonitoringPeerName());
        }
        return props;
    }

    protected ObjectName queryProps(Map<String, String> propsMap) {
        ObjectName objectName = null;
        String props = MapUtil.toString(propsMap, (String)",");
        Set candidates = this.getQueryMgr().queryPropsObjectNameSet(props);
        if (candidates.size() == 1) {
            objectName = (ObjectName)GSetUtil.getSingleton((Set)candidates);
        } else if (candidates.size() > 1) {
            throw new RuntimeException("Unexpectedly found too many candidates for query pattern " + J2EEManagedObjectImplBase.quote(props) + " found: " + J2EEManagedObjectImplBase.toString(candidates));
        }
        return objectName;
    }

    public ObjectName getMonitoringPeerObjectName() {
        ObjectName objectName = null;
        Map<String, String> propsMap = this.getMonitoringPeerProps();
        if (propsMap != null && propsMap.keySet().size() != 0) {
            this.debug("getMonitoringPeerObjectName: my ObjectName = ", this.getObjectName(), ", queryProps = ", MapUtil.toString(propsMap, (String)", "));
            objectName = this.queryProps(propsMap);
            if (objectName == null) {
                objectName = this.queryMonitoringPeerFailed(propsMap);
            }
        }
        return objectName;
    }

    protected ObjectName queryMonitoringPeerFailed(Map<String, String> propsMap) {
        return null;
    }

    protected ObjectName queryConfigPeerFailed(Map<String, String> propsMap) {
        this.debug((Object)("queryConfigPeerFailed: " + MapUtil.toString(propsMap)));
        return null;
    }

    public final String getobjectName() {
        return this.getObjectName().toString();
    }

    public boolean isstatisticProvider() {
        return this.getMonitoringPeerObjectName() != null;
    }

    public boolean isstatisticsProvider() {
        return this.isstatisticProvider();
    }

    protected Stats getStatsGeneric() {
        ObjectName mon;
        Stats stats = null;
        if (this.isstatisticProvider() && (mon = this.getMonitoringPeerObjectName()) != null) {
            AMX monStats = this.getProxyFactory().getProxy(mon, AMX.class);
            try {
                Extra extra = Util.getExtra((AMX)monStats);
                stats = (Stats)extra.getAttribute("stats");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return stats;
    }

    @Override
    public final String getGroup() {
        return "jsr77";
    }

    protected String getConfigPeerName() {
        return this.getSelfName();
    }

    protected String getMonitoringPeerName() {
        return this.getSelfName();
    }

    protected Map<String, String> getConfigPeerProps() {
        HashMap<String, String> props = null;
        String j2eeType = this.getConfigPeerJ2EEType();
        if (j2eeType != null) {
            props = new HashMap<String, String>();
            props.put("j2eeType", j2eeType);
            props.put("name", this.getConfigPeerName());
        }
        return props;
    }

    public ObjectName getConfigPeerObjectName() {
        Map<String, String> propsMap;
        ObjectName configPeerObjectName = null;
        if (this.isConfigProvider() && (propsMap = this.getConfigPeerProps()) != null && (configPeerObjectName = this.queryProps(propsMap)) == null) {
            configPeerObjectName = this.queryConfigPeerFailed(propsMap);
        }
        return configPeerObjectName;
    }

    public boolean isConfigProvider() {
        return ToConfigMap.keySet().contains(this.getSelfJ2EEType());
    }

    public boolean iseventProvider() {
        return false;
    }

    public boolean isstateManageable() {
        return false;
    }

    protected final String[] getContaineeObjectNameStrings(String j2eeType) {
        Set<ObjectName> objectNames = this.getContaineeObjectNameSet(j2eeType);
        String[] names = GSetUtil.toStringArray(objectNames);
        return names;
    }

    public J2EEServer getJ2EEServer() {
        return (J2EEServer)this.getProxyFactory().getProxy(this.getServerObjectName(), J2EEServer.class);
    }

    public ObjectName getServerObjectName() {
        ObjectName selfObjectName = this.getObjectName();
        ObjectName serverObjectName = null;
        String serverName = selfObjectName.getKeyProperty("J2EEServer");
        if (serverName != null) {
            String props = Util.makeRequiredProps((String)"J2EEServer", (String)serverName);
            Set candidates = this.getQueryMgr().queryPatternSet(selfObjectName.getDomain(), props);
            serverObjectName = Util.getObjectName((AMX)((AMX)GSetUtil.getSingleton((Set)candidates)));
        }
        return serverObjectName;
    }

    public Set<ObjectName> getDeployedObjectsObjectNameSet() {
        return this.getContaineeObjectNameSet(DEPLOYED_TYPES);
    }

    public String[] getdeployedObjects() {
        String[] names = GSetUtil.toStringArray(this.getDeployedObjectsObjectNameSet());
        return names;
    }

    protected Set<String> getDontMapAttributeNames() {
        return Collections.emptySet();
    }

    protected Set<String> getFauxChildTypes() {
        HashSet<String> fauxTypes = new HashSet<String>();
        return fauxTypes;
    }

    protected Set<ObjectName> getFauxContaineeObjectNameSet(String childJ2EEType, String nullProps) {
        assert (this.getFauxChildTypes().contains(childJ2EEType));
        String selfProp = Util.makeProp((String)this.getJ2EEType(), (String)this.getSelfName());
        String childJ2EETypeProp = Util.makeJ2EETypeProp((String)childJ2EEType);
        String props = Util.concatenateProps((String)selfProp, (String)nullProps, (String)childJ2EETypeProp);
        Set candidates = this.getQueryMgr().queryPropsSet(props);
        Set objectNames = Util.toObjectNames((Set)candidates);
        return objectNames;
    }
}

