/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.loader;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.TimingDelta;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.amx.config.AMXConfigRegistrar;
import org.glassfish.admin.amx.loader.AMXStartupServiceMBean;
import org.glassfish.admin.amx.loader.StartAMX;
import org.glassfish.admin.amx.util.SingletonEnforcer;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

@Service
@Async
public final class AMXStartupService
implements Startup,
PostConstruct,
PreDestroy,
AMXStartupServiceMBean {
    @Inject(name="Official_MBeanServer")
    private MBeanServer mMBeanServer;
    @Inject
    private AMXConfigRegistrar mConfigRegistrar;
    private static final ObjectName OBJECT_NAME = JMXUtil.newObjectName((String)"amx-support:name=startup");

    private static void debug(String s) {
        System.out.println(s);
    }

    public void postConstruct() {
        SingletonEnforcer.register(this.getClass(), this);
        TimingDelta delta = new TimingDelta();
        if (this.mMBeanServer == null) {
            throw new Error("AMXStartup: null MBeanServer");
        }
        if (this.mConfigRegistrar == null) {
            throw new Error("AMXStartup: null AMXConfigRegistrar");
        }
        try {
            this.mMBeanServer.registerMBean(this, OBJECT_NAME);
        }
        catch (JMException e) {
            throw new Error(e);
        }
        StartAMX.init(this.mMBeanServer, this.mConfigRegistrar);
        StartAMX.getInstance();
        StartAMX.startConnectors();
    }

    public void preDestroy() {
        StartAMX.stopAMX();
    }

    public synchronized ObjectName getDomainRootObjectName() {
        try {
            return Util.getExtra((AMX)ProxyFactory.getInstance((MBeanServer)this.mMBeanServer).getDomainRoot()).getObjectName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public JMXServiceURL getJMXServiceURL() {
        return StartAMX.getInstance().getJMXServiceURL();
    }

    public static AMXStartupServiceMBean getAMXStartupServiceMBean(MBeanServer mbs) {
        AMXStartupServiceMBean ss = null;
        if (mbs.isRegistered(OBJECT_NAME)) {
            ss = MBeanServerInvocationHandler.newProxyInstance(mbs, OBJECT_NAME, AMXStartupServiceMBean.class, false);
        }
        return ss;
    }

    public static ObjectName invokeStartAMX(MBeanServer mbs) {
        return AMXStartupService.getAMXStartupServiceMBean(mbs).startAMX();
    }

    public synchronized ObjectName startAMX() {
        TimingDelta delta = new TimingDelta();
        StartAMX.getInstance();
        StartAMX.startAMX();
        DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServer)this.mMBeanServer).getDomainRoot();
        domainRoot.waitAMXReady();
        AMXStartupService.debug("AMXStartupService: Loaded AMX MBeans in " + delta.elapsedMillis() + " ms ");
        return this.getDomainRootObjectName();
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }
}

