/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.loader;

import com.sun.appserv.management.util.jmx.JMXUtil;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.ObjectName;
import org.glassfish.admin.amx.loader.LoaderBase;
import org.glassfish.admin.amx.mbean.DomainRootImpl;
import org.glassfish.admin.amx.util.FeatureAvailability;

public final class Loader
extends LoaderBase {
    private static final long WAIT_THRESHOLD_MILLIS = 5000L;
    private static final boolean WAIT_FOR_REGISTRATION = false;

    protected void preRegisterHook() {
    }

    protected final void postRegisterHook(Boolean registrationSucceeded) {
        super.postRegisterHook(registrationSucceeded);
        if (registrationSucceeded.booleanValue()) {
            FeatureAvailability.getInstance().registerFeature("AMXLoader", this.getObjectName());
        }
    }

    public void handleNotification(Notification notifIn, Object handback) {
        String type = notifIn.getType();
        if (notifIn instanceof MBeanServerNotification) {
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            ObjectName objectName = notif.getMBeanName();
            if (type == "JMX.mbean.registered") {
                if (JMXUtil.toString((ObjectName)objectName).equals("amx:j2eeType=J2EEServer,name=server")) {
                    this.debug((Object)("Loader.handleNotification:  REGISTER for: " + JMXUtil.toString((ObjectName)objectName)));
                }
            } else if (type == "JMX.mbean.unregistered") {
                // empty if block
            }
        }
    }

    public void handleMBeanRegistered(ObjectName oldObjectName) throws InstanceNotFoundException {
        this.trace("handleMBeanRegistered: " + oldObjectName);
    }

    public void handleMBeanUnregistered(ObjectName oldObjectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.trace("handleMBeanUnregistered: " + oldObjectName);
    }

    protected void startHook() {
        super.startHook();
    }

    public boolean isStarted() {
        return super.isStarted();
    }

    public final void waitAll() {
    }

    protected Object createDomainRoot() {
        return new DomainRootImpl();
    }

    public boolean isDAS() {
        return true;
    }
}

