/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.loader;

import com.sun.appserv.management.util.misc.ExceptionUtil;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.glassfish.admin.amx.loader.LoaderRegHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LoaderRegThread
extends Thread {
    private volatile boolean mQuit;
    private final ArrayBlockingQueue<QueueItem> mQueue;
    private final Logger mLogger;
    private final LoaderRegHandler mRegHandler;
    private volatile QueueItem mInProgress = null;

    public LoaderRegThread(LoaderRegHandler regHandler, Logger logger) {
        this.mRegHandler = regHandler;
        this.mLogger = logger;
        this.mQuit = false;
        int maxElements = 512;
        this.mQueue = new ArrayBlockingQueue(512);
    }

    private final Logger getLogger() {
        return this.mLogger;
    }

    private final void trace(Object o) {
        if (this.mLogger != null) {
            this.mLogger.finer(o.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        this.mQuit = true;
        LoaderRegThread loaderRegThread = this;
        synchronized (loaderRegThread) {
            this.notify();
        }
    }

    public void enqueue(boolean register, List<ObjectName> candidates) {
        for (ObjectName objectName : candidates) {
            this.enqueue(register, objectName);
        }
    }

    public void enqueue(boolean register, ObjectName theObject) {
        try {
            this.mQueue.put(new QueueItem(theObject, register));
        }
        catch (InterruptedException e) {
            this.mQuit = true;
        }
    }

    @Override
    public void run() {
        this.mQuit = false;
        while (!this.mQuit) {
            try {
                this.process();
            }
            catch (InterruptedException e) {
                this.mQuit = true;
            }
        }
    }

    protected boolean mySleep(long millis) {
        boolean interrupted = false;
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            interrupted = true;
        }
        return interrupted;
    }

    public void waitAll() {
        while (this.mQueue.size() != 0 || this.mInProgress != null) {
            this.mySleep(100L);
        }
    }

    private void processRegistration(ObjectName objectName) {
        try {
            this.mRegHandler.handleMBeanRegistered(objectName);
            this.getLogger().finer("LoaderRegThread.processRegistration: processed mbean: " + objectName);
        }
        catch (Throwable t) {
            this.getLogger().warning("LoaderRegThread.processRegistration: registration of MBean failed for: " + objectName + " = " + t.toString() + ", " + t.getMessage() + "\n" + ExceptionUtil.getStackTrace((Throwable)t));
        }
    }

    private void processUnregistration(ObjectName objectName) {
        try {
            this.mRegHandler.handleMBeanUnregistered(objectName);
        }
        catch (Throwable t) {
            this.getLogger().warning("LoaderRegThread.processUnregistration: unregistration of MBean failed for: " + objectName + " = " + t.toString());
        }
    }

    public boolean isQueueEmpty() {
        return this.mQueue.size() == 0;
    }

    private void process() throws InterruptedException {
        while (!this.mQuit) {
            this.mInProgress = this.mQueue.take();
            if (this.mInProgress == null) {
                this.mQuit = true;
            }
            if (this.mInProgress.mRegister) {
                this.processRegistration(this.mInProgress.mObjectName);
            } else {
                this.processUnregistration(this.mInProgress.mObjectName);
            }
            this.mInProgress = null;
        }
    }

    private static final class QueueItem {
        public final ObjectName mObjectName;
        public final boolean mRegister;

        QueueItem(ObjectName item, boolean register) {
            this.mObjectName = item;
            this.mRegister = register;
        }
    }
}

