/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.loader;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.v3.server.Globals;
import java.io.IOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.amx.config.AMXConfigRegistrar;
import org.glassfish.admin.amx.loader.J2EELoader;
import org.glassfish.admin.amx.loader.LoadAMX;

final class StartAMX {
    private static StartAMX INSTANCE;
    private volatile ObjectName mAMXLoaderObjectName;
    private final AMXConfigRegistrar mConfigRegistrar;
    private final MBeanServer mMBeanServer;
    private final J2EELoader mJ2EELoader;
    private volatile JMXConnectorServer mJMXMP = null;
    private volatile JMXServiceURL mJMXMPServiceURL = null;
    private volatile ObjectName mJMXMPObjectName = null;
    public static final int JMXMP_PORT = 8888;
    private static volatile boolean STARTED;
    private static boolean START_CONNECTOR;

    protected static void debug(String s) {
        System.out.println(s);
    }

    public JMXServiceURL getJMXServiceURL() {
        return this.mJMXMPServiceURL;
    }

    private StartAMX(MBeanServer mbs, AMXConfigRegistrar registrar) {
        this.mMBeanServer = mbs;
        this.mConfigRegistrar = registrar;
        this.mJ2EELoader = new J2EELoader(mbs);
    }

    public static synchronized StartAMX init(MBeanServer mbs, AMXConfigRegistrar registrar) {
        INSTANCE = new StartAMX(mbs, registrar);
        return INSTANCE;
    }

    public static synchronized StartAMX getInstance() {
        return INSTANCE;
    }

    public static boolean isStarted() {
        return StartAMX.getInstance() != null;
    }

    private synchronized void loadMBeans() {
        this.mAMXLoaderObjectName = LoadAMX.loadAMX(this.mMBeanServer);
        this.mJ2EELoader.start();
        this.mConfigRegistrar.getAMXConfigLoader().start(this.mMBeanServer);
    }

    public static synchronized void startConnectors() {
        int TRY_COUNT = 100;
        int port = 8888;
        int tryCount = 0;
        while (tryCount < 100) {
            try {
                JMXConnectorServer cs = StartAMX.getInstance().startJMXMPConnectorServer(port);
                break;
            }
            catch (BindException e) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (port < 1000) {
                port += 1000;
                continue;
            }
            ++port;
        }
    }

    public static synchronized void startAMX() {
        if (!STARTED) {
            StartAMX.startConnectors();
            StartAMX.getInstance().loadMBeans();
            STARTED = true;
        }
    }

    public static synchronized void stopAMX() {
        if (INSTANCE != null && StartAMX.INSTANCE.mJMXMP != null) {
            try {
                StartAMX.INSTANCE.mJMXMP.stop();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized JMXConnectorServer startJMXMPConnectorServer(int port) throws MalformedURLException, IOException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this.mJMXMPObjectName == null) {
            ModulesRegistry registry = (ModulesRegistry)Globals.getDefaultHabitat().getByType(ModulesRegistry.class);
            Module jmxmpConnector = registry.makeModuleFor("org.glassfish.external:jmxremote_optional-repackaged", null);
            if (jmxmpConnector == null) {
                return null;
            }
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("jmx.remote.protocol.provider.pkgs", "com.sun.jmx.remote.protocol");
            env.put("jmx.remote.protocol.provider.class.loader", jmxmpConnector.getClassLoader());
            JMXServiceURL serviceURL = new JMXServiceURL("service:jmx:jmxmp://localhost:" + port);
            JMXConnectorServer jmxmp = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, env, this.mMBeanServer);
            ObjectName objectName = JMXUtil.newObjectName((String)("jmxremote:type=jmx-connector,name=jmxmp,port=" + port));
            objectName = this.mMBeanServer.registerMBean(jmxmp, objectName).getObjectName();
            boolean startedOK = false;
            try {
                jmxmp.start();
                startedOK = true;
            }
            finally {
                if (!startedOK) {
                    try {
                        jmxmp.stop();
                    }
                    catch (Exception e) {}
                    try {
                        this.mMBeanServer.unregisterMBean(objectName);
                        objectName = null;
                    }
                    catch (Exception e) {}
                }
            }
            this.mJMXMPServiceURL = serviceURL;
            this.mJMXMP = jmxmp;
            this.mJMXMPObjectName = objectName;
            System.out.println("JMXMP connector server URL = " + this.mJMXMPServiceURL);
        }
        return this.mJMXMP;
    }

    static {
        STARTED = false;
        START_CONNECTOR = false;
    }
}

