/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.monitor;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.util.misc.ClassUtil;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.Monitor;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;
import org.glassfish.admin.amx.mbean.Delegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXMonitorBase
extends AMXNonConfigImplBase {
    final Monitor mMonitor;

    protected JMXMonitorBase(Monitor mon, String j2eeType, String fullType, ObjectName parentObjectName, Class<? extends AMX> theInterface, Delegate delegate) {
        super(j2eeType, fullType, parentObjectName, theInterface, delegate);
        this.mMonitor = mon;
    }

    @Override
    public String getGroup() {
        return "utility";
    }

    @Override
    protected Object getAttributeManually(String name) throws AttributeNotFoundException {
        MBeanAttributeInfo attrInfo = this.getAttributeInfos().get(name);
        assert (attrInfo != null);
        String prefix = attrInfo.isIs() ? "is" : "get";
        String operationName = prefix + name;
        Object result = null;
        try {
            result = this.invokeManually(operationName, null, null);
        }
        catch (Exception e) {
            throw new AttributeNotFoundException(name);
        }
        return result;
    }

    @Override
    protected void setAttributeManually(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        String operationName = "set" + attr.getName();
        MBeanAttributeInfo attrInfo = this.getAttributeInfos().get(attr.getName());
        Object result = null;
        try {
            Object value = attr.getValue();
            Class theClass = ClassUtil.getClassFromName((String)attrInfo.getType());
            result = this.invokeSig(operationName, new Object[]{value}, new Class[]{theClass});
            assert (result == null);
        }
        catch (Exception e) {
            throw new AttributeNotFoundException(attr.getName());
        }
    }

    private Object invokeSig(String operationName, Object[] args, Class[] sig) throws MBeanException, ReflectionException, NoSuchMethodException {
        Object result = null;
        try {
            Method m = this.mMonitor.getClass().getMethod(operationName, sig);
            result = m.invoke((Object)this.mMonitor, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    protected Object invokeManually(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException, NoSuchMethodException {
        Object result = null;
        try {
            Class[] sig = ClassUtil.signatureFromClassnames((String[])types);
            result = this.invokeSig(operationName, args, sig);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    protected void preRegisterDone() throws Exception {
        ObjectName x = this.mMonitor.preRegister(this.getMBeanServer(), this.getObjectName());
    }

    @Override
    protected void postRegisterHook(Boolean registrationSucceeded) {
        super.postRegisterHook(registrationSucceeded);
        this.mMonitor.postRegister(registrationSucceeded);
    }

    @Override
    protected void preDeregisterHook() throws Exception {
        super.preDeregisterHook();
        try {
            this.mMonitor.preDeregister();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void postDeregisterHook() {
        super.postDeregisterHook();
        this.mMonitor.postDeregister();
    }
}

