/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.SystemPropertiesAccess;
import org.glassfish.api.amx.AMXConfigInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AMXConfigInfoResolver {
    private final AMXConfigInfo mAMXConfigInfo;

    private static void debug(String s) {
        System.out.println(s);
    }

    public AMXConfigInfoResolver(AMXConfigInfo info) {
        this.mAMXConfigInfo = info;
    }

    public Class<? extends AMXConfig> amxInterface() {
        String classname = this.mAMXConfigInfo.amxInterfaceName();
        Class<AMXConfig> theInterface = null;
        Class<?> theClass = null;
        try {
            theClass = Class.forName(classname);
        }
        catch (Exception e) {
            AMXConfigInfoResolver.debug("Can't find class for " + classname);
        }
        if (theClass != null) {
            theInterface = theClass.asSubclass(AMXConfig.class);
        }
        return theInterface;
    }

    public boolean supportsProperties() {
        Class<? extends AMXConfig> intf = this.amxInterface();
        return PropertiesAccess.class.isAssignableFrom(intf);
    }

    public boolean supportsSystemProperties() {
        Class<? extends AMXConfig> intf = this.amxInterface();
        return SystemPropertiesAccess.class.isAssignableFrom(intf);
    }

    public String j2eeType() {
        return Util.getJ2EEType(this.amxInterface());
    }

    public AMXConfigInfo getAMXConfigInfo() {
        return this.mAMXConfigInfo;
    }

    public String nameHint() {
        return this.mAMXConfigInfo.nameHint();
    }

    public boolean singleton() {
        return this.mAMXConfigInfo.singleton();
    }

    public boolean omitAsAncestorInChildObjectName() {
        return this.mAMXConfigInfo.omitAsAncestorInChildObjectName();
    }
}

