/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import com.sun.appserv.management.util.misc.ExceptionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;

public final class FeatureAvailability {
    private static final FeatureAvailability INSTANCE = new FeatureAvailability();
    private final Map<String, Object> mFeatures = new HashMap<String, Object>();
    private final Map<String, CountDownLatch> mLatches = new HashMap<String, CountDownLatch>();
    public static final String ADMIN_CONTEXT_FEATURE = "AdminContext";
    public static final String MBEAN_SERVER_FEATURE = "MBeanServer";
    public static final String SUN_ONE_INTERCEPTOR_FEATURE = "SunoneInterceptor";
    public static final String COM_SUN_APPSERV_CONFIG_MBEANS_FEATURE = "com.sun.appserv:category=config";
    public static final String AMX_LOADER_FEATURE = "AMXLoader";
    public static final String AMX_BOOT_UTIL_FEATURE = "AMXBootUtil";
    public static final String AMX_READY_FEATURE = "AMXReady";
    public static final String CALL_FLOW_FEATURE = "CallFlow";
    public static final String SERVER_STARTED_FEATURE = "ServerStarted";
    private static final boolean DEBUG_ENABLED = false;

    private FeatureAvailability() {
    }

    public static FeatureAvailability getInstance() {
        return INSTANCE;
    }

    private void debug(Object ... args) {
    }

    public MBeanServer getMBeanServer() {
        return (MBeanServer)this.mFeatures.get(MBEAN_SERVER_FEATURE);
    }

    public MBeanServer waitForMBeanServer() {
        MBeanServer server = this.getMBeanServer();
        if (server == null) {
            server = (MBeanServer)this.waitForFeature(MBEAN_SERVER_FEATURE, "waitForMBeanServer from " + ExceptionUtil.getStackTrace());
        }
        return server;
    }

    public synchronized void registerFeature(String featureName, Object data) {
        if (this.mFeatures.get(featureName) != null) {
            this.debug("addFeature: already added: " + featureName);
            throw new IllegalStateException();
        }
        if (data == null) {
            System.out.println("addFeature: data is null for: " + featureName);
            throw new IllegalArgumentException();
        }
        this.mFeatures.put(featureName, data);
        this.debug("********** FeatureAvailability.addFeature: " + featureName + ", data = " + data + "**********");
        if (this.mLatches.containsKey(featureName)) {
            CountDownLatch latch = this.mLatches.remove(featureName);
            latch.countDown();
            this.debug("addFeature: released latch for: " + featureName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForFeature(String featureName, String callerInfo) {
        CountDownLatch latch = null;
        Object data = null;
        FeatureAvailability featureAvailability = this;
        synchronized (featureAvailability) {
            data = this.mFeatures.get(featureName);
            if (data == null && (latch = this.mLatches.get(featureName)) == null) {
                latch = new CountDownLatch(1);
                this.mLatches.put(featureName, latch);
            }
        }
        assert (data == null && latch != null || data != null && latch == null);
        if (latch != null) {
            long start = System.currentTimeMillis();
            try {
                this.debug("waitForFeature: \"" + featureName + "\" by " + callerInfo);
                long startNanos = System.nanoTime();
                latch.await();
                long elapsedNanos = System.nanoTime() - startNanos;
                if (elapsedNanos > 1000000L) {
                    this.debug("FeatureAvailability.waitForFeature: waited ", "" + elapsedNanos, " for feature \"", featureName, "\" by \"", callerInfo, "\"");
                }
            }
            catch (InterruptedException e) {
                this.debug("waitForFeature: ERROR: ", e);
                throw new Error(e);
            }
            data = this.mFeatures.get(featureName);
        }
        return data;
    }
}

