/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server.util;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.util.FileUtil;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.web.WebDeployer;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASClassLoaderUtil {
    private static final Logger _logger = Logger.getAnonymousLogger();
    private static String sharedClasspathForWebModule = null;
    private static final String USE_NEW_CLASSLOADER_PROPERTY = "com.sun.aas.useNewClassLoader";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWebModuleClassPath(Habitat habitat, String moduleId, boolean delegate) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ASClassLoaderUtil.getWebModuleClassPath for module Id : " + moduleId);
        }
        Class<ASClassLoaderUtil> clazz = ASClassLoaderUtil.class;
        synchronized (ASClassLoaderUtil.class) {
            if (sharedClasspathForWebModule == null) {
                StringBuilder tmpString = new StringBuilder();
                if (Boolean.getBoolean(USE_NEW_CLASSLOADER_PROPERTY)) {
                    ArrayList<String> tmpList = new ArrayList<String>();
                    tmpList.addAll(ASClassLoaderUtil.getSharedClasspath());
                    tmpList.addAll(ASClassLoaderUtil.getAddOnsClasspath());
                    for (String s : tmpList) {
                        tmpString.append(s);
                        tmpString.append(File.pathSeparatorChar);
                    }
                } else {
                    tmpString.append(FileUtil.getAbsolutePath((String)System.getProperty("java.class.path")));
                    tmpString.append(File.pathSeparatorChar);
                }
                WebDeployer webDeployer = (WebDeployer)((Object)habitat.getComponent(WebDeployer.class));
                ModuleDefinition[] moduleDefs = webDeployer.getMetaData().getPublicAPIs();
                if (moduleDefs != null) {
                    for (ModuleDefinition moduleDef : moduleDefs) {
                        URI[] uris;
                        for (URI uri : uris = moduleDef.getLocations()) {
                            tmpString.append(uri.getPath());
                            tmpString.append(File.pathSeparator);
                        }
                    }
                }
                sharedClasspathForWebModule = tmpString.toString();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            StringBuilder classpath = new StringBuilder(sharedClasspathForWebModule);
            if (delegate) {
                ASClassLoaderUtil.addLibrariesFromLibs(classpath, habitat);
                ASClassLoaderUtil.addLibrariesForWebModule(classpath, habitat, moduleId);
            } else {
                ASClassLoaderUtil.addLibrariesForWebModule(classpath, habitat, moduleId);
                ASClassLoaderUtil.addLibrariesFromLibs(classpath, habitat);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Final classpath: " + classpath.toString());
            }
            return classpath.toString();
        }
    }

    private static void addLibrariesForWebModule(StringBuilder sb, Habitat habitat, String moduleId) {
        String specifiedLibraries;
        URL[] libs;
        if (moduleId != null && (libs = ASClassLoaderUtil.getLibraries(specifiedLibraries = ASClassLoaderUtil.getLibrariesForWebModule(habitat, moduleId))) != null) {
            for (URL u : libs) {
                sb.append(u);
                sb.append(File.pathSeparator);
            }
        }
    }

    private static void addLibrariesFromLibs(StringBuilder sb, Habitat habitat) {
        URLClassLoader urlCl;
        URL[] urls;
        ClassLoader cl;
        ModulesRegistry mreg = (ModulesRegistry)habitat.getComponent(ModulesRegistry.class);
        if (mreg != null && (cl = mreg.getParentClassLoader()) instanceof URLClassLoader && (urls = (urlCl = (URLClassLoader)cl).getURLs()) != null) {
            for (URL u : urls) {
                sb.append(u);
                sb.append(File.pathSeparator);
            }
        }
    }

    public static <T> String getLibrariesForModule(Habitat habitat, Class<T> type, String moduleId) {
        Object app = ConfigBeansUtilities.getModule(type, (Applications)ASClassLoaderUtil.getApplications(habitat), (String)moduleId);
        if (app == null) {
            return null;
        }
        String librariesStr = null;
        try {
            Method m = type.getMethod("getLibraries", new Class[0]);
            if (m != null) {
                librariesStr = (String)m.invoke(app, new Object[0]);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "app = " + app + " library = " + librariesStr);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Cannot get libraries for module " + moduleId, e);
        }
        return librariesStr;
    }

    public static String getLibrariesForWebModule(Habitat habitat, String moduleId) {
        WebModule module = (WebModule)ConfigBeansUtilities.getModule(WebModule.class, (Applications)ASClassLoaderUtil.getApplications(habitat), (String)moduleId);
        if (module == null) {
            return null;
        }
        String librariesStr = module.getLibraries();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "moduleId = " + moduleId + " library = " + librariesStr);
        }
        return librariesStr;
    }

    private static Applications getApplications(Habitat habitat) {
        Domain domain = (Domain)habitat.getComponent(Domain.class);
        return domain.getApplications();
    }

    public static URL[] getLibraries(String librariesStr) {
        if (librariesStr == null) {
            return null;
        }
        String[] librariesStrArray = librariesStr.split(",");
        if (librariesStrArray == null) {
            return null;
        }
        URL[] urls = new URL[librariesStrArray.length];
        String appLibsDir = System.getProperty("com.sun.aas.instanceRoot") + File.separator + "lib" + File.separator + "applibs";
        int i = 0;
        for (String libraryStr : librariesStrArray) {
            try {
                File f = new File(libraryStr);
                if (!f.isAbsolute()) {
                    f = new File(appLibsDir, libraryStr);
                }
                URL url = f.toURL();
                urls[i++] = url;
            }
            catch (MalformedURLException malEx) {
                _logger.log(Level.WARNING, "loader.cannot_convert_classpath_into_url", libraryStr);
                _logger.log(Level.WARNING, "loader.exception", malEx);
            }
        }
        return urls;
    }

    public static synchronized ClassLoader getSharedClassLoader() {
        return null;
    }

    public static ClassLoader getSharedChain() {
        return null;
    }

    public static synchronized List<String> getSharedClasspath() {
        return null;
    }

    public static synchronized List<String> getAddOnsClasspath() {
        return null;
    }
}

