/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.common.Result;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.grizzly.tcp.Adapter;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.glassfish.api.deployment.ApplicationContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebApplication
implements ApplicationContainer<WebBundleDescriptor> {
    private static final String ADMIN_VS = "__asadmin";
    final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    final WebContainer container;
    final WebModuleConfig wmInfo;
    final GrizzlyService grizzlyAdapter;

    public WebApplication(WebContainer container, WebModuleConfig config, GrizzlyService grizzlyAdapter) {
        this.container = container;
        this.wmInfo = config;
        this.grizzlyAdapter = grizzlyAdapter;
    }

    public boolean start(ClassLoader cl) {
        this.wmInfo.setAppClassLoader(cl);
        String vsIDs = this.wmInfo.getVirtualServers();
        List vsList = StringUtils.parseStringList((String)vsIDs, (String)" ,");
        return this.start(vsList);
    }

    boolean start(List<String> vsList) {
        String contextRoot = this.wmInfo.getDescriptor().getContextRoot();
        boolean loadToAll = vsList == null || vsList.size() == 0;
        List<Result<WebModule>> results = this.container.loadWebModule(this.wmInfo, "null");
        if (results == null) {
            this.logger.log(Level.SEVERE, "Unknown error, loadWebModule returned null, file a bug");
            return false;
        }
        this.logger.info("Loading application " + this.wmInfo.getDescriptor().getName() + " at " + this.wmInfo.getDescriptor().getContextRoot());
        for (Result<WebModule> result : results) {
            if (result.isSuccess()) {
                VirtualServer vs = (VirtualServer)((WebModule)result.result()).getParent();
                HashSet<String> c = new HashSet<String>();
                c.add(vs.getID());
                if (!loadToAll && !vsList.contains(vs.getName()) && !this.isAliasMatched(vsList, vs)) continue;
                for (int port : vs.getPorts()) {
                    Adapter adapter = this.container.adapterMap.get(port);
                    this.grizzlyAdapter.registerEndpoint(contextRoot, c, adapter, (ApplicationContainer)this);
                }
                continue;
            }
            this.logger.log(Level.SEVERE, "Error while deploying", result.exception());
            return false;
        }
        return true;
    }

    public boolean stop() {
        return this.stop(null);
    }

    boolean stop(List<String> targets) {
        boolean isLeftOver = false;
        boolean unloadFromAll = targets == null || targets.size() == 0;
        String ctxtRoot = this.getDescriptor().getContextRoot();
        Container[] hosts = this.container.engine.findChildren();
        for (int i = 0; i < hosts.length; ++i) {
            StandardContext ctxt;
            StandardHost vs = (StandardHost)hosts[i];
            if (unloadFromAll && ADMIN_VS.equals(vs.getName()) || (ctxt = (StandardContext)vs.findChild(ctxtRoot)) == null) continue;
            if (unloadFromAll || targets.contains(vs.getName()) || this.isAliasMatched(targets, vs)) {
                vs.removeChild(ctxt);
                try {
                    ctxt.destroy();
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Unable to destroy web module " + ctxt, ex);
                }
                this.logger.info("Undeployed web module " + ctxt + " from virtual server " + vs.getName());
                this.grizzlyAdapter.unregisterEndpoint(ctxtRoot, (ApplicationContainer)this);
                continue;
            }
            isLeftOver = true;
        }
        if ((unloadFromAll || !isLeftOver) && this.getClassLoader() instanceof Lifecycle) {
            try {
                ((Lifecycle)this.getClassLoader()).stop();
            }
            catch (LifecycleException le) {
                this.logger.log(Level.WARNING, "Unable to stop classloader for " + this, le);
            }
        }
        return true;
    }

    public ClassLoader getClassLoader() {
        return this.wmInfo.getAppClassLoader();
    }

    WebContainer getContainer() {
        return this.container;
    }

    public WebBundleDescriptor getDescriptor() {
        return this.wmInfo.getDescriptor();
    }

    private boolean isAliasMatched(List targets, StandardHost vs) {
        String[] aliasNames = vs.getAliases();
        for (int i = 0; i < aliasNames.length; ++i) {
            if (!targets.contains(aliasNames[i])) continue;
            return true;
        }
        return false;
    }

    private boolean verifyAlias(List vsList, VirtualServer vs) {
        for (int i = 0; i < vs.getAliases().length; ++i) {
            if (!vsList.contains(vs.getAliases()[i])) continue;
            return true;
        }
        return false;
    }
}

