/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.server.util.ASClassLoaderUtil;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.io.WebDeploymentDescriptorFile;
import com.sun.enterprise.deployment.runtime.web.ClassLoader;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.v3.server.ServerEnvironment;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.web.JSPCompiler;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebDeployer
extends JavaEEDeployer<WebContainer, WebApplication> {
    @Inject
    ServerContext sc;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    GrizzlyService grizzlyAdapter;
    private static final String ADMIN_VS = "__asadmin";
    private static final String DEFAULT_WEB_XML = "default-web.xml";
    private static WebBundleDescriptor defaultWebXMLWbd = null;

    protected String getModuleType() {
        return "web";
    }

    public MetaData getMetaData() {
        String[] otherExportedPackages;
        ArrayList<ModuleDefinition> apis = new ArrayList<ModuleDefinition>();
        Module module = this.modulesRegistry.makeModuleFor("org.glassfish:javax.javaee", null);
        if (module != null) {
            apis.add(module.getModuleDefinition());
        }
        for (String otherExportedPackage : otherExportedPackages = new String[]{"org.glassfish.web:webtier", "org.glassfish.web:jsf-connector", "org.glassfish.web:jstl-impl", "org.glassfish.external:grizzly-module", "org.glassfish.external:grizzly-optionals"}) {
            module = this.modulesRegistry.makeModuleFor(otherExportedPackage, null);
            if (module == null) continue;
            apis.add(module.getModuleDefinition());
        }
        return new MetaData(false, apis.toArray(new ModuleDefinition[apis.size()]), new Class[]{Application.class}, null);
    }

    protected WebBundleDescriptor getDefaultBundleDescriptor() {
        return this.getDefaultWebXMLBundleDescriptor();
    }

    protected Application parseModuleMetaData(DeploymentContext dc) throws Exception {
        Properties params;
        String contextRoot;
        Application app = super.parseModuleMetaData(dc);
        WebBundleDescriptor wbd = null;
        Set webDesc = app.getWebBundleDescriptors();
        Iterator iter = webDesc.iterator();
        if (iter.hasNext()) {
            wbd = (WebBundleDescriptor)iter.next();
        }
        if (!(contextRoot = (params = dc.getCommandParameters()).getProperty("contextroot") != null ? params.getProperty("contextroot") : (wbd.getContextRoot() != null && wbd.getContextRoot().length() > 0 ? wbd.getContextRoot() : params.getProperty("name"))).startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        wbd.setContextRoot(contextRoot);
        wbd.setName(params.getProperty("name"));
        dc.getProps().setProperty("context-root", contextRoot);
        return app;
    }

    private WebModuleConfig loadWebModuleConfig(DeploymentContext dc) {
        WebModuleConfig wmInfo = null;
        try {
            ReadableArchive source = dc.getSource();
            String docBase = source.getURI().getSchemeSpecificPart();
            Properties params = dc.getCommandParameters();
            String virtualServers = params.getProperty("virtualservers");
            wmInfo = new WebModuleConfig();
            WebBundleDescriptor wbd = null;
            Application app = (Application)dc.getModuleMetaData(Application.class);
            Set webDesc = app.getWebBundleDescriptors();
            Iterator iter = webDesc.iterator();
            if (iter.hasNext()) {
                wbd = (WebBundleDescriptor)iter.next();
            }
            wmInfo.setDescriptor(wbd);
            wmInfo.setVirtualServers(virtualServers);
            wmInfo.setLocation(dc.getSourceDir().getAbsolutePath());
            wmInfo.setObjectType(dc.getProps().getProperty("object-type"));
            wmInfo.setWorkDir(dc.getScratchDir("jsp").getAbsolutePath());
        }
        catch (Exception ex) {
            dc.getLogger().log(Level.WARNING, "loadWebModuleConfig", ex);
        }
        return wmInfo;
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        Properties params = dc.getCommandParameters();
        boolean precompileJSP = Boolean.parseBoolean(params.getProperty("precompilejsp"));
        if (precompileJSP) {
            this.runJSPC(dc);
        }
    }

    public WebApplication load(WebContainer container, DeploymentContext dc) {
        WebModuleConfig wmInfo = this.loadWebModuleConfig(dc);
        return new WebApplication(container, wmInfo, this.grizzlyAdapter);
    }

    public void unload(WebApplication webApplication, DeploymentContext dc) {
    }

    public WebBundleDescriptor getDefaultWebXMLBundleDescriptor() {
        this.initDefaultWebXMLBundleDescriptor();
        WebBundleDescriptor defaultWebBundleDesc = new WebBundleDescriptor();
        if (defaultWebXMLWbd != null) {
            defaultWebBundleDesc.addWebBundleDescriptor(defaultWebXMLWbd);
        }
        return defaultWebBundleDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void initDefaultWebXMLBundleDescriptor() {
        block13: {
            FileInputStream fis;
            block12: {
                if (defaultWebXMLWbd != null) {
                    return;
                }
                fis = null;
                String defaultWebXMLPath = this.env.getConfigDirPath() + File.separator + DEFAULT_WEB_XML;
                File file = new File(defaultWebXMLPath);
                if (!file.exists()) break block12;
                fis = new FileInputStream(file);
                WebDeploymentDescriptorFile wddf = new WebDeploymentDescriptorFile();
                wddf.setXMLValidation(false);
                defaultWebXMLWbd = (WebBundleDescriptor)wddf.read((InputStream)fis);
            }
            Object var6_6 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                break block13;
            }
            catch (IOException ioe) {}
            break block13;
            {
                catch (Exception e) {
                    LogDomains.getLogger((String)"javax.enterprise.system.container.web").warning("Error in parsing default-web.xml");
                    Object var6_7 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block13;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    void runJSPC(DeploymentContext dc) throws DeploymentException {
        WebBundleDescriptor wbd = (WebBundleDescriptor)((Application)dc.getModuleMetaData(Application.class)).getStandaloneBundleDescriptor();
        try {
            File outDir = dc.getScratchDir("jsp");
            File inDir = dc.getSourceDir();
            boolean delegate = true;
            ClassLoader clBean = wbd.getSunDescriptor().getClassLoader();
            if (clBean != null) {
                String value = clBean.getAttributeValue("Delegate");
                delegate = ConfigBeansUtilities.toBoolean((String)value);
            }
            StringBuffer classpath = new StringBuffer();
            classpath.append(super.getCommonClassPath());
            classpath.append(File.pathSeparatorChar);
            classpath.append(ASClassLoaderUtil.getWebModuleClassPath(this.sc.getDefaultHabitat(), wbd.getApplication().getName(), delegate));
            JSPCompiler.compile(inDir, outDir, wbd, classpath.toString(), this.sc);
        }
        catch (DeploymentException de) {
            dc.getLogger().log(Level.SEVERE, "Error compiling JSP", de);
            throw de;
        }
    }
}

