/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.server.util.ASClassLoaderUtil;
import com.sun.appserv.web.cache.CacheManager;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.util.WebBundleVisitor;
import com.sun.enterprise.deployment.util.WebValidatorWithCL;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.web.CacheModule;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.jsp.ResourceInjectorImpl;
import com.sun.logging.LogDomains;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;
import org.glassfish.api.web.TldProvider;

final class WebModuleListener
implements LifecycleListener {
    private static Logger _logger;
    private static boolean _debugLog;
    private static final String JSF_HABITAT_ATTRIBUTE = "com.sun.appserv.jsf.habitat";
    private WebBundleDescriptor wbd;
    private String explodedLocation;
    private ServerContext serverContext;

    public WebModuleListener(ServerContext serverContext, String explodedLocation, WebBundleDescriptor wbd) {
        this.serverContext = serverContext;
        this.wbd = wbd;
        this.explodedLocation = explodedLocation;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        WebModule webModule;
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
            _debugLog = _logger.isLoggable(Level.FINE);
        }
        try {
            webModule = (WebModule)event.getLifecycle();
        }
        catch (ClassCastException e) {
            _logger.log(Level.WARNING, "webmodule.listener.classcastException", event.getLifecycle());
            return;
        }
        if (event.getType().equals("start")) {
            if (this.wbd != null && this.wbd.getApplication() != null && this.wbd.getApplication().isVirtual()) {
                this.wbd.setClassLoader(webModule.getLoader().getClassLoader());
                this.wbd.visit((WebBundleVisitor)new WebValidatorWithCL());
            }
            this.configureDefaultServlet(webModule);
            this.configureJspParameters(webModule);
            this.startCacheManager(webModule);
        } else if (event.getType().equals("stop")) {
            this.stopCacheManager(webModule);
        }
    }

    private void configureJspParameters(WebModule webModule) {
        Collection tldProviders = this.serverContext.getDefaultHabitat().getAllByContract(TldProvider.class);
        ArrayList<URL> tldURLs = new ArrayList<URL>();
        for (TldProvider tldProvider : tldProviders) {
            URL[] urls = tldProvider.getTldURLs();
            if (urls == null || urls.length <= 0) continue;
            for (URL url : urls) {
                tldURLs.add(url);
            }
        }
        webModule.getServletContext().setAttribute("com.sun.appserv.tld.urls", tldURLs);
        webModule.getServletContext().setAttribute(JSF_HABITAT_ATTRIBUTE, (Object)this.serverContext.getDefaultHabitat());
        SunWebApp bean = webModule.getIasWebAppConfigBean();
        String name = webModule.findServletMapping("*.jsp");
        Wrapper wrapper = (Wrapper)webModule.findChild(name);
        if (wrapper == null) {
            return;
        }
        String servletClass = wrapper.getServletClass();
        if (servletClass != null && servletClass.equals("org.apache.jasper.servlet.JspServlet")) {
            if (webModule.getTldValidation()) {
                wrapper.addInitParameter("enableTldValidation", "true");
            }
            if (bean != null && bean.getJspConfig() != null) {
                WebProperty[] props = bean.getJspConfig().getWebProperty();
                for (int i = 0; i < props.length; ++i) {
                    String pname = props[i].getAttributeValue("name");
                    String pvalue = props[i].getAttributeValue("value");
                    if (_debugLog) {
                        _logger.fine("jsp-config property for [" + webModule.getID() + "] is [" + pname + "] = [" + pvalue + "]");
                    }
                    wrapper.addInitParameter(pname, pvalue);
                }
            }
            wrapper.addInitParameter("logVerbosityLevel", this.getJasperLogLevel());
            wrapper.addInitParameter("com.sun.appserv.jsp.resource.injector", ResourceInjectorImpl.class.getName());
            String sysClassPath = ASClassLoaderUtil.getWebModuleClassPath(this.serverContext.getDefaultHabitat(), webModule.getID(), webModule.getLoader().getDelegate());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" sysClasspath for " + webModule.getID() + " is \n" + sysClassPath + "\n");
            }
            wrapper.addInitParameter("com.sun.appserv.jsp.classpath", sysClassPath);
        }
    }

    private String getJasperLogLevel() {
        Level level = _logger.getLevel();
        if (level == null) {
            return "warning";
        }
        if (level.equals(Level.WARNING)) {
            return "warning";
        }
        if (level.equals(Level.FINE)) {
            return "information";
        }
        if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            return "debug";
        }
        return "warning";
    }

    private void startCacheManager(WebModule webModule) {
        SunWebApp bean = webModule.getIasWebAppConfigBean();
        if (bean != null) {
            CacheManager cm = null;
            try {
                cm = CacheModule.configureResponseCache(webModule, bean);
            }
            catch (Exception ee) {
                _logger.log(Level.WARNING, "webmodule.listener.cachemgrException", ee);
            }
            if (cm != null) {
                try {
                    cm.start();
                    if (_debugLog) {
                        _logger.fine("Cache Manager started");
                    }
                    ServletContext ctxt = webModule.getServletContext();
                    ctxt.setAttribute("com.sun.appserv.web.CacheManager", (Object)cm);
                }
                catch (LifecycleException ee) {
                    _logger.log(Level.WARNING, ee.getMessage(), ee.getThrowable());
                }
            }
        }
    }

    private void stopCacheManager(WebModule webModule) {
        ServletContext ctxt = webModule.getServletContext();
        CacheManager cm = (CacheManager)ctxt.getAttribute("com.sun.appserv.web.CacheManager");
        if (cm != null) {
            try {
                cm.stop();
                if (_debugLog) {
                    _logger.fine("Cache Manager stopped");
                }
                ctxt.removeAttribute("com.sun.appserv.web.CacheManager");
            }
            catch (LifecycleException ee) {
                _logger.log(Level.WARNING, ee.getMessage(), ee.getThrowable());
            }
        }
    }

    private void configureDefaultServlet(WebModule webModule) {
        Wrapper wrapper = (Wrapper)webModule.findChild("default");
        if (wrapper == null) {
            return;
        }
        String servletClass = wrapper.getServletClass();
        if (servletClass == null || !servletClass.equals(Globals.DEFAULT_SERVLET_CLASS_NAME)) {
            return;
        }
        String fileEncoding = webModule.getFileEncoding();
        if (fileEncoding != null) {
            wrapper.addInitParameter("fileEncoding", fileEncoding);
        }
    }
}

