/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.extension;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.web.WebContainer;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyConfig
implements MonitoringLevelListener {
    private static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    private MBeanServer mBeanServer;
    private boolean isMonitoringEnabled = false;
    private String domain;
    private int port;
    private static ArrayList<GrizzlyConfig> grizzlyConfigList = new ArrayList();
    private Habitat habitat = null;

    public GrizzlyConfig(String domain, int port) {
        this.domain = domain;
        this.port = port;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.mBeanServer = !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        grizzlyConfigList.add(this);
    }

    public void initConfig() {
        this.initMonitoringLevel();
    }

    private void initMonitoringLevel() {
        try {
            ModuleMonitoringLevels levels;
            Config cfg = (Config)this.getHabitat().getComponent(Config.class);
            MonitoringLevel monitoringLevel = MonitoringLevel.OFF;
            if (cfg.getMonitoringService() != null && (levels = cfg.getMonitoringService().getModuleMonitoringLevels()) != null) {
                monitoringLevel = MonitoringLevel.instance((String)levels.getHttpService());
            }
            this.isMonitoringEnabled = !MonitoringLevel.OFF.equals((Object)monitoringLevel);
            String methodToInvoke = this.isMonitoringEnabled ? "enableMonitoring" : "disableMonitoring";
            this.invokeGrizzly(methodToInvoke);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "selectorThread.initMonitoringException", new Object[]{new Integer(this.port), ex});
        }
    }

    public void registerMonitoringLevelEvents() {
        if (WebContainer.getInstance() == null) {
            return;
        }
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)this.getHabitat().getComponent(MonitoringRegistry.class);
        if (monitoringRegistry != null) {
            monitoringRegistry.registerMonitoringLevelListener((MonitoringLevelListener)this, MonitoredObjectType.HTTP_LISTENER);
        }
    }

    public void unregisterMonitoringLevelEvents() {
        if (WebContainer.getInstance() == null) {
            return;
        }
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)this.getHabitat().getComponent(MonitoringRegistry.class);
        if (monitoringRegistry != null) {
            monitoringRegistry.unregisterMonitoringLevelListener((MonitoringLevelListener)this);
        }
    }

    public void setLevel(MonitoringLevel level) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (MonitoredObjectType.HTTP_LISTENER.equals(type)) {
            this.isMonitoringEnabled = !MonitoringLevel.OFF.equals((Object)to);
        }
        String methodToInvoke = this.isMonitoringEnabled ? "enableMonitoring" : "disabledMonitoring";
        this.invokeGrizzly(methodToInvoke);
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
    }

    protected final void invokeGrizzly(String methodToInvoke) {
        this.invokeGrizzly(methodToInvoke, null, null);
    }

    protected final void invokeGrizzly(String methodToInvoke, Object[] objects, String[] signature) {
        try {
            String onStr = this.domain + ":type=Selector,name=http" + this.port;
            ObjectName objectName = new ObjectName(onStr);
            if (this.mBeanServer.isRegistered(objectName)) {
                this.mBeanServer.invoke(objectName, methodToInvoke, objects, signature);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception while invoking mebean server operation " + methodToInvoke, ex.getMessage());
        }
    }

    public final void setEnableCallFlow(boolean enableCallFlow) {
        String methodToInvoke = enableCallFlow ? "enableMonitoring" : "disabledMonitoring";
        this.invokeGrizzly(methodToInvoke);
    }

    public static ArrayList<GrizzlyConfig> getGrizzlyConfigInstances() {
        return grizzlyConfigList;
    }

    public int getPort() {
        return this.port;
    }

    public Habitat getHabitat() {
        if (this.habitat == null) {
            this.habitat = WebContainer.getInstance().getServerContext().getDefaultHabitat();
        }
        return this.habitat;
    }
}

