/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.stats;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.PWCThreadPoolStats;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.enterprise.web.stats.StatsUtil;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public final class PWCThreadPoolStatsImpl
implements PWCThreadPoolStats {
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    private GenericStatsImpl baseStatsImpl = new GenericStatsImpl(PWCThreadPoolStats.class, (Object)this);
    private MBeanServer server;
    private ObjectName threadPoolName;
    private StringStatistic id;
    private MutableCountStatistic countThreadsIdle;
    private MutableCountStatistic countThreads;
    private MutableCountStatistic maxThreads;
    private MutableCountStatistic countQueued;
    private MutableCountStatistic peakQueued;
    private MutableCountStatistic maxQueued;

    public PWCThreadPoolStatsImpl(String domain) {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        String objNameStr = domain + ":type=Selector,*";
        try {
            this.threadPoolName = new ObjectName(objNameStr);
        }
        catch (Throwable t) {
            String msg = _logger.getResourceBundle().getString("webcontainer.objectNameCreationError");
            msg = MessageFormat.format(msg, objNameStr);
            _logger.log(Level.SEVERE, msg, t);
        }
        this.initializeStatistics();
    }

    public StringStatistic getId() {
        return this.id;
    }

    public CountStatistic getCountThreadsIdle() {
        this.countThreadsIdle.setCount((long)StatsUtil.getAggregateStatistic(this.server, this.threadPoolName, "countThreadsIdleStats"));
        return (CountStatistic)this.countThreadsIdle.unmodifiableView();
    }

    public CountStatistic getCountThreads() {
        this.countThreads.setCount((long)StatsUtil.getAggregateStatistic(this.server, this.threadPoolName, "countThreadsStats"));
        return (CountStatistic)this.countThreads.unmodifiableView();
    }

    public CountStatistic getMaxThreads() {
        this.maxThreads.setCount((long)StatsUtil.getAggregateStatistic(this.server, this.threadPoolName, "maxThreadsStats"));
        return (CountStatistic)this.maxThreads.unmodifiableView();
    }

    public CountStatistic getCountQueued() {
        return null;
    }

    public CountStatistic getPeakQueued() {
        return null;
    }

    public CountStatistic getMaxQueued() {
        return null;
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String name) {
        return this.baseStatsImpl.getStatistic(name);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        long startTime = System.currentTimeMillis();
        this.id = new StringStatisticImpl("", "id", "String", "ID of the thread pool", startTime, startTime);
        CountStatisticImpl c = new CountStatisticImpl("CountThreadsIdle");
        this.countThreadsIdle = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CountThreads");
        this.countThreads = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxThreads");
        this.maxThreads = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("CountQueued");
        this.countQueued = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("PeakQueued");
        this.peakQueued = new MutableCountStatisticImpl((CountStatistic)c);
        c = new CountStatisticImpl("MaxQueued");
        this.maxQueued = new MutableCountStatisticImpl((CountStatistic)c);
    }
}

