/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Auditor;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public abstract class AuthenticatorBase
extends ValveBase
implements Authenticator {
    private static Log log = LogFactory.getLog(AuthenticatorBase.class);
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected static final int SESSION_ID_BYTES = 16;
    protected String algorithm = "MD5";
    protected boolean cache = true;
    protected Context context = null;
    protected MessageDigest digest = null;
    protected String entropy = null;
    protected static final String info = "org.apache.catalina.authenticator.AuthenticatorBase/1.0";
    protected boolean disableProxyCaching = true;
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");
    protected SingleSignOn sso = null;
    protected boolean securePagesWithPragma = true;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public boolean getCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public Container getContainer() {
        return this.context;
    }

    public void setContainer(Container container) {
        if (!(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("authenticator.notContext"));
        }
        super.setContainer(container);
        this.context = (Context)container;
        this.securePagesWithPragma = this.context.isSecurePagesWithPragma();
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        this.entropy = entropy;
    }

    public String getInfo() {
        return info;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        this.randomClass = randomClass;
    }

    public boolean getDisableProxyCaching() {
        return this.disableProxyCaching;
    }

    public void setDisableProxyCaching(boolean nocache) {
        this.disableProxyCaching = nocache;
    }

    public boolean isSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    public void setSecurePagesWithPragma(boolean securePagesWithPragma) {
        this.securePagesWithPragma = securePagesWithPragma;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        Realm realm;
        SecurityConstraint[] constraints;
        Session session;
        Principal principal;
        if (!this.context.getAvailable()) {
            try {
                ((HttpServletResponse)response.getResponse()).sendError(503);
            }
            catch (IllegalStateException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            return 2;
        }
        HttpRequest hrequest = (HttpRequest)request;
        HttpResponse hresponse = (HttpResponse)response;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Security checking request " + ((HttpServletRequest)request.getRequest()).getMethod() + " " + ((HttpServletRequest)request.getRequest()).getRequestURI()));
        }
        LoginConfig config = this.context.getLoginConfig();
        if (this.cache && (principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal()) == null && (session = this.getSession(hrequest)) != null && (principal = session.getPrincipal()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("We have cached auth type " + session.getAuthType() + " for principal " + session.getPrincipal()));
            }
            hrequest.setAuthType(session.getAuthType());
            hrequest.setUserPrincipal(principal);
        }
        if ((constraints = (realm = this.context.getRealm()).findSecurityConstraints(hrequest, this.context)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Not subject to any constraint");
            }
            return this.processSecurityCheck(hrequest, hresponse, config);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Calling hasUserDataPermission()");
        }
        if (!realm.hasUserDataPermission(hrequest, hresponse, constraints)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Failed hasUserDataPermission() test");
            }
            return 2;
        }
        int preAuthenticateCheckResult = realm.preAuthenticateCheck(hrequest, hresponse, constraints, this.disableProxyCaching, this.securePagesWithPragma, this.sso != null);
        if (preAuthenticateCheckResult == 0) {
            return this.processSecurityCheck(hrequest, hresponse, config);
        }
        if (preAuthenticateCheckResult == 1) {
            boolean authenticateResult;
            if (log.isDebugEnabled()) {
                log.debug((Object)" Calling authenticate()");
            }
            if (!(authenticateResult = realm.invokeAuthenticateDelegate(hrequest, hresponse, this.context, this))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" Failed authenticate() test");
                }
                return 2;
            }
        } else if (preAuthenticateCheckResult == -1) {
            return 2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Calling accessControl()");
        }
        if (!realm.hasResourcePermission(hrequest, hresponse, constraints, this.context)) {
            Auditor[] auditors;
            if (log.isDebugEnabled()) {
                log.debug((Object)" Failed accessControl() test");
            }
            if ((auditors = this.context.getAuditors()) != null) {
                for (int j = 0; j < auditors.length; ++j) {
                    auditors[j].webInvocation(hrequest, false);
                }
            }
            return 2;
        }
        Auditor[] auditors = this.context.getAuditors();
        if (auditors != null) {
            boolean success = true;
            for (int j = 0; j < auditors.length; ++j) {
                try {
                    auditors[j].webInvocation(hrequest, true);
                    continue;
                }
                catch (Exception e) {
                    success = false;
                }
            }
            if (!success) {
                return 2;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Successfully passed all security constraints");
        }
        return 1;
    }

    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        Realm realm = this.context.getRealm();
        HttpRequest hrequest = (HttpRequest)request;
        HttpResponse hresponse = (HttpResponse)response;
        realm.invokePostAuthenticateDelegate(hrequest, hresponse, this.context);
    }

    protected void associate(String ssoId, Session session) {
        if (this.sso == null) {
            return;
        }
        this.sso.associate(ssoId, session);
    }

    public abstract boolean authenticate(HttpRequest var1, HttpResponse var2, LoginConfig var3) throws IOException;

    protected synchronized String generateSessionId() {
        Random random = this.getRandom();
        byte[] bytes = new byte[16];
        this.getRandom().nextBytes(bytes);
        bytes = this.getDigest().digest(bytes);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b1 = (byte)((bytes[i] & 0xF0) >> 4);
            byte b2 = (byte)(bytes[i] & 0xF);
            if (b1 < 10) {
                result.append((char)(48 + b1));
            } else {
                result.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                result.append((char)(48 + b2));
                continue;
            }
            result.append((char)(65 + (b2 - 10)));
        }
        return result.toString();
    }

    protected synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    this.digest = null;
                }
            }
        }
        return this.digest;
    }

    protected synchronized Random getRandom() {
        if (this.random == null) {
            try {
                Class<?> clazz = Class.forName(this.randomClass);
                this.random = (Random)clazz.newInstance();
                long seed = System.currentTimeMillis();
                char[] entropy = this.getEntropy().toCharArray();
                for (int i = 0; i < entropy.length; ++i) {
                    long update = (byte)entropy[i] << i % 8 * 8;
                    seed ^= update;
                }
                this.random.setSeed(seed);
            }
            catch (Exception e) {
                this.random = new Random();
            }
        }
        return this.random;
    }

    protected Session getSession(HttpRequest request) {
        return this.getSession(request, false);
    }

    protected Session getSession(HttpRequest request, boolean create) {
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpSession hses = hreq.getSession(create);
        if (hses == null) {
            return null;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return null;
        }
        try {
            return manager.findSession(hses.getId());
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void log(String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("Authenticator[" + this.context.getPath() + "]: " + message);
        } else {
            System.out.println("Authenticator[" + this.context.getPath() + "]: " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("Authenticator[" + this.context.getPath() + "]: " + message, throwable);
        } else {
            System.out.println("Authenticator[" + this.context.getPath() + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    protected void register(HttpRequest request, HttpResponse response, Principal principal, String authType, String username, String password) {
        Session session;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authenticated '" + principal.getName() + "' with type '" + authType + "'"));
        }
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        if (this.cache && (session = this.getSession(request, false)) != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
        if (this.sso == null) {
            return;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        String value = this.generateSessionId();
        Cookie cookie = new Cookie("JSESSIONIDSSO", value);
        cookie.setMaxAge(-1);
        cookie.setPath("/");
        cookie.setSecure(hreq.isSecure());
        hres.addCookie(cookie);
        String realm = this.context.getRealm().getRealmName();
        assert (realm != null);
        this.sso.register(value, principal, authType, username, password, realm);
        request.setNote("org.apache.catalina.request.SSOID", value);
    }

    private int processSecurityCheck(HttpRequest hrequest, HttpResponse hresponse, LoginConfig config) throws IOException {
        String contextPath = this.context.getPath();
        String requestURI = hrequest.getDecodedRequestURI();
        if (requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check") && !this.authenticate(hrequest, hresponse, config)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Failed authenticate() test ??" + requestURI));
            }
            return 2;
        }
        return 1;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        super.start();
        if ("org.apache.catalina.core.StandardContext".equals(this.context.getClass().getName())) {
            try {
                Class[] paramTypes = new Class[]{};
                Object[] paramValues = new Object[]{};
                Method method = this.context.getClass().getMethod("getDebug", paramTypes);
                Integer result = (Integer)method.invoke((Object)this.context, paramValues);
                this.setDebug(result);
            }
            catch (Exception e) {
                log.error((Object)"Exception getting debug value", (Throwable)e);
            }
        }
        Container parent = this.context.getParent();
        while (this.sso == null && parent != null) {
            if (!(parent instanceof Pipeline)) {
                parent = parent.getParent();
                continue;
            }
            Valve[] valves = ((Pipeline)((Object)parent)).getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.sso = (SingleSignOn)valves[i];
                break;
            }
            if (this.sso != null) continue;
            parent = parent.getParent();
        }
        if (log.isDebugEnabled()) {
            if (this.sso != null) {
                log.debug((Object)("Found SingleSignOn Valve at " + this.sso));
            } else {
                log.debug((Object)"No SingleSignOn Valve is present");
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.sso = null;
        super.stop();
    }

    public void setRealmName(String name) {
    }

    public String getRealmName() {
        return null;
    }
}

