/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Globals;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;

final class ApplicationFilterChain
implements FilterChain {
    public static final int INCREMENT = 10;
    private ApplicationFilterConfig[] filters = new ApplicationFilterConfig[0];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private InstanceSupport support = null;
    private static Class[] classType = new Class[]{ServletRequest.class, ServletResponse.class, FilterChain.class};
    private static Class[] classTypeUsedInService = new Class[]{ServletRequest.class, ServletResponse.class};

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            final ServletRequest req = request;
            final ServletResponse res = response;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ServletException, IOException {
                        ApplicationFilterChain.this.internalDoFilter(req, res);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.internalDoFilter(request, response);
        }
    }

    private void internalDoFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.pos < this.n) {
            ApplicationFilterConfig filterConfig = this.filters[this.pos++];
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                this.support.fireInstanceEvent("beforeFilter", filter, request, response);
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    ServletRequest req = request;
                    ServletResponse res = response;
                    Principal principal = ((HttpServletRequest)req).getUserPrincipal();
                    Object[] filterType = new Object[]{req, res, this};
                    SecurityUtil.doAsPrivilege("doFilter", filter, classType, filterType);
                    filterType = null;
                } else {
                    filter.doFilter(request, response, (FilterChain)this);
                }
                this.support.fireInstanceEvent("afterFilter", filter, request, response);
            }
            catch (IOException e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (ServletException e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (Throwable e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter, request, response, e);
                }
                throw new ServletException(sm.getString("filterChain.filter"), e);
            }
            return;
        }
        ApplicationFilterChain.servletService(request, response, this.servlet, this.support);
    }

    void addFilter(ApplicationFilterConfig filterConfig) {
        if (this.n == this.filters.length) {
            ApplicationFilterConfig[] newFilters = new ApplicationFilterConfig[this.n + 10];
            System.arraycopy(this.filters, 0, newFilters, 0, this.n);
            this.filters = newFilters;
        }
        this.filters[this.n++] = filterConfig;
    }

    void release() {
        this.n = 0;
        this.pos = 0;
        this.servlet = null;
        this.support = null;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setSupport(InstanceSupport support) {
        this.support = support;
    }

    static void servletService(ServletRequest request, ServletResponse response, Servlet serv, InstanceSupport supp) throws IOException, ServletException {
        try {
            supp.fireInstanceEvent("beforeService", serv, request, response);
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                if (SecurityUtil.executeUnderSubjectDoAs()) {
                    ServletRequest req = request;
                    ServletResponse res = response;
                    Principal principal = ((HttpServletRequest)req).getUserPrincipal();
                    Object[] serviceType = new Object[]{req, res};
                    SecurityUtil.doAsPrivilege("service", serv, classTypeUsedInService, serviceType, principal);
                    serviceType = null;
                } else {
                    serv.service((ServletRequest)((HttpServletRequest)request), (ServletResponse)((HttpServletResponse)response));
                }
            } else {
                serv.service(request, response);
            }
            supp.fireInstanceEvent("afterService", serv, request, response);
        }
        catch (IOException e) {
            supp.fireInstanceEvent("afterService", serv, request, response, (Throwable)e);
            throw e;
        }
        catch (ServletException e) {
            supp.fireInstanceEvent("afterService", serv, request, response, (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            supp.fireInstanceEvent("afterService", serv, request, response, (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            supp.fireInstanceEvent("afterService", serv, request, response, e);
            throw new ServletException(sm.getString("filterChain.servlet"), e);
        }
    }
}

