/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import com.sun.enterprise.util.uuid.UuidGenerator;
import com.sun.enterprise.util.uuid.UuidGeneratorImpl;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.org.apache.commons.modeler.Registry;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionLocker;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.session.BaseSessionLocker;
import org.apache.catalina.session.IOUtilsCaller;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.WebIOUtilsFactory;
import org.apache.catalina.util.StringManager;

public abstract class ManagerBase
implements Manager,
MBeanRegistration {
    protected Log log = LogFactory.getLog(ManagerBase.class);
    protected DataInputStream randomIS = null;
    protected String devRandomSource = "/dev/urandom";
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected String algorithm = "MD5";
    protected Container container;
    protected int debug = 0;
    protected DefaultContext defaultContext = null;
    protected MessageDigest digest = null;
    protected boolean distributable;
    protected String entropy = null;
    protected SessionLocker sessionLocker = new BaseSessionLocker();
    private static final String info = "ManagerBase/1.0";
    protected int maxInactiveInterval = 60;
    protected int sessionIdLength = 16;
    protected static final String name = "ManagerBase";
    protected Random random = null;
    protected UuidGenerator uuidGenerator = new UuidGeneratorImpl();
    protected String randomClass = "java.security.SecureRandom";
    protected int sessionMaxAliveTime;
    protected int sessionAverageAliveTime;
    protected int expiredSessions = 0;
    protected HashMap sessions = new HashMap();
    protected int sessionCounter = 0;
    protected int maxActive = 0;
    protected int duplicates = 0;
    protected boolean initialized = false;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.session");
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean prefixSessionID_ = false;
    private String prefix_ = null;
    private static final IOUtilsCaller webUtilsCaller;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public UuidGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator aUuidGenerator) {
        this.uuidGenerator = aUuidGenerator;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        String oldAlgorithm = this.algorithm;
        this.algorithm = algorithm;
        this.support.firePropertyChange("algorithm", oldAlgorithm, this.algorithm);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            long t1 = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("managerBase.getting", this.algorithm));
            }
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error((Object)sm.getString("managerBase.digest", this.algorithm), (Throwable)e);
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    this.log.error((Object)sm.getString("managerBase.digest", DEFAULT_ALGORITHM), (Throwable)e);
                    this.digest = null;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("managerBase.gotten"));
            }
            long t2 = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getDigest() " + (t2 - t1)));
            }
        }
        return this.digest;
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", (Object)oldDistributable, (Object)this.distributable);
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        String oldEntropy = entropy;
        this.entropy = entropy;
        this.support.firePropertyChange("entropy", oldEntropy, this.entropy);
    }

    public String getInfo() {
        return info;
    }

    public int getMaxInactiveInterval() {
        return this.getMaxInactiveIntervalSeconds();
    }

    public int getMaxInactiveIntervalSeconds() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.setMaxInactiveIntervalSeconds(interval);
    }

    public void setMaxInactiveIntervalSeconds(int interval) {
        int oldMaxInactiveInterval = this.maxInactiveInterval;
        this.maxInactiveInterval = interval;
        this.support.firePropertyChange("maxInactiveInterval", (Object)oldMaxInactiveInterval, (Object)this.maxInactiveInterval);
    }

    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    public void setSessionIdLength(int idLength) {
        int oldSessionIdLength = this.sessionIdLength;
        this.sessionIdLength = idLength;
        this.support.firePropertyChange("sessionIdLength", (Object)oldSessionIdLength, (Object)this.sessionIdLength);
    }

    public String getName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRandomFile(String s) {
        block14: {
            block13: {
                if (Globals.IS_SECURITY_ENABLED) {
                    this.randomIS = (DataInputStream)AccessController.doPrivileged(new PrivilegedSetRandomFile());
                    return;
                }
                fileInputStream = null;
                try {
                    try {
                        this.devRandomSource = s;
                        f = new File(this.devRandomSource);
                        if (!f.exists()) {
                            var5_5 = null;
                            break block13;
                        }
                        fileInputStream = new FileInputStream(f);
                        this.randomIS = new DataInputStream(fileInputStream);
                        this.randomIS.readLong();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Opening " + this.devRandomSource));
                        }
                        break block14;
                    }
                    catch (IOException ex) {
                        this.randomIS = null;
                        var5_7 = null;
                        try {
                            if (fileInputStream == null) return;
                            fileInputStream.close();
                            return;
                        }
                        catch (IOException ex) {
                            return;
                        }
                    }
                }
                catch (Throwable var4_13) {
                    var5_8 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 158->169)] { 
lbl34:
                    // 1 sources

                    if (fileInputStream == null) throw var4_13;
                    fileInputStream.close();
                    throw var4_13;
lbl37:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw var4_13;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 158->169)] { 
lbl42:
            // 1 sources

            if (fileInputStream == null) return;
            fileInputStream.close();
            return;
lbl45:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            return;
        }
        var5_6 = null;
        try {}
        catch (IOException ex) {}
        if (fileInputStream == null) return;
        fileInputStream.close();
        return;
    }

    public String getRandomFile() {
        return this.devRandomSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Random getRandom() {
        if (this.random == null) {
            ManagerBase managerBase = this;
            synchronized (managerBase) {
                if (this.random == null) {
                    long seed;
                    long t1 = seed = System.currentTimeMillis();
                    char[] entropy = this.getEntropy().toCharArray();
                    for (int i = 0; i < entropy.length; ++i) {
                        long update = (byte)entropy[i] << i % 8 * 8;
                        seed ^= update;
                    }
                    try {
                        Class<?> clazz = Class.forName(this.randomClass);
                        this.random = (Random)clazz.newInstance();
                        this.random.setSeed(seed);
                    }
                    catch (Exception e) {
                        this.log.error((Object)sm.getString("managerBase.random", this.randomClass), (Throwable)e);
                        this.random = new Random();
                        this.random.setSeed(seed);
                    }
                    long t2 = System.currentTimeMillis();
                    if (t2 - t1 > 100L) {
                        this.log.debug((Object)(sm.getString("managerBase.seeding", this.randomClass) + " " + (t2 - t1)));
                    }
                }
            }
        }
        return this.random;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        String oldRandomClass = this.randomClass;
        this.randomClass = randomClass;
        this.support.firePropertyChange("randomClass", oldRandomClass, this.randomClass);
    }

    public int getExpiredSessions() {
        return this.expiredSessions;
    }

    public void setExpiredSessions(int expiredSessions) {
        this.expiredSessions = expiredSessions;
    }

    public void setSessionIDPrefix(String prefix) {
        boolean bl = this.prefixSessionID_ = prefix != null;
        if (this.prefixSessionID_) {
            this.prefix_ = prefix;
        }
    }

    public void setSessionLocker(SessionLocker sessLocker) {
        this.sessionLocker = sessLocker;
    }

    public void destroy() {
        if (this.oname != null) {
            Registry.getRegistry().unregisterComponent(this.oname);
        }
        this.initialized = false;
        this.oname = null;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.oname == null) {
            try {
                StandardContext ctx = (StandardContext)this.getContainer();
                Engine eng = (Engine)ctx.getParent().getParent();
                this.domain = ctx.getEngineName();
                this.distributable = ctx.getDistributable();
                StandardHost hst = (StandardHost)ctx.getParent();
                String path = ctx.getEncodedPath();
                if (path.equals("")) {
                    path = "/";
                }
                this.oname = new ObjectName(this.domain + ":type=Manager,path=" + path + ",host=" + hst.getName());
                Registry.getRegistry().registerComponent((Object)this, this.oname, null);
            }
            catch (Exception e) {
                this.log.error((Object)"Error registering ", (Throwable)e);
            }
        }
        this.log.debug((Object)("Registering " + this.oname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.put(session.getIdInternal(), session);
            if (this.sessions.size() > this.maxActive) {
                this.maxActive = this.sessions.size();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public Session createSession() {
        Session session = null;
        session = this.createEmptySession();
        StandardSession sess = (StandardSession)session;
        sess.lockForeground();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        String sessionId = this.generateSessionId(session);
        session.setId(sessionId);
        ++this.sessionCounter;
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(String sessionId) {
        Session session = this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            if (this.sessions.get(sessionId) != null) {
                return null;
            }
        }
        StandardSession sess = (StandardSession)session;
        sess.lockForeground();
        session.setId(sessionId);
        ++this.sessionCounter;
        return session;
    }

    public Session createEmptySession() {
        return this.getNewSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session findSession(String id) throws IOException {
        if (id == null) {
            return null;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Session session = (Session)this.sessions.get(id);
            return session;
        }
    }

    public Session findSession(String id, String version) throws IOException {
        return this.findSession(id);
    }

    public boolean isSessionVersioningSupported() {
        return false;
    }

    public void clearSessions() {
        this.sessions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] findSessions() {
        Session[] results = null;
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            results = new Session[this.sessions.size()];
            results = this.sessions.values().toArray(results);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(session.getIdInternal());
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    protected static IOUtilsCaller getWebUtilsCaller() {
        return webUtilsCaller;
    }

    protected StandardSession getNewSession() {
        return new StandardSession(this);
    }

    protected void getRandomBytes(byte[] bytes) {
        if (this.devRandomSource != null && this.randomIS == null) {
            this.setRandomFile(this.devRandomSource);
        }
        if (this.randomIS != null) {
            try {
                int len = this.randomIS.read(bytes);
                if (len == bytes.length) {
                    return;
                }
                this.log.debug((Object)("Got " + len + " " + bytes.length));
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.devRandomSource = null;
            this.randomIS = null;
        }
        Random random = this.getRandom();
        this.getRandom().nextBytes(bytes);
    }

    protected synchronized String generateSessionId(Object obj) {
        String result = this.uuidGenerator.generateUuid(obj);
        if (this.prefixSessionID_) {
            result = this.prefix_ + result;
        }
        return result;
    }

    protected synchronized String generateSessionId() {
        return this.generateSessionId(new Object());
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (c == null || !(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        Engine e = this.getEngine();
        return e == null ? null : e.getJvmRoute();
    }

    protected void log(String message) {
        this.log.info((Object)message);
    }

    protected void log(String message, Throwable throwable) {
        this.log.info((Object)message, throwable);
    }

    public void setSessionCounter(int sessionCounter) {
        this.setSessionCount(sessionCounter);
    }

    public void setSessionCount(int sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    public int getSessionCounter() {
        return this.getSessionCount();
    }

    public int getSessionCount() {
        return this.sessionCounter;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(int duplicates) {
        this.duplicates = duplicates;
    }

    public int getActiveSessions() {
        return this.sessions.size();
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getSessionMaxAliveTime() {
        return this.getSessionMaxAliveTimeSeconds();
    }

    public int getSessionMaxAliveTimeSeconds() {
        return this.sessionMaxAliveTime;
    }

    public void setSessionMaxAliveTime(int sessionMaxAliveTime) {
        this.setSessionMaxAliveTimeSeconds(sessionMaxAliveTime);
    }

    public void setSessionMaxAliveTimeSeconds(int sessionMaxAliveTime) {
        this.sessionMaxAliveTime = sessionMaxAliveTime;
    }

    public int getSessionAverageAliveTime() {
        return this.getSessionAverageAliveTimeSeconds();
    }

    public int getSessionAverageAliveTimeSeconds() {
        return this.sessionAverageAliveTime;
    }

    public void setSessionAverageAliveTime(int sessionAverageAliveTime) {
        this.setSessionAverageAliveTimeSeconds(sessionAverageAliveTime);
    }

    public void setSessionAverageAliveTimeSeconds(int sessionAverageAliveTime) {
        this.sessionAverageAliveTime = sessionAverageAliveTime;
    }

    public String listSessionIds() {
        StringBuffer sb = new StringBuffer();
        Iterator keys = this.sessions.keySet().iterator();
        while (keys.hasNext()) {
            sb.append(keys.next()).append(" ");
        }
        return sb.toString();
    }

    public String getSessionAttribute(String sessionId, String key) {
        Session s = (Session)this.sessions.get(sessionId);
        if (s == null) {
            this.log.info((Object)("Session not found " + sessionId));
            return null;
        }
        Object o = s.getSession().getAttribute(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public HashMap getSession(String sessionId) {
        Session s = (Session)this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return null;
        }
        Enumeration ee = s.getSession().getAttributeNames();
        if (ee == null || !ee.hasMoreElements()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        while (ee.hasMoreElements()) {
            String attrName = (String)ee.nextElement();
            map.put(attrName, this.getSessionAttribute(sessionId, attrName));
        }
        return map;
    }

    public void expireSession(String sessionId) {
        Session s = (Session)this.sessions.get(sessionId);
        if (s == null) {
            this.log.info((Object)("Session not found " + sessionId));
            return;
        }
        s.expire();
    }

    public String getLastAccessedTimeMillis(String sessionId) {
        Session s = (Session)this.sessions.get(sessionId);
        if (s == null) {
            this.log.info((Object)("Session not found " + sessionId));
            return "";
        }
        return new Date(s.getLastAccessedTime()).toString();
    }

    public void update(HttpSession session) throws Exception {
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void postRequestDispatcherProcess(ServletRequest request, ServletResponse response) {
    }

    public void preRequestDispatcherProcess(ServletRequest request, ServletResponse response) {
    }

    public boolean lockSession(ServletRequest request) throws ServletException {
        boolean result = false;
        if (this.sessionLocker != null) {
            result = this.sessionLocker.lockSession(request);
        }
        return result;
    }

    public void unlockSession(ServletRequest request) {
        if (this.sessionLocker != null) {
            this.sessionLocker.unlockSession(request);
        }
    }

    public void release() {
        this.clearSessions();
    }

    static {
        WebIOUtilsFactory factory = new WebIOUtilsFactory();
        webUtilsCaller = factory.createWebIOUtil();
    }

    private class PrivilegedSetRandomFile
    implements PrivilegedAction {
        private PrivilegedSetRandomFile() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public Object run() {
            File f;
            FileInputStream fileInputStream;
            block15: {
                fileInputStream = null;
                f = new File(ManagerBase.this.devRandomSource);
                if (f.exists()) break block15;
                Object var3_4 = null;
                Object var5_7 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                return var3_4;
            }
            fileInputStream = new FileInputStream(f);
            ManagerBase.this.randomIS = new DataInputStream(fileInputStream);
            ManagerBase.this.randomIS.readLong();
            if (ManagerBase.this.log.isDebugEnabled()) {
                ManagerBase.this.log.debug((Object)("Opening " + ManagerBase.this.devRandomSource));
            }
            DataInputStream dataInputStream = ManagerBase.this.randomIS;
            Object var5_8 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return dataInputStream;
            catch (IOException ex) {
                Object var3_6;
                try {
                    var3_6 = null;
                    Object var5_9 = null;
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException ex2) {}
                    throw throwable;
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                return var3_6;
            }
        }
    }
}

