/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ConcurrentModificationException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.LifecycleSupport;

public abstract class PersistentManagerBase
extends ManagerBase
implements Lifecycle,
PropertyChangeListener {
    private static final Log log = LogFactory.getLog(PersistentManagerBase.class);
    private static final String info = "PersistentManagerBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private int maxActiveSessions = -1;
    protected static final String name = "PersistentManagerBase";
    private boolean started = false;
    private Store store = null;
    private boolean saveOnRestart = true;
    private int maxIdleBackup = -1;
    private int minIdleSwap = -1;
    private int maxIdleSwap = -1;
    private int rejectedSessions = 0;
    protected ConcurrentHashMap<String, Long> invalidatedSessions = new ConcurrentHashMap();
    private long rememberInvalidatedSessionIdMilliSecs = 60000L;

    public void backgroundProcess() {
        this.processExpires();
        this.processPersistenceChecks();
        this.processInvalidatedSessions();
        if (this.getStore() != null && this.getStore() instanceof StoreBase) {
            ((StoreBase)this.getStore()).processExpires();
        }
    }

    public int getMaxIdleBackup() {
        return this.maxIdleBackup;
    }

    public void setMaxIdleBackup(int backup) {
        if (backup == this.maxIdleBackup) {
            return;
        }
        int oldBackup = this.maxIdleBackup;
        this.maxIdleBackup = backup;
        this.support.firePropertyChange("maxIdleBackup", (Object)oldBackup, (Object)this.maxIdleBackup);
    }

    public int getMaxIdleSwap() {
        return this.maxIdleSwap;
    }

    public void setMaxIdleSwap(int max) {
        if (max == this.maxIdleSwap) {
            return;
        }
        int oldMaxIdleSwap = this.maxIdleSwap;
        this.maxIdleSwap = max;
        this.support.firePropertyChange("maxIdleSwap", (Object)oldMaxIdleSwap, (Object)this.maxIdleSwap);
    }

    public int getMinIdleSwap() {
        return this.minIdleSwap;
    }

    public void setMinIdleSwap(int min) {
        if (this.minIdleSwap == min) {
            return;
        }
        int oldMinIdleSwap = this.minIdleSwap;
        this.minIdleSwap = min;
        this.support.firePropertyChange("minIdleSwap", (Object)oldMinIdleSwap, (Object)this.minIdleSwap);
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveIntervalSeconds(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener(this);
        }
        if (container instanceof StandardContext) {
            StandardContext ctx = (StandardContext)container;
            int frequency = ctx.getManagerChecksFrequency();
            int reapIntervalSeconds = ctx.getBackgroundProcessorDelay();
            this.rememberInvalidatedSessionIdMilliSecs = (long)(frequency * reapIntervalSeconds) * 1000L * 2L;
            if (this.rememberInvalidatedSessionIdMilliSecs <= 0L) {
                this.rememberInvalidatedSessionIdMilliSecs = 60000L;
            }
        }
    }

    public String getInfo() {
        return info;
    }

    public boolean isLoaded(String id) {
        try {
            if (super.findSession(id) != null) {
                return true;
            }
        }
        catch (IOException e) {
            log.error((Object)("checking isLoaded for id, " + id + ", " + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", (Object)oldMaxActiveSessions, (Object)this.maxActiveSessions);
    }

    public int getRejectedSessions() {
        return this.rejectedSessions;
    }

    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedSessions = rejectedSessions;
    }

    public String getName() {
        return name;
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected void setStarted(boolean started) {
        this.started = started;
    }

    public void setStore(Store store) {
        this.store = store;
        store.setManager(this);
    }

    public Store getStore() {
        return this.store;
    }

    public boolean getSaveOnRestart() {
        return this.saveOnRestart;
    }

    public void setSaveOnRestart(boolean saveOnRestart) {
        if (saveOnRestart == this.saveOnRestart) {
            return;
        }
        boolean oldSaveOnRestart = this.saveOnRestart;
        this.saveOnRestart = saveOnRestart;
        this.support.firePropertyChange("saveOnRestart", (Object)oldSaveOnRestart, (Object)this.saveOnRestart);
    }

    public void release() {
        super.release();
        this.clearStore();
    }

    public void clearStore() {
        if (this.store == null) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreClear());
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.error((Object)("Exception clearing the Store: " + exception));
                    exception.printStackTrace();
                }
            } else {
                this.store.clear();
            }
        }
        catch (IOException e) {
            log.error((Object)("Exception clearing the Store: " + e));
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExpires() {
        if (!this.started) {
            return;
        }
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Object var7_5;
            StandardSession session = (StandardSession)sessions[i];
            if (session.getIsValid() && !session.hasExpired() || !session.lockBackground()) continue;
            try {
                session.expire();
                var7_5 = null;
                session.unlockBackground();
                continue;
            }
            catch (Throwable throwable) {
                var7_5 = null;
                session.unlockBackground();
                throw throwable;
            }
        }
    }

    public void processPersistenceChecks() {
        this.processMaxIdleSwaps();
        this.processMaxActiveSwaps();
        this.processMaxIdleBackups();
    }

    protected void processInvalidatedSessions() {
        if (!this.started) {
            return;
        }
        long timeNow = System.currentTimeMillis();
        for (String id : this.invalidatedSessions.keySet()) {
            Long timeAdded = this.invalidatedSessions.get(id);
            if (timeAdded != null && timeNow - timeAdded <= this.rememberInvalidatedSessionIdMilliSecs) continue;
            this.removeFromInvalidatedSessions(id);
        }
    }

    public Session createSession() {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            throw new IllegalStateException(sm.getString("standardManager.createSession.ise"));
        }
        return super.createSession();
    }

    public Session findSession(String id) throws IOException {
        if (!this.isSessionIdValid(id)) {
            return null;
        }
        Session session = super.findSession(id);
        if (session != null) {
            return session;
        }
        session = this.swapIn(id);
        return session;
    }

    public Session findSession(String id, boolean removeCachedCopy) throws IOException {
        Session theSession = super.findSession(id);
        if (theSession != null) {
            if (removeCachedCopy) {
                this.removeSuper(theSession);
                if (this.getStore() != null && this.getStore() instanceof StoreBase) {
                    ((StoreBase)this.getStore()).removeFromStoreCache(id);
                }
                theSession = null;
            } else {
                return theSession;
            }
        }
        theSession = this.findSession(id);
        return theSession;
    }

    protected Session superFindSession(String id) throws IOException {
        return super.findSession(id);
    }

    public void removeSuper(Session session) {
        super.remove(session);
    }

    public void load() {
        this.sessions.clear();
        if (this.store == null) {
            return;
        }
        String[] ids = null;
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    ids = (String[])AccessController.doPrivileged(new PrivilegedStoreKeys());
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.error((Object)("Exception in the Store during load: " + exception));
                    exception.printStackTrace();
                }
            } else {
                ids = this.store.keys();
            }
        }
        catch (IOException e) {
            log.error((Object)("Can't load sessions from store, " + e.getMessage()), (Throwable)e);
            return;
        }
        int n = ids.length;
        if (n == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("persistentManager.loading", String.valueOf(n)));
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.swapIn(ids[i]);
                continue;
            }
            catch (IOException e) {
                log.error((Object)("Failed load session from store, " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void remove(Session session) {
        this.remove(session, true);
    }

    public void remove(Session session, boolean persistentRemove) {
        super.remove(session);
        if (persistentRemove && this.store != null) {
            this.removeSession(session.getIdInternal());
        }
    }

    private void removeSession(String id) {
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreRemove(id));
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.error((Object)("Exception in the Store during removeSession: " + exception));
                    exception.printStackTrace();
                }
            } else {
                this.store.remove(id);
            }
        }
        catch (IOException e) {
            log.error((Object)("Exception removing session  " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void addToInvalidatedSessions(String sessionId) {
        this.invalidatedSessions.put(sessionId, System.currentTimeMillis());
    }

    public void removeFromInvalidatedSessions(String sessionId) {
        this.invalidatedSessions.remove(sessionId);
    }

    public boolean isSessionIdValid(String sessionId) {
        return !this.invalidatedSessions.containsKey(sessionId);
    }

    public void unload() {
        if (this.store == null) {
            return;
        }
        Session[] sessions = this.findSessions();
        int n = sessions.length;
        if (n == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("persistentManager.unloading", String.valueOf(n)));
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.swapOut(sessions[i]);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    protected Session swapIn(String id) throws IOException {
        return this.swapIn(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session swapIn(String id, String version) throws IOException {
        ClassLoader webappCl = null;
        ClassLoader curCl = null;
        if (this.getContainer() != null && this.getContainer().getLoader() != null) {
            webappCl = this.getContainer().getLoader().getClassLoader();
            curCl = Thread.currentThread().getContextClassLoader();
        }
        Session sess = null;
        if (webappCl != null && curCl != webappCl) {
            try {
                Thread.currentThread().setContextClassLoader(webappCl);
                sess = this.doSwapIn(id, version);
                Object var7_6 = null;
                Thread.currentThread().setContextClassLoader(curCl);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                Thread.currentThread().setContextClassLoader(curCl);
                throw throwable;
            }
        } else {
            sess = this.doSwapIn(id, version);
        }
        return sess;
    }

    private Session doSwapIn(String id, String version) throws IOException {
        Session session;
        block11: {
            if (this.store == null) {
                return null;
            }
            session = null;
            try {
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    try {
                        session = (Session)AccessController.doPrivileged(new PrivilegedStoreLoad(id));
                        break block11;
                    }
                    catch (PrivilegedActionException ex) {
                        Exception exception = ex.getException();
                        log.error((Object)("Exception in the Store during swapIn: " + exception));
                        if (exception instanceof IOException) {
                            throw (IOException)exception;
                        }
                        if (exception instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)exception;
                        }
                        break block11;
                    }
                }
                session = version != null ? ((StoreBase)this.store).load(id, version) : this.store.load(id);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)sm.getString("persistentManager.deserializeError", (Object)id, e));
                throw new IllegalStateException(sm.getString("persistentManager.deserializeError", (Object)id, e));
            }
        }
        if (session == null) {
            return null;
        }
        if (!session.isValid()) {
            log.error((Object)"session swapped in is invalid or expired");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("persistentManager.swapIn", id));
        }
        session.setManager(this);
        ((StandardSession)session).tellNew();
        this.add(session);
        ((StandardSession)session).activate();
        return session;
    }

    protected void swapOut(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        ((StandardSession)session).passivate();
        this.writeSession(session);
        super.remove(session);
        session.recycle();
    }

    protected void writeSession(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreSave(session));
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    log.error((Object)("Exception in the Store during writeSession: " + exception));
                    exception.printStackTrace();
                }
            } else {
                this.store.save(session);
            }
        }
        catch (IOException e) {
            log.error((Object)sm.getString("persistentManager.serializeError", (Object)session.getIdInternal(), e));
            throw e;
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            log.info((Object)sm.getString("standardManager.alreadyStarted"));
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Force random number initialization starting");
        }
        String dummy = this.generateSessionId();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Force random number initialization completed");
        }
        if (this.store == null) {
            log.error((Object)"No Store configured, persistence disabled");
        } else if (this.store instanceof Lifecycle) {
            ((Lifecycle)this.store).start();
        }
    }

    public void stop() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping");
        }
        if (!this.isStarted()) {
            log.info((Object)sm.getString("standardManager.notStarted"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.setStarted(false);
        if (this.getStore() != null && this.saveOnRestart) {
            this.unload();
        } else {
            Session[] sessions = this.findSessions();
            for (int i = 0; i < sessions.length; ++i) {
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid()) continue;
                session.expire();
            }
        }
        if (this.getStore() != null && this.getStore() instanceof Lifecycle) {
            ((Lifecycle)this.getStore()).stop();
        }
        this.random = null;
        if (this.initialized) {
            this.destroy();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        Context context = (Context)event.getSource();
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                this.setMaxInactiveIntervalSeconds((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException e) {
                log.error((Object)sm.getString("standardManager.sessionTimeout", event.getNewValue().toString()));
            }
        }
    }

    protected void processMaxIdleSwaps() {
        if (!this.isStarted() || this.maxIdleSwap < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        long timeNow = System.currentTimeMillis();
        if (this.maxIdleSwap >= 0) {
            for (int i = 0; i < sessions.length; ++i) {
                int timeIdle;
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid() || (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) <= this.maxIdleSwap || timeIdle <= this.minIdleSwap) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("persistentManager.swapMaxIdle", (Object)session.getIdInternal(), timeIdle));
                }
                try {
                    this.swapOut(session);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxActiveSwaps() {
        if (!this.isStarted() || this.getMaxActiveSessions() < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        if (this.getMaxActiveSessions() >= sessions.length) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("persistentManager.tooManyActive", sessions.length));
        }
        int toswap = sessions.length - this.getMaxActiveSessions();
        long timeNow = System.currentTimeMillis();
        for (int i = 0; i < sessions.length && toswap > 0; ++i) {
            block11: {
                Object var10_11;
                StandardSession session;
                int timeIdle = (int)((timeNow - sessions[i].getLastAccessedTime()) / 1000L);
                if (timeIdle <= this.minIdleSwap || !(session = (StandardSession)sessions[i]).lockBackground()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("persistentManager.swapTooManyActive", (Object)sessions[i].getIdInternal(), timeIdle));
                }
                try {
                    try {
                        this.swapOut(sessions[i]);
                    }
                    catch (ConcurrentModificationException e1) {
                        var10_11 = null;
                        session.unlockBackground();
                        break block11;
                    }
                    catch (IOException e) {
                        var10_11 = null;
                        session.unlockBackground();
                        break block11;
                    }
                    catch (Exception e) {
                        var10_11 = null;
                        session.unlockBackground();
                    }
                    var10_11 = null;
                    session.unlockBackground();
                }
                catch (Throwable throwable) {
                    var10_11 = null;
                    session.unlockBackground();
                    throw throwable;
                }
            }
            --toswap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxIdleBackups() {
        if (!this.isStarted() || this.maxIdleBackup < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        long timeNow = System.currentTimeMillis();
        if (this.maxIdleBackup >= 0) {
            for (int i = 0; i < sessions.length; ++i) {
                Object var9_10;
                int timeIdle;
                StandardSession session = (StandardSession)sessions[i];
                if (!session.isValid() || (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) <= this.maxIdleBackup || !session.lockBackground()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("persistentManager.backupMaxIdle", (Object)session.getIdInternal(), timeIdle));
                }
                try {
                    try {
                        this.writeSession(session);
                    }
                    catch (ConcurrentModificationException e1) {
                        var9_10 = null;
                        session.unlockBackground();
                        continue;
                    }
                    catch (IOException e) {
                        var9_10 = null;
                        session.unlockBackground();
                        continue;
                    }
                    catch (Exception e) {
                        var9_10 = null;
                        session.unlockBackground();
                        continue;
                    }
                    var9_10 = null;
                    session.unlockBackground();
                    continue;
                }
                catch (Throwable throwable) {
                    var9_10 = null;
                    session.unlockBackground();
                    throw throwable;
                }
            }
        }
    }

    public String getMonitorAttributeValues() {
        return "";
    }

    private class PrivilegedStoreKeys
    implements PrivilegedExceptionAction {
        PrivilegedStoreKeys() {
        }

        public Object run() throws Exception {
            return PersistentManagerBase.this.store.keys();
        }
    }

    private class PrivilegedStoreSave
    implements PrivilegedExceptionAction {
        private Session session;

        PrivilegedStoreSave(Session session) {
            this.session = session;
        }

        public Object run() throws Exception {
            PersistentManagerBase.this.store.save(this.session);
            return null;
        }
    }

    private class PrivilegedStoreLoad
    implements PrivilegedExceptionAction {
        private String id;

        PrivilegedStoreLoad(String id) {
            this.id = id;
        }

        public Object run() throws Exception {
            return PersistentManagerBase.this.store.load(this.id);
        }
    }

    private class PrivilegedStoreRemove
    implements PrivilegedExceptionAction {
        private String id;

        PrivilegedStoreRemove(String id) {
            this.id = id;
        }

        public Object run() throws Exception {
            PersistentManagerBase.this.store.remove(this.id);
            return null;
        }
    }

    private class PrivilegedStoreClear
    implements PrivilegedExceptionAction {
        PrivilegedStoreClear() {
        }

        public Object run() throws Exception {
            PersistentManagerBase.this.store.clear();
            return null;
        }
    }
}

