/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import com.sun.org.apache.commons.digester.Digester;
import com.sun.org.apache.commons.digester.RuleSet;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.util.SchemaResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DigesterFactory {
    private static String schemaResourcePrefix;
    private static String dtdResourcePrefix;

    public static Digester newDigester() {
        return DigesterFactory.newDigester(false, false, null);
    }

    public static Digester newDigester(RuleSet rule) {
        return DigesterFactory.newDigester(false, false, rule);
    }

    public static void setSchemaResourcePrefix(String prefix) {
        schemaResourcePrefix = prefix;
    }

    public static void setDtdResourcePrefix(String prefix) {
        dtdResourcePrefix = prefix;
    }

    public static Digester newDigester(boolean xmlValidation, boolean xmlNamespaceAware, RuleSet rule) {
        Object url = null;
        Digester digester = new Digester();
        digester.setNamespaceAware(xmlNamespaceAware);
        digester.setValidating(xmlValidation);
        digester.setUseContextClassLoader(true);
        String parserName = digester.getFactory().getClass().getName();
        if (parserName.indexOf("xerces") != -1) {
            digester = DigesterFactory.patchXerces(digester);
        }
        SchemaResolver schemaResolver = new SchemaResolver(digester);
        if (xmlValidation) {
            if (parserName.indexOf("xerces") != -1) {
                DigesterFactory.turnOnXercesValidation(digester);
            } else {
                DigesterFactory.turnOnValidation(digester);
            }
        }
        DigesterFactory.registerLocalSchema(schemaResolver);
        digester.setEntityResolver((EntityResolver)schemaResolver);
        if (rule != null) {
            digester.addRuleSet(rule);
        }
        return digester;
    }

    private static Digester patchXerces(Digester digester) {
        try {
            digester.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        return digester;
    }

    protected static void registerLocalSchema(SchemaResolver schemaResolver) {
        if (schemaResourcePrefix != null) {
            DigesterFactory.register(schemaResolver, schemaResourcePrefix + "javaee_5.xsd", "javaee_5.xsd");
            DigesterFactory.register(schemaResolver, schemaResourcePrefix + "j2ee_1_4.xsd", "j2ee_1_4.xsd");
            DigesterFactory.register(schemaResolver, schemaResourcePrefix + "xml.xsd", "xml.xsd");
            DigesterFactory.register(schemaResolver, schemaResourcePrefix + "jsp_2_0.xsd", "jsp_2_0.xsd");
            DigesterFactory.register(schemaResolver, schemaResourcePrefix + "jsp_2_1.xsd", "jsp_2_1.xsd");
            DigesterFactory.register(schemaResolver, schemaResourcePrefix + "web-jsptaglibrary_2_0.xsd", "web-jsptaglibrary_2_0.xsd");
            DigesterFactory.register(schemaResolver, schemaResourcePrefix + "web-jsptaglibrary_2_1.xsd", "web-jsptaglibrary_2_1.xsd");
            DigesterFactory.register(schemaResolver, schemaResourcePrefix + "web-app_2_4.xsd", "web-app_2_4.xsd");
            DigesterFactory.register(schemaResolver, schemaResourcePrefix + "web-app_2_5.xsd", "web-app_2_5.xsd");
            DigesterFactory.register(schemaResolver, schemaResourcePrefix + "j2ee_web_services_client_1_1.xsd", "j2ee_web_services_client_1_1.xsd");
        } else {
            DigesterFactory.register(schemaResolver, "/javax/servlet/resources/javaee_5.xsd", "javaee_5.xsd");
            DigesterFactory.register(schemaResolver, "/javax/servlet/resources/j2ee_1_4.xsd", "j2ee_1_4.xsd");
            DigesterFactory.register(schemaResolver, "/javax/servlet/resources/xml.xsd", "xml.xsd");
            DigesterFactory.register(schemaResolver, "/javax/servlet/resources/jsp_2_0.xsd", "jsp_2_0.xsd");
            DigesterFactory.register(schemaResolver, "/javax/servlet/resources/jsp_2_1.xsd", "jsp_2_1.xsd");
            DigesterFactory.register(schemaResolver, "/javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", "web-jsptaglibrary_2_0.xsd");
            DigesterFactory.register(schemaResolver, "/javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", "web-jsptaglibrary_2_1.xsd");
            DigesterFactory.register(schemaResolver, "/javax/servlet/resources/web-app_2_4.xsd", "web-app_2_4.xsd");
            DigesterFactory.register(schemaResolver, "/javax/servlet/resources/web-app_2_5.xsd", "web-app_2_5.xsd");
            DigesterFactory.register(schemaResolver, "/javax/servlet/resources/j2ee_web_services_client_1_1.xsd", "j2ee_web_services_client_1_1.xsd");
        }
        if (dtdResourcePrefix != null) {
            DigesterFactory.register(schemaResolver, dtdResourcePrefix + "web-jsptaglibrary_1_1.dtd", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN");
            DigesterFactory.register(schemaResolver, dtdResourcePrefix + "web-jsptaglibrary_1_2.dtd", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN");
            DigesterFactory.register(schemaResolver, dtdResourcePrefix + "web-app_2_2.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
            DigesterFactory.register(schemaResolver, dtdResourcePrefix + "web-app_2_3.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN");
        } else {
            DigesterFactory.register(schemaResolver, "/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN");
            DigesterFactory.register(schemaResolver, "/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN");
            DigesterFactory.register(schemaResolver, "/javax/servlet/resources/web-app_2_2.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
            DigesterFactory.register(schemaResolver, "/javax/servlet/resources/web-app_2_3.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN");
        }
    }

    protected static void register(SchemaResolver schemaResolver, String resourceURL, String resourcePublicId) {
        URL url = null;
        if (resourceURL != null && resourceURL.startsWith("file:")) {
            try {
                url = new URL(resourceURL);
            }
            catch (MalformedURLException e) {
                return;
            }
        } else {
            url = DigesterFactory.class.getResource(resourceURL);
        }
        schemaResolver.register(resourcePublicId, url.toString());
    }

    protected static void turnOnValidation(Digester digester) {
        URL url = DigesterFactory.class.getResource("/javax/servlet/resources/web-app_2_4.xsd");
        digester.setSchema(url.toString());
    }

    protected static void turnOnXercesValidation(Digester digester) {
        try {
            digester.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            digester.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }
}

