/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Wrapper;

public final class InstanceSupport {
    private ReadWriteLock listenersLock = new ReentrantReadWriteLock();
    private Lock listenersReadLock = this.listenersLock.readLock();
    private Lock listenersWriteLock = this.listenersLock.writeLock();
    private InstanceListener[] listeners = new InstanceListener[0];
    private Wrapper wrapper = null;

    public InstanceSupport(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(InstanceListener listener) {
        this.listenersWriteLock.lock();
        try {
            InstanceListener[] results = new InstanceListener[this.listeners.length + 1];
            for (int i = 0; i < this.listeners.length; ++i) {
                results[i] = this.listeners[i];
            }
            results[this.listeners.length] = listener;
            this.listeners = results;
            Object var5_4 = null;
            this.listenersWriteLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.listenersWriteLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(String type, Filter filter) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type);
        Object interested = null;
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
            Object var7_6 = null;
            this.listenersReadLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.listenersReadLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(String type, Filter filter, Throwable exception) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type, exception);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
            Object var7_6 = null;
            this.listenersReadLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.listenersReadLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(String type, Filter filter, ServletRequest request, ServletResponse response) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type, request, response);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
            Object var8_7 = null;
            this.listenersReadLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.listenersReadLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(String type, Filter filter, ServletRequest request, ServletResponse response, Throwable exception) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, filter, type, request, response, exception);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
            Object var9_8 = null;
            this.listenersReadLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.listenersReadLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(String type, Servlet servlet) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
            Object var6_5 = null;
            this.listenersReadLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.listenersReadLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(String type, Servlet servlet, Throwable exception) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type, exception);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
            Object var7_6 = null;
            this.listenersReadLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.listenersReadLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(String type, Servlet servlet, ServletRequest request, ServletResponse response) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type, request, response);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
            Object var8_7 = null;
            this.listenersReadLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.listenersReadLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInstanceEvent(String type, Servlet servlet, ServletRequest request, ServletResponse response, Throwable exception) {
        if (this.listeners.length == 0) {
            return;
        }
        InstanceEvent event = new InstanceEvent(this.wrapper, servlet, type, request, response, exception);
        this.listenersReadLock.lock();
        try {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].instanceEvent(event);
            }
            Object var9_8 = null;
            this.listenersReadLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.listenersReadLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(InstanceListener listener) {
        this.listenersWriteLock.lock();
        try {
            int n = -1;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != listener) continue;
                n = i;
                break;
            }
            if (n < 0) {
                Object var7_5 = null;
                this.listenersWriteLock.unlock();
                return;
            }
            InstanceListener[] results = new InstanceListener[this.listeners.length - 1];
            int j = 0;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.listeners[i];
            }
            this.listeners = results;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.listenersWriteLock.unlock();
            throw throwable;
        }
        Object var7_6 = null;
        this.listenersWriteLock.unlock();
    }
}

