/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.org.apache.commons.logging.impl.NoOpLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.util.SystemLogHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntJavaCompiler
implements JavaCompiler {
    private JasperAntLogger logger;
    private Javac javac;
    private Project project = null;
    private JspCompilationContext ctxt;
    private Options options;
    private ErrorDispatcher errDispatcher;
    private String javaFileName;
    private String javaEncoding;
    private boolean nolog;
    private StringBuffer info = new StringBuffer();
    private Log log;
    private static ExecutorService threadPool = null;
    private static ThreadFactory threadFactory = new JavacThreadFactory();
    private static final String JAVAC_THREAD_PREFIX = "javac-";
    private static String lineSeparator = System.getProperty("line.separator");

    private Project getProject() {
        if (this.project != null) {
            return this.project;
        }
        this.project = new Project();
        this.logger = new JasperAntLogger();
        this.logger.setOutputPrintStream(System.out);
        this.logger.setErrorPrintStream(System.err);
        this.logger.setMessageOutputLevel(2);
        this.project.addBuildListener((BuildListener)this.logger);
        if (System.getProperty("catalina.home") != null) {
            this.project.setBasedir(System.getProperty("catalina.home"));
        }
        if (this.options.getCompiler() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Compiler " + this.options.getCompiler()));
            }
            this.project.setProperty("build.compiler", this.options.getCompiler());
        }
        this.project.init();
        return this.project;
    }

    @Override
    public void init(JspCompilationContext ctxt, ErrorDispatcher errDispatcher, boolean suppressLogging) {
        this.ctxt = ctxt;
        this.errDispatcher = errDispatcher;
        this.options = ctxt.getOptions();
        this.log = suppressLogging ? new NoOpLog() : LogFactory.getLog(AntJavaCompiler.class);
        this.getProject();
        this.javac = (Javac)this.project.createTask("javac");
        this.javac.setFork(this.options.getFork());
        if (this.options.getCompiler() != null) {
            this.javac.setCompiler(this.options.getCompiler());
        }
        AntJavaCompiler.startThreadPool();
    }

    @Override
    public void setExtdirs(String exts) {
        Path extdirs = new Path(this.project);
        extdirs.setPath(exts);
        this.javac.setExtdirs(extdirs);
        this.info.append("    extdirs=" + exts + "\n");
    }

    @Override
    public void setTargetVM(String targetVM) {
        this.javac.setTarget(targetVM);
        this.info.append("   compilerTargetVM=" + targetVM + "\n");
    }

    @Override
    public void setSourceVM(String sourceVM) {
        this.javac.setSource(sourceVM);
        this.info.append("   compilerSourceVM=" + sourceVM + "\n");
    }

    @Override
    public void setClassPath(List<File> cpath) {
        Path path = new Path(this.project);
        for (File file : cpath) {
            path.setLocation(file);
            this.info.append("    cp=" + file + "\n");
        }
        this.javac.setClasspath(path);
    }

    @Override
    public void saveClassFile(String className, String classFileName) {
    }

    @Override
    public void setDebug(boolean debug) {
        this.javac.setDebug(debug);
        this.javac.setOptimize(!debug);
    }

    @Override
    public long getClassLastModified() {
        File classFile = new File(this.ctxt.getClassFileName());
        return classFile.lastModified();
    }

    @Override
    public Writer getJavaWriter(String javaFileName, String javaEncoding) throws JasperException {
        this.javaFileName = javaFileName;
        this.info.append("Compile: javaFileName=" + javaFileName + "\n");
        this.javaEncoding = javaEncoding;
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            this.errDispatcher.jspError("jsp.error.needAlternateJavaEncoding", javaEncoding);
        }
        catch (IOException ex) {
            this.errDispatcher.jspError("jsp.error.unableToCreateOutputWriter", javaFileName, ex);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavacErrorDetail[] compile(String className, Node.Nodes pageNodes) throws JasperException {
        SystemLogHandler.setThread();
        this.javac.setEncoding(this.javaEncoding);
        Path srcPath = new Path(this.project);
        srcPath.setLocation(this.options.getScratchDir());
        this.javac.setSrcdir(srcPath);
        this.info.append("    srcDir=" + srcPath + "\n");
        this.info.append("    work dir=" + this.options.getScratchDir() + "\n");
        PatternSet.NameEntry includes = this.javac.createInclude();
        includes.setName(this.ctxt.getJavaPath());
        this.info.append("    include=" + this.ctxt.getJavaPath() + "\n");
        BuildException be = null;
        StringBuffer errorReport = new StringBuffer();
        String errorCapture = null;
        if (this.ctxt.getOptions().getFork()) {
            try {
                this.javac.execute();
            }
            catch (BuildException e) {
                be = e;
                this.log.error((Object)"Javac exception ", (Throwable)e);
                this.log.error((Object)("Env: " + this.info.toString()));
            }
            errorReport.append(this.logger.getReport());
            errorCapture = SystemLogHandler.unsetThread();
        } else {
            JavacObj javacObj;
            errorReport.append(this.logger.getReport());
            errorCapture = SystemLogHandler.unsetThread();
            if (errorCapture != null) {
                errorReport.append(lineSeparator);
                errorReport.append(errorCapture);
            }
            JavacObj javacObj2 = javacObj = new JavacObj(this.javac);
            synchronized (javacObj2) {
                threadPool.execute(javacObj);
                try {
                    javacObj.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            be = javacObj.getException();
            if (be != null) {
                this.log.error((Object)"Javac exception ", (Throwable)be);
                this.log.error((Object)("Env: " + this.info.toString()));
            }
            errorReport.append(this.logger.getReport());
            errorCapture = javacObj.getErrorCapture();
        }
        if (errorCapture != null) {
            errorReport.append(lineSeparator);
            errorReport.append(errorCapture);
        }
        JavacErrorDetail[] javacErrors = null;
        if (be != null) {
            try {
                String errorReportString = errorReport.toString();
                javacErrors = ErrorDispatcher.parseJavacMessage(pageNodes, errorReportString, this.javaFileName);
            }
            catch (IOException ex) {
                throw new JasperException(ex);
            }
        }
        return javacErrors;
    }

    @Override
    public void doJavaFile(boolean keep) {
        if (!keep) {
            File javaFile = new File(this.javaFileName);
            javaFile.delete();
        }
    }

    public static void startThreadPool() {
        if (threadPool == null) {
            threadPool = Executors.newCachedThreadPool(threadFactory);
        }
    }

    public static void shutdownThreadPool() {
        if (threadPool != null) {
            threadPool.shutdown();
        }
    }

    private static class JavacThreadFactory
    implements ThreadFactory {
        private ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        private JavacThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = this.defaultFactory.newThread(r);
            t.setName(AntJavaCompiler.JAVAC_THREAD_PREFIX + t.getName());
            return t;
        }
    }

    private static class JavacObj
    implements Runnable {
        Javac _javac = null;
        BuildException _be = null;
        String _errorCapture = null;

        public JavacObj(Javac javac) {
            this._javac = javac;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            SystemLogHandler.setThread();
            try {
                try {
                    this._javac.execute();
                }
                catch (BuildException e) {
                    this._be = e;
                    Object var3_2 = null;
                    this._errorCapture = SystemLogHandler.unsetThread();
                    JavacObj javacObj2 = this;
                    synchronized (javacObj2) {
                        this.notify();
                        return;
                    }
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._errorCapture = SystemLogHandler.unsetThread();
                JavacObj javacObj = this;
                synchronized (javacObj) {
                    this.notify();
                    throw throwable;
                }
            }
            this._errorCapture = SystemLogHandler.unsetThread();
            JavacObj javacObj = this;
            synchronized (javacObj) {
                this.notify();
                return;
            }
        }

        public BuildException getException() {
            return this._be;
        }

        public String getErrorCapture() {
            return this._errorCapture;
        }
    }

    class JasperAntLogger
    extends DefaultLogger {
        private StringBuffer reportBuf = new StringBuffer();

        JasperAntLogger() {
        }

        protected void printMessage(String message, PrintStream stream, int priority) {
        }

        protected void log(String message) {
            this.reportBuf.append(message);
            this.reportBuf.append(lineSeparator);
        }

        protected String getReport() {
            String report = this.reportBuf.toString();
            this.reportBuf.setLength(0);
            return report;
        }
    }
}

