/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.xmlparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.ParserUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class MyEntityResolver
implements EntityResolver {
    MyEntityResolver() {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        for (int i = 0; i < ParserUtils.CACHED_DTD_PUBLIC_IDS.length; ++i) {
            String cachedDtdPublicId = ParserUtils.CACHED_DTD_PUBLIC_IDS[i];
            if (!cachedDtdPublicId.equals(publicId)) continue;
            String resourcePath = ParserUtils.CACHED_DTD_RESOURCE_PATHS[i];
            InputStream input = null;
            if (ParserUtils.dtdResourcePrefix != null && ParserUtils.dtdResourcePrefix.startsWith("file:")) {
                try {
                    File path = new File(new URI(resourcePath));
                    if (path.exists()) {
                        input = new FileInputStream(path);
                    }
                }
                catch (Exception e) {}
            } else {
                input = this.getClass().getResourceAsStream(resourcePath);
            }
            if (input == null) {
                throw new SAXException(Localizer.getMessage("jsp.error.internal.filenotfound", resourcePath));
            }
            InputSource isrc = new InputSource(input);
            return isrc;
        }
        if (ParserUtils.log.isDebugEnabled()) {
            ParserUtils.log.debug((Object)("Resolve entity failed" + publicId + " " + systemId));
        }
        ParserUtils.log.error((Object)Localizer.getMessage("jsp.error.parse.xml.invalidPublicId", publicId));
        return null;
    }
}

