/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.io.ObjectInputStream;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public final class AppserverMBeanServer
implements MBeanServer {
    private final String mDefaultDomain;
    private volatile MBeanServer mTargetMBeanServer;
    private static final AppserverMBeanServer INSTANCE = new AppserverMBeanServer("");
    private static final boolean DEBUG = false;
    private static final String AMX_DOMAIN = "amx";
    private static final ObjectName AMX_STARTUP_OBJECT_NAME = AppserverMBeanServer.getAMXStartupObjectName();
    private static volatile boolean AMX_STARTED = false;

    private AppserverMBeanServer(String defaultDomain) {
        this.mDefaultDomain = defaultDomain;
        this.mTargetMBeanServer = null;
    }

    private void setup() {
        MBeanServerBuilder builder = new MBeanServerBuilder();
        this.mTargetMBeanServer = builder.newMBeanServer("", this, builder.newMBeanServerDelegate());
    }

    public static synchronized MBeanServer getInstance() {
        if (AppserverMBeanServer.INSTANCE.mTargetMBeanServer == null) {
            INSTANCE.setup();
        }
        return INSTANCE;
    }

    private static void debug(Object ... items) {
    }

    private static ObjectName getAMXStartupObjectName() {
        try {
            return new ObjectName("amx-support:name=startup");
        }
        catch (JMException e) {
            throw new Error("impossible");
        }
    }

    private void ensureAMXLoaded(String msg) {
        if (!AMX_STARTED) {
            if (this.isRegistered(AMX_STARTUP_OBJECT_NAME)) {
                AMX_STARTED = true;
                System.out.println("AppserverMBeanServer: loading AMX MBeans. Reason: " + msg);
                try {
                    this.invoke(AMX_STARTUP_OBJECT_NAME, "startAMX", null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("WARNING: request for AMX but AMXStartupService not available");
            }
        }
    }

    private void ensureAMXLoaded(ObjectName objectName, String where) {
        if (!AMX_STARTED && objectName != null && objectName.getDomain().equals(AMX_DOMAIN)) {
            this.ensureAMXLoaded("request for " + objectName + " from " + where);
        }
    }

    public MBeanServer getTargetMBeanServer() {
        return this.mTargetMBeanServer;
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ReflectionException, InstanceNotFoundException, MBeanException {
        this.ensureAMXLoaded(objectName, "invoke of " + operationName);
        AppserverMBeanServer.debug("AppserverMBeanServer.invoke(): ", objectName, ".", operationName, "{", params, "}", "{", signature, "}");
        Object result = this.getTargetMBeanServer().invoke(objectName, operationName, params, signature);
        return result;
    }

    public final Object getAttribute(ObjectName objectName, String attributeName) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
        this.ensureAMXLoaded(objectName, "getAttribute");
        Object result = this.getTargetMBeanServer().getAttribute(objectName, attributeName);
        AppserverMBeanServer.debug("AppserverMBeanServer.getAttribute: ", objectName, attributeName, result);
        return result;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, InvalidAttributeValueException {
        this.ensureAMXLoaded(objectName, "setAttribute");
        AppserverMBeanServer.debug("AppserverMBeanServer.setAttribute: ", objectName, attribute);
        this.getTargetMBeanServer().setAttribute(objectName, attribute);
    }

    public final AttributeList getAttributes(ObjectName objectName, String[] attrNames) throws InstanceNotFoundException, ReflectionException {
        this.ensureAMXLoaded(objectName, "getAttributes");
        AttributeList result = this.getTargetMBeanServer().getAttributes(objectName, attrNames);
        AppserverMBeanServer.debug("AppserverMBeanServer.getAttributes: ", objectName, attrNames, result);
        return result;
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        this.ensureAMXLoaded(objectName, "setAttributes");
        AppserverMBeanServer.debug("AppserverMBeanServer.setAttributes: ", objectName, attributeList);
        AttributeList result = this.getTargetMBeanServer().setAttributes(objectName, attributeList);
        return result;
    }

    public final ObjectInstance registerMBean(Object obj, ObjectName objectName) throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        AppserverMBeanServer.debug("AppserverMBeanServer.registerMBean: ", objectName, obj.getClass().getName());
        return this.getTargetMBeanServer().registerMBean(obj, objectName);
    }

    public final void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        AppserverMBeanServer.debug("AppserverMBeanServer.unregisterMBean: ", objectName);
        this.getTargetMBeanServer().unregisterMBean(objectName);
    }

    public final Integer getMBeanCount() {
        AppserverMBeanServer.debug("AppserverMBeanServer.getMBeanCount: ");
        return this.getTargetMBeanServer().getMBeanCount();
    }

    public final MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.ensureAMXLoaded(objectName, "getMBeanInfo");
        AppserverMBeanServer.debug("AppserverMBeanServer.getMBeanInfo: ", objectName);
        MBeanInfo result = this.getTargetMBeanServer().getMBeanInfo(objectName);
        return result;
    }

    public final boolean isRegistered(ObjectName objectName) {
        this.ensureAMXLoaded(objectName, "isRegistered");
        boolean isRegistered = this.getTargetMBeanServer().isRegistered(objectName);
        return isRegistered;
    }

    public final void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        AppserverMBeanServer.debug("AppserverMBeanServer.addNotificationListener: ", objectName, notificationListener.getClass().getName());
        this.getTargetMBeanServer().addNotificationListener(objectName, notificationListener, notificationFilter, obj);
    }

    public final void addNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        AppserverMBeanServer.debug("AppserverMBeanServer.addNotificationListener: ", objectName, objectName1);
        this.getTargetMBeanServer().addNotificationListener(objectName, objectName1, notificationFilter, obj);
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        AppserverMBeanServer.debug("AppserverMBeanServer.createMBean: ", str, objectName);
        return this.getTargetMBeanServer().createMBean(str, objectName);
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        AppserverMBeanServer.debug("AppserverMBeanServer.createMBean: ", str, objectName, objectName2);
        return this.getTargetMBeanServer().createMBean(str, objectName, objectName2);
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        AppserverMBeanServer.debug("AppserverMBeanServer.createMBean: ", str, objectName, obj, str3);
        return this.getTargetMBeanServer().createMBean(str, objectName, obj, str3);
    }

    public final ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2, Object[] obj, String[] str4) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        AppserverMBeanServer.debug("AppserverMBeanServer.createMBean: ", str, objectName, objectName2, obj, str4);
        return this.getTargetMBeanServer().createMBean(str, objectName, objectName2, obj, str4);
    }

    public final ObjectInputStream deserialize(String str, byte[] values) throws OperationsException, ReflectionException {
        AppserverMBeanServer.debug("AppserverMBeanServer.deserialize: ", str, values);
        return this.getTargetMBeanServer().deserialize(str, values);
    }

    public final ObjectInputStream deserialize(ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException {
        AppserverMBeanServer.debug("AppserverMBeanServer.deserialize: ", objectName, values);
        return this.getTargetMBeanServer().deserialize(objectName, values);
    }

    public final ObjectInputStream deserialize(String str, ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException, ReflectionException {
        AppserverMBeanServer.debug("AppserverMBeanServer.deserialize: ", str, objectName, values);
        return this.getTargetMBeanServer().deserialize(str, objectName, values);
    }

    public final String getDefaultDomain() {
        AppserverMBeanServer.debug("AppserverMBeanServer.getDefaultDomain: ");
        return this.getTargetMBeanServer().getDefaultDomain();
    }

    public final ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        AppserverMBeanServer.debug("AppserverMBeanServer.getDefaultDomain: getObjectInstance", objectName);
        return this.getTargetMBeanServer().getObjectInstance(objectName);
    }

    public final Object instantiate(String str) throws ReflectionException, MBeanException {
        AppserverMBeanServer.debug("AppserverMBeanServer.instantiate: ", str);
        return this.getTargetMBeanServer().instantiate(str);
    }

    public final Object instantiate(String str, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        AppserverMBeanServer.debug("AppserverMBeanServer.instantiate: ", str, objectName);
        return this.getTargetMBeanServer().instantiate(str, objectName);
    }

    public final Object instantiate(String str, Object[] obj, String[] str2) throws ReflectionException, MBeanException {
        AppserverMBeanServer.debug("AppserverMBeanServer.instantiate: ", str, obj, str2);
        return this.getTargetMBeanServer().instantiate(str, obj, str2);
    }

    public final Object instantiate(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, MBeanException, InstanceNotFoundException {
        AppserverMBeanServer.debug("AppserverMBeanServer.instantiate: ", str, objectName, obj, str3);
        return this.getTargetMBeanServer().instantiate(str, objectName, obj, str3);
    }

    public final boolean isInstanceOf(ObjectName objectName, String str) throws InstanceNotFoundException {
        AppserverMBeanServer.debug("AppserverMBeanServer.isInstanceOf: ", objectName, str);
        return this.getTargetMBeanServer().isInstanceOf(objectName, str);
    }

    private static boolean mightBeAMX(ObjectName objectName) {
        if (objectName == null) {
            return true;
        }
        String domain = objectName.getDomain();
        return domain.equals(AMX_DOMAIN) || domain.equals("*");
    }

    public final Set queryNames(ObjectName objectName, QueryExp queryExp) {
        if (!AMX_STARTED && AppserverMBeanServer.mightBeAMX(objectName)) {
            this.ensureAMXLoaded("queryNames: objectName = " + objectName + " queryExp = " + queryExp);
        }
        AppserverMBeanServer.debug("AppserverMBeanServer.queryNames: ", objectName, queryExp);
        return this.getTargetMBeanServer().queryNames(objectName, queryExp);
    }

    public final Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        if (!AMX_STARTED && AppserverMBeanServer.mightBeAMX(objectName)) {
            this.ensureAMXLoaded("queryMBeans: objectName = " + objectName + " queryExp = " + queryExp);
        }
        AppserverMBeanServer.debug("AppserverMBeanServer.queryMBeans: ", objectName, queryExp);
        return this.getTargetMBeanServer().queryMBeans(objectName, queryExp);
    }

    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName1) throws InstanceNotFoundException, ListenerNotFoundException {
        AppserverMBeanServer.debug("AppserverMBeanServer.removeNotificationListener: ", objectName, objectName1);
        this.getTargetMBeanServer().removeNotificationListener(objectName, objectName1);
    }

    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        AppserverMBeanServer.debug("AppserverMBeanServer.removeNotificationListener: ", objectName, notificationListener);
        this.getTargetMBeanServer().removeNotificationListener(objectName, notificationListener);
    }

    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException {
        AppserverMBeanServer.debug("AppserverMBeanServer.removeNotificationListener: ", objectName, notificationListener, notificationFilter, obj);
        this.getTargetMBeanServer().removeNotificationListener(objectName, notificationListener, notificationFilter, obj);
    }

    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException {
        AppserverMBeanServer.debug("AppserverMBeanServer.removeNotificationListener: ", objectName, objectName1, notificationFilter, obj);
        this.getTargetMBeanServer().removeNotificationListener(objectName, objectName1, notificationFilter, obj);
    }

    public final ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        this.ensureAMXLoaded(objectName, "getClassLoader");
        AppserverMBeanServer.debug("AppserverMBeanServer.getClassLoader: ", objectName);
        ClassLoader result = this.getTargetMBeanServer().getClassLoader(objectName);
        return result;
    }

    public final ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        this.ensureAMXLoaded(objectName, "getClassLoaderFor");
        AppserverMBeanServer.debug("AppserverMBeanServer.getClassLoaderFor: ", objectName);
        ClassLoader result = this.getTargetMBeanServer().getClassLoaderFor(objectName);
        return result;
    }

    public final ClassLoaderRepository getClassLoaderRepository() {
        AppserverMBeanServer.debug("AppserverMBeanServer.getClassLoaderRepository");
        return this.getTargetMBeanServer().getClassLoaderRepository();
    }

    public final String[] getDomains() {
        this.ensureAMXLoaded("getDomains");
        AppserverMBeanServer.debug("AppserverMBeanServer.getDomains");
        return this.getTargetMBeanServer().getDomains();
    }
}

