/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.SecurityLifecycleException;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.jmac.config.GFAuthConfigFactory;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.Security;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.glassfish.api.Startup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class SecurityLifecycle
implements PostConstruct,
PreDestroy {
    @Inject
    private ServerContext sc;
    @Inject
    private PolicyLoader policyLoader;
    @Inject
    private AuditManager auditManager;
    @Inject
    private SecurityServicesUtil secServUtil;
    @Inject
    Util util;
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(SecurityLifecycle.class);
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");

    public SecurityLifecycle() {
        try {
            SecurityManager secMgr = System.getSecurityManager();
            if (secMgr != null && !J2EESecurityManager.class.equals(secMgr.getClass())) {
                J2EESecurityManager mgr = new J2EESecurityManager();
                try {
                    System.setSecurityManager(mgr);
                }
                catch (SecurityException ex) {
                    _logger.log(Level.WARNING, "security.secmgr.could.not.override");
                }
            }
            if (_logger.isLoggable(Level.INFO)) {
                if (secMgr != null) {
                    _logger.info("security.secmgron");
                } else {
                    _logger.info("security.secmgroff");
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "java_security.init_securitylifecycle_fail", ex);
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public void onInitialization() {
        try {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Security startup service called");
            }
            LoginContextDriver.AUDIT_MANAGER = this.auditManager;
            this.secServUtil.initSecureSeed();
            SSLUtils.initStoresAtStartup();
            this.initializeJMAC();
            assert (this.policyLoader != null);
            this.createRealms();
            this.auditManager.loadAuditModules();
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Security service(s) started successfully....");
            }
        }
        catch (Exception ex) {
            throw new SecurityLifecycleException(ex);
        }
    }

    private void initializeJMAC() throws IOException {
        String defaultFactory = Security.getProperty("authconfigprovider.factory");
        if (defaultFactory == null) {
            Security.setProperty("authconfigprovider.factory", GFAuthConfigFactory.class.getName());
        }
    }

    private void registerPolicyHandlers() throws PolicyContextException {
        PolicyContextHandler pch = PolicyContextHandlerImpl.getInstance();
        PolicyContext.registerHandler((String)"javax.ejb.EnterpriseBean", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"javax.ejb.arguments", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"javax.servlet.http.HttpServletRequest", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"java.security.Policy.supportsReuse", (PolicyContextHandler)pch, (boolean)true);
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.START;
    }

    public void postConstruct() {
        this.onInitialization();
    }

    public void preDestroy() {
    }

    private void initRoleMapperFactory() throws Exception {
        Object o = null;
        Class<?> c = null;
        try {
            c = Class.forName("com.sun.enterprise.security.acl.RoleMapperFactory");
            if (c != null && (o = c.newInstance()) != null && o instanceof SecurityRoleMapperFactory) {
                SecurityRoleMapperFactoryMgr.registerFactory((SecurityRoleMapperFactory)o);
            }
            if (o == null) {
                _logger.log(Level.SEVERE, _localStrings.getLocalString("j2ee.norolemapper", "Cannot instantiate the SecurityRoleMapperFactory"));
            }
        }
        catch (Exception cnfe) {
            _logger.log(Level.SEVERE, _localStrings.getLocalString("j2ee.norolemapper", "Cannot instantiate the SecurityRoleMapperFactory"), cnfe);
            throw cnfe;
        }
    }

    public void createRealms() {
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Initializing configured realms from SecurityService in Domain.xml....");
            }
            SecurityService securityBean = (SecurityService)this.sc.getDefaultHabitat().getComponent(SecurityService.class);
            assert (securityBean != null);
            String defaultRealm = securityBean.getDefaultRealm();
            List realms = securityBean.getAuthRealm();
            assert (realms != null);
            SecurityLifecycle.createRealms(defaultRealm, realms);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "realmconfig.nogood", e);
        }
    }

    public static void createRealms(String defaultRealm, List<AuthRealm> realms) {
        assert (realms != null);
        String goodRealm = null;
        for (AuthRealm aRealm : realms) {
            String realmName = aRealm.getName();
            String realmClass = aRealm.getClassname();
            assert (realmName != null);
            assert (realmClass != null);
            try {
                List realmProps = aRealm.getProperty();
                Properties props = new Properties();
                for (Property realmProp : realmProps) {
                    props.setProperty(realmProp.getName(), realmProp.getValue());
                }
                Realm.instantiate((String)realmName, (String)realmClass, (Properties)props);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Configured realm: " + realmName);
                }
                if (goodRealm != null) continue;
                goodRealm = realmName;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "realmconfig.disable", realmName);
                _logger.log(Level.WARNING, "security.exception", e);
            }
        }
        if (goodRealm == null) {
            _logger.severe("realmconfig.nogood");
        } else {
            try {
                Realm def = Realm.getInstance((String)defaultRealm);
                if (def == null) {
                    defaultRealm = goodRealm;
                }
            }
            catch (Exception e) {
                defaultRealm = goodRealm;
            }
            Realm.setDefaultRealm((String)defaultRealm);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Default realm is set to: " + defaultRealm);
            }
        }
    }
}

