/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.LoginDialog;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public final class TextLoginDialog
implements LoginDialog {
    private static Logger _logger = null;
    private String username = null;
    private String password = null;
    private static LocalStringManagerImpl localStrings;

    public TextLoginDialog() {
        BufferedReader d = new BufferedReader(new InputStreamReader(System.in));
        do {
            System.out.print(localStrings.getLocalString("enterprise.security.login.username", "User Name: "));
            try {
                this.username = d.readLine();
            }
            catch (IOException e) {
                // empty catch block
            }
        } while (this.username == null || this.username.trim().length() == 0);
        do {
            System.out.print(localStrings.getLocalString("enterprise.security.login.password", "Password: "));
            try {
                this.password = d.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (this.password == null || this.password.trim().length() == 0);
    }

    public TextLoginDialog(Callback[] callbacks) {
        try {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    System.err.print(nc.getPrompt());
                    System.err.flush();
                    nc.setName(new BufferedReader(new InputStreamReader(System.in)).readLine());
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    char[] passwd = null;
                    Object consoleObj = null;
                    Method readPasswordMethod = null;
                    try {
                        Method consoleMethod = System.class.getMethod("console", new Class[0]);
                        consoleObj = consoleMethod.invoke(null, new Object[0]);
                        readPasswordMethod = consoleObj.getClass().getMethod("readPassword", String.class, Array.newInstance(Object.class, 1).getClass());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (consoleObj != null && readPasswordMethod != null) {
                        passwd = (char[])readPasswordMethod.invoke(consoleObj, "%s", new Object[]{pc.getPrompt()});
                    } else {
                        System.err.print(pc.getPrompt());
                        System.err.flush();
                        String psswd = new BufferedReader(new InputStreamReader(System.in)).readLine();
                        if (psswd != null) {
                            passwd = psswd.toCharArray();
                        }
                    }
                    if (passwd == null) continue;
                    pc.setPassword(passwd);
                    Arrays.fill(passwd, ' ');
                    continue;
                }
                if (!(callbacks[i] instanceof ChoiceCallback)) continue;
                ChoiceCallback cc = (ChoiceCallback)callbacks[i];
                String lbl = localStrings.getLocalString("enterprise.security.keystore", "Enter the KeyStore Password ");
                String keystorePass = SSLUtils.getKeyStorePass();
                System.out.println(lbl + " : (max 3 tries)");
                int cnt = 0;
                for (cnt = 0; cnt < 3; ++cnt) {
                    System.out.println(lbl + " : ");
                    String kp = new BufferedReader(new InputStreamReader(System.in)).readLine();
                    if (kp.equals(keystorePass)) break;
                    String errmessage = localStrings.getLocalString("enterprise.security.IncorrectKeystorePassword", "Incorrect Keystore Password");
                    System.err.println(errmessage);
                }
                if (cnt >= 3) {
                    cc.setSelectedIndex(-1);
                    continue;
                }
                System.err.println(cc.getPrompt());
                System.err.flush();
                String[] choices = cc.getChoices();
                for (int j = 0; j < choices.length; ++j) {
                    System.err.print("[" + j + "] ");
                    System.err.println(choices[j]);
                }
                String line = new BufferedReader(new InputStreamReader(System.in)).readLine();
                int sel = new Integer(line);
                cc.setSelectedIndex(sel);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "java_security.name_password_entry_exception", e);
        }
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(TextLoginDialog.class);
    }
}

