/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac.config;

import com.sun.enterprise.security.jmac.config.EntryInfo;
import com.sun.enterprise.security.jmac.config.GFServerConfigProvider;
import com.sun.enterprise.security.jmac.config.RegStoreFileParser;
import com.sun.enterprise.security.jmac.config.RegistrationContextImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFAuthConfigFactory
extends AuthConfigFactory {
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");
    private static ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private static Lock rLock = rwLock.readLock();
    private static Lock wLock = rwLock.writeLock();
    private static Map<String, AuthConfigProvider> id2ProviderMap;
    private static Map<String, AuthConfigFactory.RegistrationContext> id2RegisContextMap;
    private static Map<String, List<RegistrationListener>> id2RegisListenersMap;
    private static Map<AuthConfigProvider, List<String>> provider2IdsMap;
    private static final String CONF_FILE_NAME = "auth.conf";
    private static final RegStoreFileParser regStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        AuthConfigProvider provider = null;
        String regisID = GFAuthConfigFactory.getRegistrationID(layer, appContext);
        try {
            rLock.lock();
            provider = id2ProviderMap.get(regisID);
            if (provider == null) {
                provider = id2ProviderMap.get(GFAuthConfigFactory.getRegistrationID(null, appContext));
            }
            if (provider == null) {
                provider = id2ProviderMap.get(GFAuthConfigFactory.getRegistrationID(layer, null));
            }
            if (provider == null) {
                provider = id2ProviderMap.get(GFAuthConfigFactory.getRegistrationID(null, null));
            }
        }
        finally {
            rLock.unlock();
        }
        if (listener != null) {
            List<RegistrationListener> listeners;
            boolean lregister = false;
            try {
                rLock.lock();
                listeners = id2RegisListenersMap.get(regisID);
                if (listeners != null) {
                    lregister = listeners.contains(listener);
                }
            }
            finally {
                rLock.unlock();
            }
            if (!lregister) {
                try {
                    wLock.lock();
                    listeners = id2RegisListenersMap.get(regisID);
                    if (listeners == null) {
                        listeners = new ArrayList<RegistrationListener>();
                        id2RegisListenersMap.put(regisID, listeners);
                    }
                    if (!listeners.contains(listener)) {
                        listeners.add(listener);
                    }
                }
                finally {
                    wLock.unlock();
                }
            }
        }
        return provider;
    }

    public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description) {
        AuthConfigProvider provider = GFAuthConfigFactory._constructProvider(className, properties, null);
        return GFAuthConfigFactory._register(provider, properties, layer, appContext, description, true);
    }

    public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description) {
        return GFAuthConfigFactory._register(provider, null, layer, appContext, description, false);
    }

    public boolean removeRegistration(String registrationID) {
        return GFAuthConfigFactory._unRegister(registrationID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] detachListener(RegistrationListener listener, String layer, String appContext) {
        String regisID = GFAuthConfigFactory.getRegistrationID(layer, appContext);
        try {
            String[] stringArray;
            wLock.lock();
            RegistrationListener ler = null;
            List<RegistrationListener> listeners = id2RegisListenersMap.get(regisID);
            if (listeners != null && listeners.remove(listener)) {
                ler = listener;
            }
            if (ler != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = regisID;
            } else {
                stringArray = new String[]{};
            }
            String[] stringArray3 = stringArray;
            return stringArray3;
        }
        finally {
            wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRegistrationIDs(AuthConfigProvider provider) {
        try {
            rLock.lock();
            HashSet<String> regisIDs = null;
            if (provider != null) {
                regisIDs = (HashSet<String>)((Object)provider2IdsMap.get(provider));
            } else {
                Collection<List<String>> collList = provider2IdsMap.values();
                if (collList != null) {
                    regisIDs = new HashSet<String>();
                    for (List<String> listIds : collList) {
                        if (listIds == null) continue;
                        regisIDs.addAll(listIds);
                    }
                }
            }
            String[] stringArray = regisIDs != null ? regisIDs.toArray(new String[regisIDs.size()]) : new String[]{};
            return stringArray;
        }
        finally {
            rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        try {
            rLock.lock();
            AuthConfigFactory.RegistrationContext registrationContext = id2RegisContextMap.get(registrationID);
            return registrationContext;
        }
        finally {
            rLock.unlock();
        }
    }

    public void refresh() {
        this._loadFactory();
    }

    static List<EntryInfo> getDefaultProviders() {
        ArrayList<EntryInfo> entries = new ArrayList<EntryInfo>(1);
        entries.add(new EntryInfo(GFServerConfigProvider.class.getName(), null));
        return entries;
    }

    private static String getRegistrationID(String layer, String appContext) {
        String regisID = null;
        regisID = layer != null ? (appContext != null ? "__3" + layer.length() + "_" + layer + appContext : "__2" + layer) : (appContext != null ? "__1" + appContext : "__0");
        return regisID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] decomposeRegisID(String regisID) {
        int n;
        String layer = null;
        String appContext = null;
        if (regisID.equals("__0")) return new String[]{layer, appContext};
        if (regisID.startsWith("__1")) {
            appContext = regisID.length() == 3 ? "" : regisID.substring(3);
            return new String[]{layer, appContext};
        }
        if (regisID.startsWith("__2")) {
            layer = regisID.length() == 3 ? "" : regisID.substring(3);
            return new String[]{layer, appContext};
        }
        if (!regisID.startsWith("__3")) throw new IllegalArgumentException();
        int ind = regisID.indexOf(95, 3);
        if (regisID.length() <= 3 || ind <= 0) throw new IllegalArgumentException();
        String numberString = regisID.substring(3, ind);
        try {
            n = Integer.parseInt(numberString);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
        layer = regisID.substring(ind + 1, ind + 1 + n);
        appContext = regisID.substring(ind + 1 + n);
        return new String[]{layer, appContext};
    }

    private static AuthConfigProvider _constructProvider(String className, Map properties, AuthConfigFactory factory) {
        AuthConfigProvider provider;
        block4: {
            provider = null;
            if (className != null) {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> c = Class.forName(className, true, loader);
                    Constructor<?> constr = c.getConstructor(Map.class, AuthConfigFactory.class);
                    provider = (AuthConfigProvider)constr.newInstance(properties, factory);
                }
                catch (Exception ex) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Cannot load AuthConfigProvider: " + className, ex);
                    }
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.log(Level.WARNING, "jmac.factory_unable_to_load_provider", new String[]{className, ex.toString()});
                }
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _register(AuthConfigProvider provider, Map properties, String layer, String appContext, String description, boolean persist) {
        String regisID = GFAuthConfigFactory.getRegistrationID(layer, appContext);
        RegistrationContextImpl rc = new RegistrationContextImpl(layer, appContext, description, persist);
        AuthConfigFactory.RegistrationContext prevRegisContext = null;
        List<RegistrationListener> listeners = null;
        try {
            List<String> regisIDs;
            wLock.lock();
            prevRegisContext = id2RegisContextMap.get(regisID);
            AuthConfigProvider prevProvider = id2ProviderMap.get(regisID);
            id2ProviderMap.put(regisID, provider);
            id2RegisContextMap.put(regisID, rc);
            if (prevProvider != null) {
                List<String> prevRegisIDs = provider2IdsMap.get(prevProvider);
                prevRegisIDs.remove(regisID);
                if (!prevProvider.equals(provider) && prevRegisIDs.size() == 0) {
                    provider2IdsMap.remove(prevProvider);
                }
            }
            if ((regisIDs = provider2IdsMap.get(provider)) == null) {
                regisIDs = new ArrayList<String>();
                provider2IdsMap.put(provider, regisIDs);
            }
            regisIDs.add(regisID);
            if (provider != null && !provider.equals(prevProvider) || provider == null && prevProvider != null) {
                listeners = id2RegisListenersMap.get(regisID);
            }
        }
        finally {
            wLock.unlock();
            if (persist) {
                GFAuthConfigFactory._storeRegistration(regisID, rc, provider, properties);
            } else if (prevRegisContext != null && prevRegisContext.isPersistent()) {
                GFAuthConfigFactory._deleteStoredRegistration(regisID, prevRegisContext);
            }
        }
        if (listeners != null && listeners.size() > 0) {
            for (RegistrationListener listener : listeners) {
                listener.notify(layer, appContext);
            }
        }
        return regisID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean _unRegister(String regisID) {
        boolean rvalue = false;
        AuthConfigFactory.RegistrationContext rc = null;
        List<RegistrationListener> listeners = null;
        String[] dIds = GFAuthConfigFactory.decomposeRegisID(regisID);
        try {
            wLock.lock();
            rc = id2RegisContextMap.remove(regisID);
            AuthConfigProvider provider = id2ProviderMap.remove(regisID);
            List<String> regisIDs = provider2IdsMap.get(provider);
            if (regisIDs != null) {
                regisIDs.remove(regisID);
            }
            if (regisIDs == null || regisIDs.size() == 0) {
                provider2IdsMap.remove(provider);
            }
            listeners = id2RegisListenersMap.remove(regisID);
            rvalue = provider != null;
        }
        finally {
            wLock.unlock();
            if (rc != null && rc.isPersistent()) {
                GFAuthConfigFactory._deleteStoredRegistration(regisID, rc);
            }
        }
        if (listeners != null && listeners.size() > 0) {
            for (RegistrationListener listener : listeners) {
                listener.notify(dIds[0], dIds[1]);
            }
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadFactory() {
        block9: {
            try {
                wLock.lock();
                id2ProviderMap = new HashMap<String, AuthConfigProvider>();
                id2RegisContextMap = new HashMap<String, AuthConfigFactory.RegistrationContext>();
                id2RegisListenersMap = new HashMap<String, List<RegistrationListener>>();
                provider2IdsMap = new HashMap<AuthConfigProvider, List<String>>();
            }
            finally {
                wLock.unlock();
            }
            try {
                for (EntryInfo info : regStore.getPersistedEntries()) {
                    if (info.isConstructorEntry()) {
                        GFAuthConfigFactory._constructProvider(info.getClassName(), info.getProperties(), this);
                        continue;
                    }
                    for (AuthConfigFactory.RegistrationContext ctx : info.getRegContexts()) {
                        this.registerConfigProvider(info.getClassName(), info.getProperties(), ctx.getMessageLayer(), ctx.getAppContext(), ctx.getDescription());
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block9;
                logger.log(Level.WARNING, "jmac.factory_auth_config_loader_failure");
            }
        }
    }

    private static void _storeRegistration(String regId, AuthConfigFactory.RegistrationContext ctx, AuthConfigProvider p, Map properties) {
        String className = null;
        if (p != null) {
            className = p.getClass().getName();
        }
        if (ctx.isPersistent()) {
            regStore.store(className, ctx, properties);
        }
    }

    private static void _deleteStoredRegistration(String regId, AuthConfigFactory.RegistrationContext ctx) {
        if (ctx.isPersistent()) {
            regStore.delete(ctx);
        }
    }

    static {
        regStore = new RegStoreFileParser(System.getProperty("user.dir"), CONF_FILE_NAME, false);
        GFAuthConfigFactory slave = new GFAuthConfigFactory();
        slave._loadFactory();
    }
}

