/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deployment.Group;
import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.CachedPermission;
import com.sun.enterprise.security.CachedPermissionImpl;
import com.sun.enterprise.security.PermissionCache;
import com.sun.enterprise.security.PermissionCacheFactory;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.web.integration.WebPermissionUtil;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import com.sun.enterprise.server.ServerContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class WebSecurityManager {
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    @Inject
    private AuditManager auditManager;
    public static final String CONSTRAINT_URI = "org.apache.catalina.CONSTRAINT_URI";
    private static final String RESOURCE = "hasResourcePermission";
    private static final String USERDATA = "hasUserDataPermission";
    private static final String ROLEREF = "hasRoleRefPermission";
    private static final String DEFAULT_PATTERN = "/";
    private static final String EMPTY_STRING = "";
    private static final PolicyContextHandlerImpl pcHandlerImpl = (PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance();
    private static final Map ADMIN_PRINCIPAL = new HashMap();
    private static final Map ADMIN_GROUP = new HashMap();
    private String CONTEXT_ID = null;
    private String CODEBASE = null;
    protected Policy policy = Policy.getPolicy();
    protected PolicyConfiguration policyConfiguration = null;
    protected PolicyConfigurationFactory policyConfigurationFactory = null;
    protected CodeSource codesource = null;
    private Map protectionDomainCache = Collections.synchronizedMap(new WeakHashMap());
    private static WebResourcePermission allResources = new WebResourcePermission("/*", (String)null);
    private static WebUserDataPermission allConnections = new WebUserDataPermission("/*", null);
    private static Permission[] protoPerms = new Permission[]{allResources, allConnections};
    private CachedPermission allResourcesCP = null;
    private CachedPermission allConnectionsCP = null;
    private PermissionCache uncheckedPermissionCache = null;
    private static Set defaultPrincipalSet = SecurityContext.getDefaultSecurityContext().getPrincipalSet();
    private static SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryMgr.getFactory();
    private ServerContext serverContext = null;
    private WebBundleDescriptor wbd = null;
    public static final String ADMIN_VS = "__asadmin";

    public WebSecurityManager(WebBundleDescriptor wbd) throws PolicyContextException {
        this.wbd = wbd;
        this.CONTEXT_ID = WebSecurityManager.getContextID(wbd);
        String appname = this.getAppId();
        factory.setAppNameForContext(appname, this.CONTEXT_ID);
        this.initialise();
    }

    public WebSecurityManager(WebBundleDescriptor wbd, ServerContext svc) throws PolicyContextException {
        this.wbd = wbd;
        this.CONTEXT_ID = WebSecurityManager.getContextID(wbd);
        String appname = this.getAppId();
        this.serverContext = svc;
        factory.setAppNameForContext(appname, this.CONTEXT_ID);
        this.initialise();
    }

    private String removeSpaces(String withSpaces) {
        return withSpaces.replace(' ', '_');
    }

    public static String getContextID(WebBundleDescriptor wbd) {
        String cid = null;
        if (wbd != null) {
            String moduleId = wbd.getUniqueFriendlyId();
            cid = wbd.getApplication().getRegistrationName() + '/' + wbd.getUniqueFriendlyId();
        }
        return cid;
    }

    private void initialise() throws PolicyContextException {
        boolean inService;
        LoginConfiguration lgConf;
        String appName = this.wbd.getApplication().getRegistrationName();
        this.CODEBASE = this.removeSpaces(this.CONTEXT_ID);
        if (ADMIN_VS.equals(this.getVirtualServers(appName)) && (lgConf = this.wbd.getLoginConfiguration()) != null) {
            SecurityRoleMapping[] sr;
            String realmName = lgConf.getRealmName();
            SunWebApp sunDes = this.wbd.getSunDescriptor();
            if (sunDes != null && (sr = sunDes.getSecurityRoleMapping()) != null) {
                for (int i = 0; i < sr.length; ++i) {
                    String[] principal = sr[i].getPrincipalName();
                    if (principal != null) {
                        for (int plen = 0; plen < principal.length; ++plen) {
                            ADMIN_PRINCIPAL.put(realmName + principal[plen], new PrincipalImpl(principal[plen]));
                        }
                    }
                    List groups = sr[i].getGroupNames();
                    for (int glen = 0; glen < groups.size(); ++glen) {
                        ADMIN_GROUP.put(realmName + (String)groups.get(glen), new Group((String)groups.get(glen)));
                    }
                }
            }
        }
        try {
            URI uri = null;
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "[Web-Security] Creating a Codebase URI with = " + this.CODEBASE);
                }
                if ((uri = new URI("file:///" + this.CODEBASE)) != null) {
                    this.codesource = new CodeSource(new URL(uri.toString()), (Certificate[])null);
                }
            }
            catch (URISyntaxException use) {
                logger.log(Level.FINE, "[Web-Security] Error Creating URI ", use);
                throw new RuntimeException(use);
            }
        }
        catch (MalformedURLException mue) {
            logger.log(Level.SEVERE, "ejbsm.codesourceerror", mue);
            throw new RuntimeException(mue);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[Web-Security] Context id (id under which  WEB component in application will be created) = " + this.CONTEXT_ID);
            logger.fine("[Web-Security] Codebase (module id for web component) " + this.CODEBASE);
        }
        if (!(inService = this.getFactory().inService(this.CONTEXT_ID))) {
            this.policyConfiguration = this.getFactory().getPolicyConfiguration(this.CONTEXT_ID, false);
            this.generatePermissions();
        }
        if (this.uncheckedPermissionCache == null) {
            this.uncheckedPermissionCache = PermissionCacheFactory.createPermissionCache(this.CONTEXT_ID, this.codesource, protoPerms, null);
            if (this.uncheckedPermissionCache != null) {
                this.allResourcesCP = new CachedPermissionImpl(this.uncheckedPermissionCache, (Permission)allResources);
                this.allConnectionsCP = new CachedPermissionImpl(this.uncheckedPermissionCache, (Permission)allConnections);
            }
        } else {
            this.uncheckedPermissionCache.reset();
        }
    }

    private String getAppId() {
        return this.wbd.getApplication().getRegistrationName();
    }

    public boolean permitAll(HttpServletRequest req) {
        WebResourcePermission webResPerm = new WebResourcePermission(req);
        boolean ret = this.uncheckedPermissionCache.checkPermission((Permission)webResPerm);
        if (!ret) {
            ret = this.checkPermissionWithoutCache((Permission)webResPerm, null);
        }
        return ret;
    }

    protected boolean checkPermission(Permission perm, Set principalSet) {
        boolean ret = this.uncheckedPermissionCache.checkPermission(perm);
        if (!ret) {
            ret = this.checkPermissionWithoutCache(perm, principalSet);
        } else {
            try {
                WebSecurityManager.setPolicyContext(this.CONTEXT_ID);
            }
            catch (Throwable t) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "[Web-Security] Web Permission Access Denied.", t);
                }
                ret = false;
            }
        }
        return ret;
    }

    private boolean checkPermissionWithoutCache(Permission perm, Set principalSet) {
        try {
            WebSecurityManager.setPolicyContext(this.CONTEXT_ID);
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[Web-Security] Web Permission Access Denied.", t);
            }
            return false;
        }
        ProtectionDomain prdm = (ProtectionDomain)this.protectionDomainCache.get(principalSet);
        if (prdm == null) {
            Principal[] principals = null;
            Principal[] principalArray = principals = principalSet == null ? null : principalSet.toArray(new Principal[0]);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[Web-Security] Generating a protection domain for Permission check.");
                if (principals != null) {
                    for (int i = 0; i < principals.length; ++i) {
                        logger.log(Level.FINE, "[Web-Security] Checking with Principal : " + ((Object)principals[i]).toString());
                    }
                } else {
                    logger.log(Level.FINE, "[Web-Security] Checking with Principals: null");
                }
            }
            prdm = new ProtectionDomain(this.codesource, null, null, principals);
            this.protectionDomainCache.put(principalSet, prdm);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] Codesource with Web URL: " + this.codesource.getLocation().toString());
            logger.log(Level.FINE, "[Web-Security] Checking Web Permission with Principals : " + this.principalSetToString(principalSet));
            logger.log(Level.FINE, "[Web-Security] Web Permission = " + perm.toString());
        }
        return this.policy.implies(prdm, perm);
    }

    protected PolicyConfigurationFactory getFactory() throws PolicyContextException {
        if (this.policyConfigurationFactory == null) {
            try {
                this.policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            }
            catch (ClassNotFoundException ex) {
                throw new PolicyContextException((Throwable)ex);
            }
        }
        return this.policyConfigurationFactory;
    }

    private WebResourcePermission createWebResourcePermission(HttpServletRequest httpsr) {
        String uri = (String)httpsr.getAttribute(CONSTRAINT_URI);
        if (uri == null) {
            uri = httpsr.getRequestURI();
        }
        if (uri == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[Web-Security] mappedUri is null");
            }
            throw new RuntimeException("Fatal Error in creating WebResourcePermission");
        }
        if (uri.equals(DEFAULT_PATTERN)) {
            uri = EMPTY_STRING;
        }
        WebResourcePermission perm = new WebResourcePermission(uri, httpsr.getMethod());
        return perm;
    }

    public boolean hasResourcePermission(HttpServletRequest httpsr) {
        SecurityContext sc = this.getSecurityContext(httpsr.getUserPrincipal());
        WebResourcePermission perm = this.createWebResourcePermission(httpsr);
        this.setSecurityInfo(httpsr);
        boolean isGranted = this.checkPermission((Permission)perm, sc.getPrincipalSet());
        SecurityContext.setCurrent(sc);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasResource isGranted: " + isGranted);
            logger.log(Level.FINE, "[Web-Security] hasResource perm: " + perm);
        }
        if (this.auditManager != null && this.auditManager.isAuditOn()) {
            Principal prin = httpsr.getUserPrincipal();
            String user = prin != null ? prin.getName() : null;
            this.auditManager.webInvocation(user, httpsr, RESOURCE, isGranted);
        }
        return isGranted;
    }

    public boolean hasRoleRefPermission(String servletName, String role, Principal p) {
        Set principalSet = this.getSecurityContext(p).getPrincipalSet();
        WebRoleRefPermission perm = new WebRoleRefPermission(servletName, role);
        boolean isGranted = this.checkPermission((Permission)perm, principalSet);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasRoleRef perm: " + perm);
            logger.log(Level.FINE, "[Web-Security] hasRoleRef isGranted: " + isGranted);
        }
        return isGranted;
    }

    public int hasUserDataPermission(HttpServletRequest httpsr) {
        this.setSecurityInfo(httpsr);
        WebUserDataPermission perm = new WebUserDataPermission(httpsr);
        boolean isGranted = this.checkPermission((Permission)perm, defaultPrincipalSet);
        int result = 0;
        if (isGranted) {
            result = 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasUserDataPermission perm: " + perm);
            logger.log(Level.FINE, "[Web-Security] hasUserDataPermission isGranted: " + isGranted);
        }
        if (this.auditManager != null && this.auditManager.isAuditOn()) {
            Principal prin = httpsr.getUserPrincipal();
            String user = prin != null ? prin.getName() : null;
            this.auditManager.webInvocation(user, httpsr, USERDATA, isGranted);
        }
        if (!isGranted && (isGranted = this.checkPermission((Permission)(perm = new WebUserDataPermission(perm.getName(), new String[]{httpsr.getMethod()}, "CONFIDENTIAL")), defaultPrincipalSet))) {
            result = -1;
        }
        return result;
    }

    private void generatePermissions() {
        try {
            WebPermissionUtil.processConstraints(this.wbd, this.policyConfiguration);
            WebPermissionUtil.createWebRoleRefPermission(this.wbd, this.policyConfiguration);
        }
        catch (PolicyContextException pce) {
            logger.log(Level.FINE, "[Web-Security] FATAL Permission Generation: " + pce.getMessage());
            throw new RuntimeException("Fatal error creating web permissions", pce);
        }
    }

    public void destroy() throws PolicyContextException {
        boolean wasInService = this.getFactory().inService(this.CONTEXT_ID);
        if (this.policyConfiguration == null) {
            this.policyConfiguration = this.getFactory().getPolicyConfiguration(this.CONTEXT_ID, false);
        }
        if (wasInService) {
            this.policy.refresh();
            PermissionCacheFactory.removePermissionCache(this.uncheckedPermissionCache);
            this.uncheckedPermissionCache = null;
        }
        factory.removeAppNameForContext(this.CONTEXT_ID);
        WebSecurityManagerFactory.getInstance().removeWebSecurityManager(this.CONTEXT_ID);
    }

    private static String setPolicyContext(final String ctxID) throws Throwable {
        String old = PolicyContext.getContextID();
        if (!(old == ctxID || old != null && ctxID != null && old.equals(ctxID))) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("[Web-Security] Setting Policy Context ID: old = " + old + " ctxID = " + ctxID);
            }
            try {
                AppservAccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        PolicyContext.setContextID((String)ctxID);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof AccessControlException) {
                    logger.log(Level.SEVERE, "[Web-Security] setPolicy SecurityPermission required to call PolicyContext.setContextID", cause);
                } else {
                    logger.log(Level.SEVERE, "[Web-Security] Unexpected Exception while setting policy context", cause);
                }
                throw cause;
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("[Web-Security] Policy Context ID was: " + old);
        }
        return old;
    }

    private SecurityContext getSecurityContext(Principal principal) {
        SecurityContext secContext = null;
        if (principal != null) {
            if (principal instanceof WebPrincipal) {
                WebPrincipal wp = (WebPrincipal)((Object)principal);
                secContext = wp.getSecurityContext();
            } else {
                secContext = new SecurityContext(principal.getName(), null);
            }
        }
        if (secContext == null) {
            secContext = SecurityContext.getDefaultSecurityContext();
        }
        return secContext;
    }

    private void setSecurityInfo(HttpServletRequest httpRequest) {
        if (httpRequest != null) {
            pcHandlerImpl.getHandlerData().setHttpServletRequest(httpRequest);
        }
    }

    private String principalSetToString(Set principalSet) {
        String result = null;
        if (principalSet != null) {
            Principal[] principals = principalSet.toArray(new Principal[0]);
            for (int i = 0; i < principals.length; ++i) {
                result = i == 0 ? ((Object)principals[i]).toString() : result + ", " + new String(((Object)principals[i]).toString());
            }
        }
        return result;
    }

    private String getVirtualServers(String appName) {
        String ret = null;
        Server server = (Server)this.serverContext.getDefaultHabitat().getComponent(Server.class);
        for (ApplicationRef appRef : server.getApplicationRef()) {
            if (!appRef.getRef().equals(appName)) continue;
            return appRef.getVirtualServers();
        }
        return ret;
    }

    public static Principal getAdminPrincipal(String username, String realmName) {
        return (Principal)ADMIN_PRINCIPAL.get(realmName + username);
    }

    public static Principal getAdminGroup(String group, String realmName) {
        return (Principal)ADMIN_GROUP.get(realmName + group);
    }

    public boolean hasNoConstrainedResources() {
        if (this.allResourcesCP != null && this.allConnectionsCP != null) {
            boolean x = this.allResourcesCP.checkPermission();
            boolean y = this.allConnectionsCP.checkPermission();
            return x && y;
        }
        return false;
    }
}

