/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import com.sun.hk2.component.CompanionSeed;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.FactoryWomb;
import com.sun.hk2.component.LazyInhabitant;
import com.sun.hk2.component.ScopeInstance;
import java.lang.annotation.Annotation;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.FactoryFor;
import org.jvnet.hk2.component.CageBuilder;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Habitat {
    private final MultiMap<String, NamedInhabitant> byContract = new MultiMap();
    private final MultiMap<String, Inhabitant> byType = new MultiMap();
    public final ScopeInstance singletonScope = new ScopeInstance("singleton", new HashMap());

    public Habitat() {
        this.add(new ExistingSingletonInhabitant<Habitat>(Habitat.class, this));
        this.add(new ExistingSingletonInhabitant<CompanionSeed.Registerer>(CompanionSeed.Registerer.class, new CompanionSeed.Registerer(this)));
        this.add(new ExistingSingletonInhabitant<CageBuilder.Registerer>(CageBuilder.Registerer.class, new CageBuilder.Registerer(this)));
    }

    public void add(Inhabitant<?> i) {
        Inhabitant cageBuilder;
        String name = i.typeName();
        this.byType.add(name, i);
        ArrayList<LazyInhabitant> companions = null;
        for (Inhabitant<?> c : this.getInhabitantsByAnnotation(CompanionSeed.class, name)) {
            if (companions == null) {
                companions = new ArrayList<LazyInhabitant>();
            }
            companions.add(CompanionSeed.Registerer.createCompanion(this, i, c));
        }
        i.setCompanions(companions);
        String cageBuilderName = i.metadata().getOne("cageBuilder");
        if (cageBuilderName != null && (cageBuilder = this.byType.getOne(cageBuilderName)) != null) {
            ((CageBuilder)cageBuilder.get()).onEntered(i);
        }
    }

    public void addIndex(Inhabitant<?> i, String index, String name) {
        this.byContract.add(index, new NamedInhabitant(name, i));
        if (index.equals(FactoryFor.class.getName())) {
            FactoryFor ff = i.type().getAnnotation(FactoryFor.class);
            Class<?> targetClass = ff.value();
            FactoryWomb target = new FactoryWomb(targetClass, i, this, MultiMap.<String, String>emptyMap());
            this.add(target);
            this.addIndex(target, targetClass.getName(), null);
        }
    }

    public boolean remove(Inhabitant<?> inhabitant) {
        String name = inhabitant.typeName();
        if (this.byType.get(name).contains(inhabitant)) {
            this.byType.get(name).remove(inhabitant);
        }
        return true;
    }

    public boolean removeIndex(String index, String name) {
        if (this.byContract.containsKey(index)) {
            List<NamedInhabitant> contracted = this.byContract.get(index);
            for (NamedInhabitant i : contracted) {
                if ((i.name != null || name != null) && !i.name.equals(name)) continue;
                return contracted.remove(i);
            }
        }
        return false;
    }

    public boolean isContract(Class<?> type) {
        return this.byContract.containsKey(type.getName());
    }

    public boolean isContract(String fullyQualifiedClassName) {
        return this.byContract.containsKey(fullyQualifiedClassName);
    }

    public <T> Collection<T> getAllByContract(Class<T> contractType) {
        final List<NamedInhabitant> l = this.byContract.get(contractType.getName());
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return ((NamedInhabitant)l.get((int)index)).inhabitant.get();
            }

            @Override
            public int size() {
                return l.size();
            }
        };
    }

    public <T> Collection<T> getAllByType(Class<T> implType) {
        final List<Inhabitant> l = this.byType.get(implType.getName());
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return ((Inhabitant)l.get(index)).get();
            }

            @Override
            public int size() {
                return l.size();
            }
        };
    }

    public <T> void addComponent(String name, T component) throws ComponentException {
        this.add(new ExistingSingletonInhabitant<T>(component));
    }

    public <T> T getComponent(Class<T> clazz) throws ComponentException {
        return this.getByType(clazz);
    }

    public <T> T getComponent(Class<T> contract, String name) throws ComponentException {
        Inhabitant<T> i;
        if (name != null && name.length() == 0) {
            name = null;
        }
        if ((i = this.getInhabitant(contract, name)) != null) {
            try {
                return contract.cast(i.get());
            }
            catch (ClassCastException e) {
                Logger.getAnonymousLogger().severe("ClassCastException between contract " + contract + " and service " + i.get());
                Logger.getAnonymousLogger().severe("Contract class loader " + contract.getClassLoader());
                Logger.getAnonymousLogger().severe("Service class loader " + i.get().getClass().getClassLoader());
                throw e;
            }
        }
        return null;
    }

    public <T> Inhabitant<? extends T> getInhabitant(Class<T> contract, String name) throws ComponentException {
        return this._getInhabitant(contract, name);
    }

    public <T> Inhabitant<T> getInhabitantByType(Class<T> implType) {
        return this.getInhabitantByType(implType.getName());
    }

    public Inhabitant<?> getInhabitantByType(String fullyQualifiedClassName) {
        List<Inhabitant> list = this.byType.get(fullyQualifiedClassName);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public Inhabitant<?> getInhabitantByAnnotation(Class<? extends Annotation> contract, String name) throws ComponentException {
        return this._getInhabitant(contract, name);
    }

    public <T> Collection<Inhabitant<? extends T>> getInhabitants(Class<T> contract) throws ComponentException {
        final List<NamedInhabitant> l = this.byContract.get(contract.getName());
        return new AbstractList<Inhabitant<? extends T>>(){

            @Override
            public Inhabitant<? extends T> get(int index) {
                return ((NamedInhabitant)l.get((int)index)).inhabitant;
            }

            @Override
            public int size() {
                return l.size();
            }
        };
    }

    public <T> Collection<Inhabitant<T>> getInhabitantsByType(Class<T> implType) throws ComponentException {
        return this.byType.get(implType.getName());
    }

    public Collection<Inhabitant<?>> getInhabitantsByType(String fullyQualifiedClassName) {
        return this.byType.get(fullyQualifiedClassName);
    }

    private Inhabitant _getInhabitant(Class contract, String name) {
        for (NamedInhabitant i : this.byContract.get(contract.getName())) {
            if (!Habitat.eq(i.name, name)) continue;
            return i.inhabitant;
        }
        return null;
    }

    public <T> Iterable<Inhabitant<? extends T>> getInhabitants(Class<T> contract, String name) throws ComponentException {
        return this._getInhabitants(contract, name);
    }

    public Iterable<Inhabitant<?>> getInhabitantsByAnnotation(Class<? extends Annotation> contract, String name) throws ComponentException {
        return this._getInhabitants(contract, name);
    }

    private Iterable _getInhabitants(final Class contract, final String name) {
        return new Iterable<Inhabitant>(){
            private final Iterable<NamedInhabitant> base;
            {
                this.base = Habitat.this.byContract.get(contract.getName());
            }

            @Override
            public Iterator<Inhabitant> iterator() {
                return new Iterator<Inhabitant>(){
                    private Inhabitant i = null;
                    private final Iterator<NamedInhabitant> itr = 4.access$100(this).iterator();

                    @Override
                    public boolean hasNext() {
                        while (this.i == null && this.itr.hasNext()) {
                            NamedInhabitant ni = this.itr.next();
                            if (!Habitat.eq(ni.name, name)) continue;
                            this.i = ni.inhabitant;
                        }
                        return this.i != null;
                    }

                    @Override
                    public Inhabitant next() {
                        if (this.i == null) {
                            throw new NoSuchElementException();
                        }
                        Inhabitant r = this.i;
                        this.i = null;
                        return r;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            static /* synthetic */ Iterable access$100(4 x0) {
                return x0.base;
            }
        };
    }

    private static boolean eq(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public <T> T getByType(Class<T> implType) {
        return this.getBy(implType, this.byType);
    }

    public <T> T getByContract(Class<T> contractType) {
        List<NamedInhabitant> l = this.byContract.get(contractType.getName());
        if (l.isEmpty()) {
            return null;
        }
        return l.get((int)0).inhabitant.get();
    }

    private <T> T getBy(Class<T> implType, MultiMap<String, Inhabitant> index) {
        List<Inhabitant> l = index.get(implType.getName());
        if (l.isEmpty()) {
            return null;
        }
        return l.get(0).get();
    }

    public void release() {
        for (Map.Entry<String, List<Inhabitant>> e : this.byType.entrySet()) {
            for (Inhabitant i : e.getValue()) {
                i.release();
            }
        }
    }

    private static final class NamedInhabitant {
        final String name;
        final Inhabitant inhabitant;

        public NamedInhabitant(String name, Inhabitant inhabitant) {
            this.name = name;
            this.inhabitant = inhabitant;
        }
    }
}

