/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class InjectionManagerImpl
implements InjectionManager {
    @Inject
    private Logger _logger;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InjectionManagerImpl.class);
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationMgr;
    private InitialContext namingCtx;

    public InjectionManagerImpl() {
        try {
            this.namingCtx = new InitialContext();
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
    }

    @Override
    public void injectInstance(Object instance) throws InjectionException {
        JndiNameEnvironment componentEnv;
        ComponentInvocation inv = this.invocationMgr.getCurrentInvocation();
        if (inv != null) {
            componentEnv = this.compEnvManager.getJndiNameEnvironment(inv.getComponentId());
            if (componentEnv == null) {
                throw new InjectionException("No descriptor registered for  current invocation : " + inv);
            }
        } else {
            throw new InjectionException("null invocation context");
        }
        this.inject(instance.getClass(), instance, componentEnv, true);
    }

    @Override
    public void injectInstance(Object instance, JndiNameEnvironment componentEnv) throws InjectionException {
        this.inject(instance.getClass(), instance, componentEnv, true);
    }

    @Override
    public void injectInstance(Object instance, JndiNameEnvironment componentEnv, boolean invokePostConstruct) throws InjectionException {
        this.inject(instance.getClass(), instance, componentEnv, invokePostConstruct);
    }

    @Override
    public void injectClass(Class clazz, JndiNameEnvironment componentEnv) throws InjectionException {
        this.injectClass(clazz, componentEnv, true);
    }

    @Override
    public void injectClass(Class clazz, JndiNameEnvironment componentEnv, boolean invokePostConstruct) throws InjectionException {
        this.inject(clazz, null, componentEnv, invokePostConstruct);
    }

    @Override
    public void invokeInstancePreDestroy(Object instance, JndiNameEnvironment componentEnv) throws InjectionException {
        this.invokePreDestroy(instance.getClass(), instance, componentEnv);
    }

    @Override
    public void invokeInstancePreDestroy(Object instance) throws InjectionException {
        JndiNameEnvironment componentEnv;
        ComponentInvocation inv = this.invocationMgr.getCurrentInvocation();
        if (inv != null) {
            componentEnv = this.compEnvManager.getJndiNameEnvironment(inv.getComponentId());
            if (componentEnv == null) {
                throw new InjectionException("No descriptor registered for  current invocation : " + inv);
            }
        } else {
            throw new InjectionException("null invocation context");
        }
        this.invokePreDestroy(instance.getClass(), instance, componentEnv);
    }

    @Override
    public void invokeClassPreDestroy(Class clazz, JndiNameEnvironment componentEnv) throws InjectionException {
        this.invokePreDestroy(clazz, null, componentEnv);
    }

    private void inject(Class clazz, Object instance, JndiNameEnvironment envDescriptor, boolean invokePostConstruct) throws InjectionException {
        LinkedList<Method> postConstructMethods = new LinkedList<Method>();
        for (Class nextClass = clazz; nextClass != Object.class && nextClass != null; nextClass = nextClass.getSuperclass()) {
            InjectionInfo injInfo = envDescriptor.getInjectionInfoByClass(nextClass.getName());
            if (injInfo.getInjectionResources().size() > 0) {
                this._inject(nextClass, instance, injInfo.getInjectionResources());
            }
            if (!invokePostConstruct || injInfo.getPostConstructMethodName() == null) continue;
            Method postConstructMethod = this.getPostConstructMethod(injInfo, nextClass);
            postConstructMethods.addFirst(postConstructMethod);
        }
        for (Method postConstructMethod : postConstructMethods) {
            this.invokeLifecycleMethod(postConstructMethod, instance);
        }
    }

    private void invokePreDestroy(Class clazz, Object instance, JndiNameEnvironment envDescriptor) throws InjectionException {
        LinkedList<Method> preDestroyMethods = new LinkedList<Method>();
        for (Class nextClass = clazz; nextClass != Object.class && nextClass != null; nextClass = nextClass.getSuperclass()) {
            InjectionInfo injInfo = envDescriptor.getInjectionInfoByClass(nextClass.getName());
            if (injInfo.getPreDestroyMethodName() == null) continue;
            Method preDestroyMethod = this.getPreDestroyMethod(injInfo, nextClass);
            preDestroyMethods.addFirst(preDestroyMethod);
        }
        for (Method preDestroyMethod : preDestroyMethods) {
            this.invokeLifecycleMethod(preDestroyMethod, instance);
        }
    }

    private void _inject(Class clazz, final Object instance, List<InjectionCapable> injectableResources) throws InjectionException {
        for (InjectionCapable next : injectableResources) {
            try {
                final Object value = this.namingCtx.lookup("java:comp/env/" + next.getComponentEnvName());
                for (InjectionTarget target : next.getInjectionTargets()) {
                    if (!clazz.getName().equals(target.getClassName())) continue;
                    if (target.isFieldInjectable()) {
                        final Field f = this.getField(target, clazz);
                        if (Modifier.isStatic(f.getModifiers()) && instance != null) {
                            throw new InjectionException("Illegal use of static field " + f + " on class that only supports instance-based" + " injection");
                        }
                        if (instance == null && !Modifier.isStatic(f.getModifiers())) {
                            throw new InjectionException("Injected field " + f + " on Application Client class " + clazz + " must be declared static");
                        }
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("Injecting dependency with logical name " + next.getComponentEnvName() + " into field " + f + " on class " + clazz);
                        }
                        if (System.getSecurityManager() != null) {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    f.set(instance, value);
                                    return null;
                                }
                            });
                            continue;
                        }
                        f.set(instance, value);
                        continue;
                    }
                    if (!target.isMethodInjectable()) continue;
                    final Method m = this.getMethod(next, target, clazz);
                    if (Modifier.isStatic(m.getModifiers()) && instance != null) {
                        throw new InjectionException("Illegal use of static method " + m + " on class that only supports instance-based" + " injection");
                    }
                    if (instance == null && !Modifier.isStatic(m.getModifiers())) {
                        throw new InjectionException("Injected method " + m + " on Application Client class " + clazz + " must be declared static");
                    }
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine("Injecting dependency with logical name " + next.getComponentEnvName() + " into method " + m + " on class " + clazz);
                    }
                    if (System.getSecurityManager() != null) {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                m.invoke(instance, value);
                                return null;
                            }
                        });
                        continue;
                    }
                    m.invoke(instance, value);
                }
            }
            catch (Throwable t) {
                String msg = "Exception attempting to inject " + next + " into " + clazz;
                this._logger.log(Level.FINE, msg, t);
                InjectionException ie = new InjectionException(msg);
                Throwable cause = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : t;
                ie.initCause(cause);
                throw ie;
            }
        }
    }

    private void invokeLifecycleMethod(final Method lifecycleMethod, final Object instance) throws InjectionException {
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Calling lifeccle method " + lifecycleMethod + " on class " + lifecycleMethod.getDeclaringClass());
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (!lifecycleMethod.isAccessible()) {
                        lifecycleMethod.setAccessible(true);
                    }
                    lifecycleMethod.invoke(instance, new Object[0]);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            String msg = "Exception attempting invoke lifecycle  method " + lifecycleMethod;
            this._logger.log(Level.FINE, msg, t);
            InjectionException ie = new InjectionException(msg);
            Throwable cause = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : t;
            ie.initCause(cause);
            throw ie;
        }
    }

    private Field getField(InjectionTarget target, Class resourceClass) throws Exception {
        Field f = target.getField();
        if (f == null) {
            try {
                final Field finalF = f = resourceClass.getDeclaredField(target.getFieldName());
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!finalF.isAccessible()) {
                            finalF.setAccessible(true);
                        }
                        return null;
                    }
                });
            }
            catch (NoSuchFieldException nsfe) {
                // empty catch block
            }
            if (f != null) {
                target.setField(f);
            }
        }
        if (f == null) {
            throw new Exception("InjectionManager exception.  Field " + target.getFieldName() + " not found in Class " + resourceClass);
        }
        return f;
    }

    private Method getMethod(InjectionCapable resource, InjectionTarget target, Class resourceClass) throws Exception {
        Method m = target.getMethod();
        if (m == null) {
            for (Method next : resourceClass.getDeclaredMethods()) {
                if (!next.getName().equals(target.getMethodName())) continue;
                m = next;
                target.setMethod(m);
                final Method finalM = m;
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!finalM.isAccessible()) {
                            finalM.setAccessible(true);
                        }
                        return null;
                    }
                });
                break;
            }
        }
        if (m == null) {
            throw new Exception("InjectionManager exception.  Method void " + target.getMethodName() + "(" + resource.getInjectResourceType() + ")" + " not found in Class " + resourceClass);
        }
        return m;
    }

    private Method getPostConstructMethod(InjectionInfo injInfo, Class resourceClass) throws InjectionException {
        Method m = injInfo.getPostConstructMethod();
        if (m == null) {
            String postConstructMethodName = injInfo.getPostConstructMethodName();
            for (Method next : resourceClass.getDeclaredMethods()) {
                if (!next.getName().equals(postConstructMethodName) || next.getParameterTypes().length != 0) continue;
                m = next;
                injInfo.setPostConstructMethod(m);
                break;
            }
        }
        if (m == null) {
            throw new InjectionException("InjectionManager exception. PostConstruct method " + injInfo.getPostConstructMethodName() + " could not be found in class " + injInfo.getClassName());
        }
        return m;
    }

    private Method getPreDestroyMethod(InjectionInfo injInfo, Class resourceClass) throws InjectionException {
        Method m = injInfo.getPreDestroyMethod();
        if (m == null) {
            String preDestroyMethodName = injInfo.getPreDestroyMethodName();
            for (Method next : resourceClass.getDeclaredMethods()) {
                if (!next.getName().equals(preDestroyMethodName) || next.getParameterTypes().length != 0) continue;
                m = next;
                injInfo.setPreDestroyMethod(m);
                break;
            }
        }
        if (m == null) {
            throw new InjectionException("InjectionManager exception. PreDestroy method " + injInfo.getPreDestroyMethodName() + " could not be found in class " + injInfo.getClassName());
        }
        return m;
    }
}

